/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.builder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.eclipse.builder.JSSReportContext;
import net.sf.jasperreports.eclipse.builder.JasperReportCompiler;
import net.sf.jasperreports.eclipse.builder.JasperReportErrorHandler;
import net.sf.jasperreports.eclipse.builder.Markers;
import net.sf.jasperreports.eclipse.builder.jdt.JRErrorHandler;
import net.sf.jasperreports.eclipse.util.FileExtension;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRSaver;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.JavaCore;

public class JasperReportsBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "net.sf.jasperreports.builder";
    private JasperReportCompiler reportCompiler = new JasperReportCompiler();
    private Map<IProject, IPath> outmap = new HashMap<IProject, IPath>();
    private JSSReportContext jContext = JSSReportContext.getNewConfig();

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IProject currentProject = this.getProject();
        if (currentProject == null || !currentProject.isAccessible()) {
            return;
        }
        monitor.subTask("Cleaning");
        long stime = System.currentTimeMillis();
        this.getProject().accept((IResourceVisitor)new JRCleanResourceVisitor(monitor));
        long etime = System.currentTimeMillis();
        System.out.println("Cleaned in " + (etime - stime) + " ms");
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.outmap.clear();
        IProject currentProject = this.getProject();
        if (currentProject == null) {
            return new IProject[0];
        }
        switch (kind) {
            case 6: {
                this.fullBuild(monitor);
                break;
            }
            case 15: {
                this.clean(monitor);
                break;
            }
            default: {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                    break;
                }
                this.incrementalBuild(delta, monitor);
            }
        }
        return new IProject[0];
    }

    protected JasperReportErrorHandler getErrorHandler(IFile resource) {
        return new JRErrorHandler(resource);
    }

    public IFile compileJRXML(IResource resource, IProgressMonitor monitor) throws CoreException {
        this.jContext.init(resource);
        return this.compileJRXML(resource, monitor, this.jContext);
    }

    public IFile compileJRXML(IResource resource, IProgressMonitor monitor, SimpleJasperReportsContext jContext) throws CoreException {
        if (!(resource instanceof IFile) || !resource.exists() || resource.getFileExtension() == null) {
            return null;
        }
        if (resource instanceof IFile && resource.getFileExtension().equals("jasper")) {
            return null;
        }
        IProject project = resource.getProject();
        IPath outLocation = this.outmap.get(project);
        if (outLocation != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
            outLocation = JavaCore.create((IProject)project).getOutputLocation();
        }
        if (outLocation != null && outLocation.isPrefixOf(resource.getFullPath())) {
            return null;
        }
        if (resource.getFileExtension().equals("jrxml")) {
            IFile destFile;
            long stime;
            block23: {
                stime = System.currentTimeMillis();
                ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                destFile = null;
                try {
                    String str;
                    if (jContext == null) {
                        jContext = JSSReportContext.getDefaultInstance(resource);
                    }
                    monitor.subTask("Compiling " + resource.getFullPath().toOSString());
                    Markers.deleteMarkers(resource);
                    IFile file = (IFile)resource;
                    ClassLoader cl = (ClassLoader)jContext.getValue("CURRENT_CLASS_LOADER");
                    if (cl != null) {
                        Thread.currentThread().setContextClassLoader(cl);
                    }
                    this.reportCompiler.setErrorHandler(this.getErrorHandler(file));
                    destFile = FileExtension.getCompiledFile(file);
                    JasperReport jasperReport = null;
                    if (file.getLocation().toFile().exists()) {
                        jasperReport = this.reportCompiler.compileReport((JasperReportsContext)jContext, file, monitor);
                    }
                    if (!Misc.isNullOrEmpty(str = jContext.getProperty("com.jaspersoft.studio.jr.compile.version")) && !str.equals("last") && !str.equals(JasperDesign.class.getPackage().getImplementationVersion())) break block23;
                    if (jasperReport == null) {
                        if (destFile.exists()) {
                            destFile.delete(true, false, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                        }
                        break block23;
                    }
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    ByteArrayInputStream compiledInput = null;
                    try {
                        try {
                            JRSaver.saveObject((Object)jasperReport, (OutputStream)bout);
                            compiledInput = new ByteArrayInputStream(bout.toByteArray());
                            if (destFile.exists()) {
                                if (file.isLinked() && !destFile.isLinked()) {
                                    destFile.delete(true, false, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                                    destFile = this.createDestFile(monitor, project, file, destFile, compiledInput);
                                } else {
                                    destFile.setContents((InputStream)compiledInput, true, false, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                                }
                            } else {
                                destFile = this.createDestFile(monitor, project, file, destFile, compiledInput);
                            }
                            if (!destFile.isDerived()) {
                                destFile.setDerived(true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                            }
                        }
                        catch (JRException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeStream(bout);
                        FileUtils.closeStream(compiledInput);
                        throw throwable;
                    }
                    FileUtils.closeStream(bout);
                    FileUtils.closeStream(compiledInput);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldLoader);
                }
            }
            long etime = System.currentTimeMillis();
            System.out.println(String.valueOf(resource.getFullPath().toOSString()) + " " + (etime - stime) + " ms");
            return destFile;
        }
        if (resource.getFileExtension().equals("jasper")) {
            return this.compileJRXML((IResource)FileExtension.getSourceFile((IFile)resource), monitor);
        }
        return null;
    }

    protected IFile createDestFile(IProgressMonitor monitor, IProject project, IFile file, IFile destFile, ByteArrayInputStream compiledInput) throws CoreException {
        if (file.isLinked()) {
            String fpath = file.getLocation().toFile().getAbsolutePath();
            fpath = FileExtension.getCompiledFileName(fpath);
            File f = new File(fpath);
            try {
                f.createNewFile();
                Path location = new Path(fpath);
                String fileName = FilenameUtils.removeExtension((String)file.getName());
                destFile = project.getFile(String.valueOf(fileName) + "." + location.getFileExtension());
                destFile.createLink((IPath)location, 256, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                destFile.setContents((InputStream)compiledInput, true, false, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
            }
            catch (IOException e) {
                e.printStackTrace();
                destFile.create((InputStream)compiledInput, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
            }
        } else {
            destFile.create((InputStream)compiledInput, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
        }
        return destFile;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        long stime = System.currentTimeMillis();
        this.getProject().accept((IResourceVisitor)new JRResourceVisitor(monitor));
        long etime = System.currentTimeMillis();
        System.out.println("Full Build in " + (etime - stime) + " ms");
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new JRDeltaVisitor(monitor));
    }

    class JRCleanResourceVisitor
    implements IResourceVisitor {
        private IProgressMonitor monitor;

        public JRCleanResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.monitor.isCanceled()) {
                return false;
            }
            String ext = resource.getFileExtension();
            if (resource instanceof IProject) {
                Markers.deleteMarkers(resource);
            }
            if (ext != null && resource.exists()) {
                if (ext.equalsIgnoreCase("jrxml")) {
                    Markers.deleteMarkers(resource);
                } else if (resource.isDerived() && ext.equalsIgnoreCase("jasper")) {
                    resource.delete(false, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.monitor));
                }
            }
            return true;
        }
    }

    class JRDeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor monitor;

        public JRDeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (this.monitor.isCanceled()) {
                return false;
            }
            switch (delta.getKind()) {
                case 1: 
                case 2: 
                case 4: {
                    JasperReportsBuilder.this.compileJRXML(delta.getResource(), this.monitor);
                }
            }
            return true;
        }
    }

    class JRResourceVisitor
    implements IResourceVisitor {
        private IProgressMonitor monitor;

        public JRResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.monitor.isCanceled()) {
                return false;
            }
            JasperReportsBuilder.this.compileJRXML(resource, this.monitor);
            return true;
        }
    }
}

