/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.classpath;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import net.sf.jasperreports.eclipse.classpath.ClassLoaderUtil;
import net.sf.jasperreports.eclipse.classpath.container.JRClasspathContainer;
import net.sf.jasperreports.eclipse.util.FileExtension;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;

public class JavaProjectClassLoader
extends ClassLoader {
    public static final String JAVA_PROJECT_CLASS_LOADER_KEY = "javaProjectClassLoader";
    private static final String PROTOCOL_PREFIX = "file:///";
    private static final String FILE_SCHEME = "file";
    private boolean calcURLS = false;
    private static Map<IJavaProject, JavaProjectClassLoader> map = new HashMap<IJavaProject, JavaProjectClassLoader>();
    private URLClassLoader curlLoader;
    private IJavaProject javaProject;
    private IElementChangedListener listener;
    private PropertyChangeSupport events;

    public static ClassLoader instance(IJavaProject project) {
        return JavaProjectClassLoader.instance(project, Thread.currentThread().getContextClassLoader());
    }

    public static JavaProjectClassLoader instance(IJavaProject project, ClassLoader classLoader) {
        JavaProjectClassLoader cl = map.get(project);
        if (cl == null) {
            cl = new JavaProjectClassLoader(project, classLoader);
            map.put(project, cl);
        }
        return cl;
    }

    public static boolean forceClassPathReload(IJavaProject proj) {
        JavaProjectClassLoader jpcl = map.get(proj);
        if (jpcl != null && jpcl.events != null) {
            jpcl.events.firePropertyChange("classpath", false, true);
            return true;
        }
        return false;
    }

    public static boolean canReloadProjectClassPath(IJavaProject proj) {
        return map.get(proj) != null;
    }

    private JavaProjectClassLoader(IJavaProject project) {
        this.init(project);
    }

    private JavaProjectClassLoader(IJavaProject project, ClassLoader classLoader) {
        super(classLoader);
        this.init(project);
    }

    protected void init(IJavaProject project) {
        if (project == null || !project.exists() || !project.getResource().isAccessible()) {
            throw new IllegalArgumentException("Invalid javaProject");
        }
        this.javaProject = project;
        this.getURLClassloader();
        try {
            final IPath prjPath = this.javaProject.getProject().getFullPath();
            final IPath prjOut = this.javaProject.getOutputLocation();
            IResourceChangeListener plistener = new IResourceChangeListener(){

                private boolean checkInPaths(IResourceDelta rd) {
                    IPath fp = rd.getFullPath();
                    if (fp != null) {
                        String rpath;
                        if (prjOut.isPrefixOf(fp) && ((rpath = rd.getProjectRelativePath().lastSegment()).endsWith(".class") || rpath.endsWith(".properties"))) {
                            JavaProjectClassLoader.clean(JavaProjectClassLoader.this.curlLoader);
                            JavaProjectClassLoader.this.curlLoader = null;
                            JavaProjectClassLoader.this.getURLClassloader();
                            if (JavaProjectClassLoader.this.events != null) {
                                System.out.println("Invoking classpath reload");
                                JavaProjectClassLoader.this.events.firePropertyChange("classpath", false, true);
                            }
                            return true;
                        }
                        if (fp.matchingFirstSegments(prjOut) <= 0) {
                            return true;
                        }
                    }
                    return false;
                }

                private void checkResource(IResourceDelta[] children) {
                    IResourceDelta[] iResourceDeltaArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResourceDelta rd = iResourceDeltaArray[n2];
                        if (!prjPath.isPrefixOf(rd.getFullPath())) {
                            return;
                        }
                        if (!Misc.isNullOrEmpty(rd.getAffectedChildren())) {
                            this.checkResource(rd.getAffectedChildren());
                        } else if (this.checkInPaths(rd)) {
                            return;
                        }
                        ++n2;
                    }
                }

                public void resourceChanged(IResourceChangeEvent event) {
                    IResourceDelta delta = event.getDelta();
                    if (delta != null) {
                        this.checkResource(delta.getAffectedChildren());
                    }
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(plistener, 1);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        this.listener = new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent event) {
                if (!this.isClasspathReloadNeeded(event.getDelta())) {
                    return;
                }
                JavaProjectClassLoader.clean(JavaProjectClassLoader.this.curlLoader);
                JavaProjectClassLoader.this.curlLoader = null;
                JavaProjectClassLoader.this.getURLClassloader();
                if (JavaProjectClassLoader.this.events != null && !this.isToIgnore(event.getDelta().getAffectedChildren())) {
                    System.out.println("Invoking classpath reload");
                    JavaProjectClassLoader.this.events.firePropertyChange("classpath", false, true);
                }
            }

            /*
             * Unable to fully structure code
             */
            private boolean isClasspathReloadNeeded(IJavaElementDelta delta) {
                switch (delta.getElement().getElementType()) {
                    case 1: {
                        var5_2 = delta.getAffectedChildren();
                        var4_4 = var5_2.length;
                        var3_6 = 0;
                        while (var3_6 < var4_4) {
                            c = var5_2[var3_6];
                            if (this.isClasspathReloadNeeded(c)) {
                                return true;
                            }
                            ++var3_6;
                        }
                        break;
                    }
                    case 2: {
                        if (delta.getKind() == 2) {
                            JavaProjectClassLoader.map.remove(JavaProjectClassLoader.this.javaProject);
                            JavaCore.removeElementChangedListener((IElementChangedListener)JavaProjectClassLoader.this.listener);
                            return true;
                        }
                        if ((delta.getFlags() & 2229376) != 0) {
                            return true;
                        }
                        var5_3 = delta.getAffectedChildren();
                        var4_5 = var5_3.length;
                        var3_7 = 0;
                        while (var3_7 < var4_5) {
                            c = var5_3[var3_7];
                            if (this.isClasspathReloadNeeded(c)) {
                                return true;
                            }
                            ++var3_7;
                        }
                    }
                    case 3: {
                        if ((delta.getFlags() & 32769) == 0) ** GOTO lbl35
                        if (this.isElementNameAllowed(delta.getElement().getElementName())) {
                            return true;
                        }
                        ** GOTO lbl44
lbl35:
                        // 1 sources

                        var5_3 = delta.getAffectedChildren();
                        var4_5 = var5_3.length;
                        var3_7 = 0;
                        while (var3_7 < var4_5) {
                            c = var5_3[var3_7];
                            if (this.isClasspathReloadNeeded(c)) {
                                return true;
                            }
                            ++var3_7;
                        }
                    }
lbl44:
                    // 3 sources

                    case 4: {
                        var5_3 = delta.getAffectedChildren();
                        var4_5 = var5_3.length;
                        var3_7 = 0;
                        while (var3_7 < var4_5) {
                            c = var5_3[var3_7];
                            if (c.getElement() instanceof IClassFile && (c.getFlags() & 1) != 0 && this.isElementNameAllowed(c.getElement().getElementName())) {
                                return true;
                            }
                            ++var3_7;
                        }
                        break;
                    }
                }
                return false;
            }

            private boolean isToIgnore(IJavaElementDelta[] children) {
                if (children == null || children.length == 0) {
                    return true;
                }
                IJavaElementDelta[] iJavaElementDeltaArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta jdelta = iJavaElementDeltaArray[n2];
                    IResourceDelta[] rd = jdelta.getResourceDeltas();
                    if (!(rd != null && rd.length != 0 || this.isToIgnore(jdelta.getAffectedChildren()))) {
                        return false;
                    }
                    if (rd != null) {
                        IResourceDelta[] iResourceDeltaArray = rd;
                        int n3 = rd.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IResourceDelta delta = iResourceDeltaArray[n4];
                            if (delta.getResource() instanceof IFile) {
                                String fe = delta.getFullPath().getFileExtension();
                                if (!(fe.equals("jasper") || fe.equals("jrxml") || fe.equals("jrtx") || FileExtension.isImage(delta.getFullPath().toOSString()))) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                return true;
            }

            private boolean isElementNameAllowed(String elName) {
                return elName != null && (elName.endsWith(".jar") || elName.endsWith(".class") || elName.endsWith(".properties"));
            }
        };
        JavaCore.addElementChangedListener((IElementChangedListener)this.listener, (int)1);
    }

    public void addClasspathListener(PropertyChangeListener l) {
        if (this.events == null) {
            this.events = new PropertyChangeSupport(this);
        }
        this.events.addPropertyChangeListener(l);
    }

    public void removeClasspathListener(PropertyChangeListener l) {
        if (this.events == null) {
            this.events = new PropertyChangeSupport(this);
        }
        this.events.removePropertyChangeListener(l);
    }

    @Override
    protected URL findResource(String name) {
        if (name.endsWith(".groovy")) {
            return null;
        }
        if (name.endsWith("commons-logging.properties")) {
            return null;
        }
        if (this.curlLoader != null) {
            return this.curlLoader.getResource(name);
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        if (name.endsWith("commons-logging.properties")) {
            return null;
        }
        if (this.curlLoader != null) {
            return this.curlLoader.getResources(name);
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        if (name.endsWith("commons-logging.properties")) {
            return null;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (name.endsWith("commons-logging.properties")) {
            return null;
        }
        return super.getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (name.endsWith("commons-logging.properties")) {
            return null;
        }
        return super.getResourceAsStream(name);
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        if (!"net.sf.jasperreports.compilers.GroovyEvaluator".equals(className)) {
            for (String suffix : ClassLoaderUtil.EXCLUDE_SUFFIXES) {
                if (!className.endsWith(suffix)) continue;
                throw new ClassNotFoundException(className);
            }
            if (ClassLoaderUtil.packages.contains(className)) {
                throw new ClassNotFoundException(className);
            }
        }
        if (this.curlLoader != null) {
            return this.curlLoader.loadClass(className);
        }
        throw new ClassNotFoundException(className);
    }

    private static URL computeForURLClassLoader(String classpath) throws MalformedURLException {
        File file;
        if (!classpath.endsWith("/") && (file = new File(classpath)).exists() && file.isDirectory()) {
            classpath = classpath.concat("/");
        }
        return new URL(PROTOCOL_PREFIX + classpath);
    }

    private ClassLoader getURLClassloader() {
        if (this.curlLoader == null) {
            try {
                if (this.calcURLS) {
                    return this.getParent();
                }
                this.calcURLS = true;
                Set<URL> urls = JavaProjectClassLoader.buildURLs(this.javaProject);
                this.getURLClassloader(urls.toArray(new URL[urls.size()]));
                this.calcURLS = false;
            }
            catch (JavaModelException e1) {
                e1.printStackTrace();
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }
        return this.curlLoader;
    }

    public static Set<URL> buildURLs(IJavaProject javaProject) throws CoreException {
        IClasspathEntry[] ces;
        JRClasspathContainer jrcnt = (JRClasspathContainer)JavaCore.getClasspathContainer((IPath)JRClasspathContainer.ID, (IJavaProject)javaProject);
        ArrayList<String> jrcntpaths = null;
        if (jrcnt != null && (ces = jrcnt.getAllClasspathEntries()) != null && ces.length > 0) {
            jrcntpaths = new ArrayList<String>();
            IClasspathEntry[] iClasspathEntryArray = ces;
            int n = ces.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry en = iClasspathEntryArray[n2];
                jrcntpaths.add(en.getPath().toOSString());
                ++n2;
            }
        }
        String[] classPaths = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        int i = 0;
        while (i < classPaths.length) {
            try {
                if (jrcntpaths == null || !jrcntpaths.contains(classPaths[i])) {
                    urls.add(JavaProjectClassLoader.computeForURLClassLoader(classPaths[i]));
                }
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
        JavaProjectClassLoader.resolveClasspathEntries(urls, root, entries, javaProject);
        return urls;
    }

    public static void resolveClasspathEntries(Set<URL> urls, IWorkspaceRoot root, IClasspathEntry[] entries, IJavaProject javaProject) throws JavaModelException {
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 3) {
                IPath path = entry.getPath();
                if (path.segmentCount() >= 2) {
                    IFolder sourceFolder = root.getFolder(path);
                    try {
                        urls.add(sourceFolder.getRawLocation().toFile().toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            } else if (entry.getEntryKind() == 3) {
                IPath sourcePath = entry.getPath();
                JavaProjectClassLoader.covertPathToUrl(javaProject.getProject(), urls, sourcePath);
                IPath sourceOutputPath = entry.getOutputLocation();
                JavaProjectClassLoader.covertPathToUrl(javaProject.getProject(), urls, sourceOutputPath);
            } else if (entry.getEntryKind() == 5 && !entry.getPath().equals((Object)JRClasspathContainer.ID)) {
                IClasspathContainer cont = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject);
                JavaProjectClassLoader.resolveClasspathEntries(urls, root, cont.getClasspathEntries(), javaProject);
            }
            ++i;
        }
    }

    private static void addUri(Set<URL> paths, URI uri) {
        try {
            File file = new File(uri);
            if (file.isDirectory()) {
                paths.add(new URL(String.valueOf(uri.toString()) + File.separator));
            } else {
                paths.add(uri.toURL());
            }
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private static void covertPathToUrl(IProject project, Set<URL> paths, IPath path) {
        URI uri;
        if (path != null && project != null && path.removeFirstSegments(1) != null && project.findMember(path.removeFirstSegments(1)) != null && (uri = project.findMember(path.removeFirstSegments(1)).getRawLocationURI()) != null) {
            String scheme = uri.getScheme();
            if (FILE_SCHEME.equalsIgnoreCase(scheme)) {
                JavaProjectClassLoader.addUri(paths, uri);
            } else if ("sourcecontrol".equals(scheme)) {
                IPath sourceControlPath = project.findMember(path.removeFirstSegments(1)).getLocation();
                File sourceControlFile = sourceControlPath.toFile();
                if (sourceControlFile.exists()) {
                    JavaProjectClassLoader.addUri(paths, sourceControlFile.toURI());
                }
            } else {
                IPathVariableManager variableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
                JavaProjectClassLoader.addUri(paths, variableManager.resolveURI(uri));
            }
        }
    }

    private synchronized ClassLoader getURLClassloader(URL[] urls) {
        if (this.curlLoader != null) {
            JavaProjectClassLoader.clean(this.curlLoader);
            this.curlLoader = null;
        }
        this.curlLoader = URLClassLoader.newInstance(urls, this.getParent());
        return this.curlLoader;
    }

    public static void clean(URLClassLoader cl) {
        if (cl != null) {
            try {
                cl.close();
                Field f = URLClassLoader.class.getDeclaredField("ucp");
                f.setAccessible(true);
                Object cp = f.get(cl);
                f = cp.getClass().getDeclaredField("loaders");
                f.setAccessible(true);
                Object loaders = f.get(cp);
                if (loaders != null) {
                    for (Object l : (Collection)loaders) {
                        try {
                            f = l.getClass().getDeclaredField("jar");
                            f.setAccessible(true);
                            Object jar = f.get(l);
                            if (!(jar instanceof JarFile)) continue;
                            ((JarFile)jar).close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                f = URLClassLoader.class.getDeclaredField("nativeLibraries");
                f.setAccessible(true);
                Vector nl = (Vector)f.get(cl);
                if (nl != null) {
                    for (Object lib : nl) {
                        Method finalize = lib.getClass().getDeclaredMethod("finalize", new Class[0]);
                        finalize.setAccessible(true);
                        finalize.invoke(lib, new Object[0]);
                    }
                }
            }
            catch (Throwable throwable) {}
        }
    }
}

