/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.classpath.container;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.eclipse.classpath.container.IClasspathContainerFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class ClasspathContainerManager {
    private static List<IClasspathContainerFactory> factoryByNodeType = new ArrayList<IClasspathContainerFactory>();

    public void init() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("net.sf.jasperreports", "classpathcontainer");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o = e.createExecutableExtension("ClassFactory");
                if (o instanceof IClasspathContainerFactory) {
                    IClasspathContainerFactory compFactory = (IClasspathContainerFactory)o;
                    factoryByNodeType.add(compFactory);
                }
            }
            catch (CoreException ex) {
                System.out.println(ex.getMessage());
            }
            ++n2;
        }
    }

    public void createJRClasspathContainer(IProgressMonitor monitor, List<IClasspathEntry> centries, IJavaProject javaProject) throws JavaModelException {
        for (IClasspathContainerFactory f : factoryByNodeType) {
            f.createJRClasspathContainer(monitor, centries, javaProject);
        }
    }

    public Set<Path> getRemovableContainers() {
        HashSet<Path> set = new HashSet<Path>();
        for (IClasspathContainerFactory f : factoryByNodeType) {
            Set<Path> s = f.isRemovable();
            if (s == null || s.isEmpty()) continue;
            set.addAll(s);
        }
        return set;
    }
}

