/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.classpath.container;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.framework.Bundle;

public class JRClasspathContainer
implements IClasspathContainer {
    public static final Path ID = new Path("net.sf.jasperreports.JR_CONTAINER");
    private IPath path;

    public JRClasspathContainer(IPath path, IJavaProject project) {
        this.path = path;
    }

    public IClasspathEntry[] getClasspathEntries() {
        ArrayList<IClasspathEntry> entryList = new ArrayList<IClasspathEntry>();
        Bundle bundle = JasperReportsPlugin.getDefault().getBundle();
        Enumeration urls = bundle.findEntries("lib/", "jasperreports*.jar", true);
        while (urls.hasMoreElements()) {
            URL url = (URL)urls.nextElement();
            try {
                Path binpath;
                URL fileURL = FileLocator.toFileURL((URL)url);
                URI uri = new URI(fileURL.getProtocol(), fileURL.getUserInfo(), fileURL.getHost(), fileURL.getPort(), fileURL.getPath(), fileURL.getQuery(), null);
                Path srcpath = binpath = new Path(new File(uri).getAbsolutePath());
                entryList.add(JavaCore.newLibraryEntry((IPath)binpath, (IPath)srcpath, (IPath)new Path("/")));
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return entryList.toArray(new IClasspathEntry[entryList.size()]);
    }

    public IClasspathEntry[] getAllClasspathEntries() {
        ArrayList<IClasspathEntry> entryList = new ArrayList<IClasspathEntry>();
        Bundle bundle = JasperReportsPlugin.getDefault().getBundle();
        Enumeration urls = bundle.findEntries("lib/", "*.jar", true);
        while (urls.hasMoreElements()) {
            URL url = (URL)urls.nextElement();
            try {
                Path binpath;
                URL fileURL = FileLocator.toFileURL((URL)url);
                URI uri = new URI(fileURL.getProtocol(), fileURL.getUserInfo(), fileURL.getHost(), fileURL.getPort(), fileURL.getPath(), fileURL.getQuery(), null);
                Path srcpath = binpath = new Path(new File(uri).getAbsolutePath());
                entryList.add(JavaCore.newLibraryEntry((IPath)binpath, (IPath)srcpath, (IPath)new Path("/")));
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return entryList.toArray(new IClasspathEntry[entryList.size()]);
    }

    public String getDescription() {
        return "JasperReports Library";
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }
}

