/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.start;

import java.util.ArrayList;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.eclipse.wizard.project.ProjectUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class CleanTempResources
implements IStartup {
    private Job wjob;

    public void earlyStartup() {
        this.wjob = new WorkspaceJob(Messages.CleanTempResources_SearchBrokenLinksTask){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                monitor.beginTask(CleanTempResources.this.wjob.getName(), projects.length);
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject prj = iProjectArray[n2];
                    if (ProjectUtil.isOpen(prj)) {
                        monitor.subTask(String.valueOf(Messages.CleanTempResources_SearchProjectTask) + prj.getName());
                        prj.accept((IResourceProxyVisitor)new ResourceVisitor(monitor), 17);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        monitor.internalWorked(1.0);
                    }
                    ++n2;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (workbenchWindow != null) {
                            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IEditorReference[] refs = activePage.getEditorReferences();
                            ArrayList<IEditorReference> toclose = new ArrayList<IEditorReference>();
                            IEditorReference[] iEditorReferenceArray = refs;
                            int n = refs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IEditorReference er = iEditorReferenceArray[n2];
                                try {
                                    IEditorInput input = er.getEditorInput();
                                    if (input instanceof FileEditorInput && !((FileEditorInput)input).getFile().exists()) {
                                        toclose.add(er);
                                    }
                                }
                                catch (PartInitException partInitException) {
                                    toclose.add(er);
                                }
                                ++n2;
                            }
                            if (!toclose.isEmpty()) {
                                activePage.closeEditors(toclose.toArray(new IEditorReference[toclose.size()]), false);
                            }
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.wjob.schedule();
    }

    private final class ResourceVisitor
    implements IResourceProxyVisitor {
        private IProgressMonitor monitor;

        public ResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            IResource r = proxy.requestResource();
            if (proxy != null && proxy.isLinked() && (r instanceof IFolder || r.getFileExtension() != null && r.getFileExtension().equalsIgnoreCase("jrxml")) && r.getLocation() != null && !r.getLocation().toFile().exists()) {
                r.delete(true, this.monitor);
            }
            return !this.monitor.isCanceled();
        }
    }
}

