/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.wb.swt.ResourceManager;

public class WritableComboButton
extends Composite {
    protected static final int CORNER_SIZE = 5;
    protected static final int ARROW_WIDTH = 7;
    protected static final int ARROW_HEIGHT = 4;
    protected static final int ARROW_AREA_WIDTH = 15;
    public static final int NO_IMAGE = 2;
    private Color defaultBackgroundColor;
    private Control textArea;
    private Canvas arrow;
    private Image displayedImage;
    private Point cachedImageSize = null;
    private Label imageLabel;
    private List<SelectionListener> openListeners = null;
    private List<ModifyListener> modifyListeners = null;
    protected ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (WritableComboButton.this.modifyListeners == null || WritableComboButton.this.modifyListeners.isEmpty()) {
                return;
            }
            StyledText textControl = (StyledText)WritableComboButton.this.textArea;
            Point selection = textControl.getSelection();
            for (ModifyListener listener : WritableComboButton.this.modifyListeners) {
                listener.modifyText(e);
            }
            textControl.setSelection(selection);
        }
    };
    protected MouseListener mousePressListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            WritableComboButton.this.handleMousePress(e);
        }
    };

    public WritableComboButton(Composite parent, int style) {
        super(parent, style);
        boolean isReadOnly;
        this.imageLabel = new Label((Composite)this, 0);
        boolean bl = isReadOnly = (this.getStyle() & 8) != 0;
        if (isReadOnly) {
            this.textArea = new Label((Composite)this, 0);
            this.textArea.setBackground(ResourceManager.getColor(1));
        } else {
            this.textArea = new StyledText((Composite)this, 0);
            ((StyledText)this.textArea).addModifyListener(this.textModifyListener);
        }
        this.defaultBackgroundColor = this.textArea.getBackground();
        this.arrow = new Canvas((Composite)this, 0);
        this.setLayout(new Layout(){

            protected void layout(Composite composite, boolean flushCache) {
                Rectangle availableSize = composite.getClientArea();
                int xOffsetLeft = 3;
                int xOffsetRight = 1;
                int imageWidth = 0;
                int imageYOffset = 1;
                int imageHeight = 0;
                if (WritableComboButton.this.displayedImage != null) {
                    int maxAvailableWidth = (availableSize.width + xOffsetLeft + xOffsetRight) / 2;
                    imageWidth = Math.min(WritableComboButton.this.getImageSize().x, maxAvailableWidth);
                    if (WritableComboButton.this.getImageSize().y > availableSize.height - 2) {
                        imageHeight = availableSize.height - 2;
                    } else {
                        imageYOffset = (availableSize.height - WritableComboButton.this.getImageSize().y) / 2;
                        imageHeight = WritableComboButton.this.getImageSize().y;
                    }
                }
                int textMaxWidth = availableSize.width - 15 - imageWidth - xOffsetLeft - xOffsetRight;
                WritableComboButton.this.imageLabel.setBounds(xOffsetLeft, imageYOffset, imageWidth, imageHeight);
                WritableComboButton.this.textArea.setBounds(xOffsetLeft += imageWidth, 1, textMaxWidth, availableSize.height - 2);
                WritableComboButton.this.arrow.setBounds(textMaxWidth + xOffsetLeft, 1, 15 - xOffsetRight, availableSize.height - 2);
                Color background = WritableComboButton.this.getWidgetsBackground(WritableComboButton.this.getDisplay());
                WritableComboButton.this.setCompositeBackgroundColor(background);
                WritableComboButton.this.imageLabel.setBackground(background);
                WritableComboButton.this.textArea.setBackground(background);
                WritableComboButton.this.redraw();
            }

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                Point textAreaSize = WritableComboButton.this.textArea.computeSize(wHint, hHint);
                if (WritableComboButton.this.displayedImage != null) {
                    textAreaSize.x += WritableComboButton.this.getImageSize().x;
                    if (textAreaSize.y < WritableComboButton.this.getImageSize().y) {
                        textAreaSize.y = WritableComboButton.this.getImageSize().y;
                    }
                }
                if (textAreaSize.y < 20) {
                    textAreaSize.y = 20;
                }
                return textAreaSize;
            }
        });
        this.arrow.addMouseListener(this.mousePressListener);
        this.arrow.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle bounds = WritableComboButton.this.arrow.getBounds();
                e.gc.setBackground(WritableComboButton.this.getWidgetsBackground(e.display));
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                e.gc.setBackground(ResourceManager.getColor(0, 0, 0));
                int y = bounds.height / 2;
                int x = bounds.width / 2;
                int y1 = y - 2;
                int y2 = y + 2;
                int x3 = x;
                int x1 = x - 3;
                int x2 = x + 3;
                e.gc.fillPolygon(new int[]{x1, y1, x2, y1, x3, y2});
            }
        });
        this.createBorderPaintListener();
    }

    public void addListener(int eventType, Listener listener) {
        if (eventType == 9) {
            super.addListener(eventType, listener);
        } else {
            this.textArea.addListener(eventType, listener);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        if (eventType == 9) {
            super.removeListener(eventType, listener);
        } else {
            this.textArea.removeListener(eventType, listener);
        }
    }

    protected void createBorderPaintListener() {
        PaintListener borderPainter = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle bounds = WritableComboButton.this.getBounds();
                int w = bounds.width - 1;
                int h = bounds.height - 1;
                boolean focused = WritableComboButton.this.isFocusControl() || WritableComboButton.this.textArea.isFocusControl() || WritableComboButton.this.arrow.isFocusControl();
                e.gc.setForeground(WritableComboButton.this.getBorderForeground(e.display, focused));
                e.gc.drawRoundRectangle(0, 0, w, h, 5, 5);
            }
        };
        this.addPaintListener(borderPainter);
    }

    protected void setCompositeBackgroundColor(Color color) {
        super.setBackground(color);
    }

    protected Color getWidgetsBackground(Display display) {
        return this.defaultBackgroundColor;
    }

    protected Color getBorderForeground(Display display, boolean focused) {
        if (focused) {
            return display.getSystemColor(23);
        }
        return display.getSystemColor(18);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.defaultBackgroundColor = color;
        this.layout();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        this.textArea.setForeground(color);
    }

    public void addFocusListener(FocusListener listener) {
        this.textArea.addFocusListener(listener);
    }

    public void setText(String text) {
        if (this.textArea.getClass().equals(Label.class)) {
            ((Label)this.textArea).setText(text);
        } else {
            StyledText textControl = (StyledText)this.textArea;
            textControl.removeModifyListener(this.textModifyListener);
            textControl.setText(text);
            textControl.addModifyListener(this.textModifyListener);
        }
    }

    public void insert(String text) {
        if (this.textArea.getClass().equals(Label.class)) {
            ((Label)this.textArea).setText(text);
        } else {
            StyledText textControl = (StyledText)this.textArea;
            textControl.removeModifyListener(this.textModifyListener);
            textControl.insert(text);
            textControl.addModifyListener(this.textModifyListener);
        }
    }

    public int getLineHeight() {
        if (this.textArea.getClass().equals(Label.class)) {
            return ((Label)this.textArea).getFont().getFontData()[0].getHeight();
        }
        StyledText textControl = (StyledText)this.textArea;
        return textControl.getLineHeight();
    }

    public String getText() {
        if (this.textArea.getClass().equals(Label.class)) {
            return ((Label)this.textArea).getText();
        }
        StyledText textControl = (StyledText)this.textArea;
        return textControl.getText();
    }

    public void addOpenListener(SelectionListener listener) {
        if (this.openListeners == null) {
            this.openListeners = new ArrayList<SelectionListener>();
        }
        this.openListeners.add(listener);
    }

    public void removeOpenListener(SelectionListener listener) {
        if (this.openListeners == null) {
            return;
        }
        this.openListeners.remove(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        if (this.modifyListeners == null) {
            this.modifyListeners = new ArrayList<ModifyListener>();
        }
        this.modifyListeners.add(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        if (this.modifyListeners == null) {
            this.modifyListeners = new ArrayList<ModifyListener>();
        }
        this.modifyListeners.remove(listener);
    }

    protected void fireOpen(MouseEvent mouseEvent) {
        if (this.openListeners == null || this.openListeners.isEmpty()) {
            return;
        }
        this.imageLabel.setFocus();
        final Event e = new Event();
        e.widget = this;
        e.button = mouseEvent.button;
        e.x = mouseEvent.x;
        e.y = mouseEvent.y;
        for (final SelectionListener l : this.openListeners) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    l.widgetSelected(new SelectionEvent(e));
                }
            });
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.arrow.setEnabled(enabled);
        this.textArea.setEnabled(enabled);
        this.imageLabel.setEnabled(enabled);
    }

    protected void handleMousePress(MouseEvent e) {
        if (this.isDisposed() || !this.isEnabled()) {
            return;
        }
        this.fireOpen(e);
    }

    public void setImage(Image image) {
        if (image == this.displayedImage) {
            return;
        }
        this.displayedImage = image;
        this.cachedImageSize = null;
        this.imageLabel.setImage(this.displayedImage);
        this.layout();
    }

    public void setImage(ImageDescriptor imageDesc) {
        if (imageDesc != null) {
            Image image = ResourceManager.getImage(imageDesc);
            this.setImage(image);
        }
    }

    public Point getSelection() {
        if (this.textArea.getClass().equals(StyledText.class)) {
            return ((StyledText)this.textArea).getSelection();
        }
        return new Point(0, 0);
    }

    public void setSelection(Point value) {
        if (this.textArea.getClass().equals(StyledText.class)) {
            ((StyledText)this.textArea).setSelection(value);
        }
    }

    public void setSelection(int start, int end) {
        if (this.textArea.getClass().equals(StyledText.class)) {
            ((StyledText)this.textArea).setSelection(start, end);
        }
    }

    public boolean hasImage() {
        return this.displayedImage != null && (this.getStyle() & 2) == 0;
    }

    protected Point getImageSize() {
        if (this.cachedImageSize == null) {
            this.cachedImageSize = this.calcImageSize();
        }
        return this.cachedImageSize;
    }

    protected Point calcImageSize() {
        Point size = new Point(0, 0);
        if (this.hasImage()) {
            Rectangle bounds = this.displayedImage.getBounds();
            size.x = Math.max(size.x, bounds.width);
            size.y = Math.max(size.y, bounds.height);
        }
        return size;
    }

    public boolean setFocus() {
        return this.textArea.setFocus();
    }

    public void setTextColor(Color color) {
        this.textArea.setForeground(color);
    }

    public Menu getMenu() {
        return this.textArea.getMenu();
    }

    public void setMenu(Menu menu) {
        this.textArea.setMenu(menu);
    }
}

