/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.ui.util;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.eclipse.ui.util.ExceptionDetailsErrorDialog;
import net.sf.jasperreports.eclipse.ui.util.ExtendedMessageDialog;
import net.sf.jasperreports.eclipse.ui.util.RunnableCancelQuestion;
import net.sf.jasperreports.eclipse.ui.util.RunnableQuestion;
import net.sf.jasperreports.eclipse.util.Pair;
import org.eclipse.core.commands.operations.OperationStatus;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;

public class UIUtils {
    public static final Color INHERITED_COLOR = ResourceManager.getColor(new RGBA(125, 125, 125, 125));
    public static final float DEFAULT_WINDOWS_DPI = 96.0f;
    public static final char SWT_SPACE = ' ';
    private static final IShellProvider SHELL_PROVIDER = new IShellProvider(){

        public Shell getShell() {
            return this.getShell();
        }
    };
    private static final PaletteData palette = new PaletteData(0xFF0000, 65280, 255);

    public static void showError(final String message, final Throwable t) {
        t.printStackTrace();
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                UIUtils.showErrorDialog(message, t);
            }
        });
    }

    public static void showErrorDialog(String message, Throwable t) {
        OperationStatus status = new OperationStatus(4, JasperReportsPlugin.getDefault().getPluginID(), 1, message, t);
        ExceptionDetailsErrorDialog exceptionDialog = new ExceptionDetailsErrorDialog(UIUtils.getShell(), Messages.UIUtils_ExceptionTitle, Messages.UIUtils_ExceptionDetailsMsg, (IStatus)status, 7){

            protected void setShellStyle(int newShellStyle) {
                super.setShellStyle(newShellStyle | 0x10000000);
            }

            @Override
            protected void populateList(Text listToPopulate, IStatus buildingStatus, int nesting, boolean includeStatus) {
                super.populateList(listToPopulate, buildingStatus, nesting, includeStatus);
                Throwable t = buildingStatus.getException();
                if (listToPopulate.getText().isEmpty() && t instanceof CoreException) {
                    int causeIndex;
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    while (i < nesting) {
                        sb.append(" ");
                        ++i;
                    }
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    String message = sw.getBuffer().toString();
                    if (message == null) {
                        message = t.toString();
                    }
                    if ((causeIndex = message.indexOf("Caused by:")) != -1) {
                        sb.append(message.substring(causeIndex));
                        listToPopulate.append(sb.toString());
                    }
                }
            }
        };
        exceptionDialog.open();
    }

    public static void showError(Throwable t) {
        UIUtils.showError(t.getMessage(), t);
    }

    public static void showWarning(String message) {
        UIUtils.showWarning(Messages.UIUtils_Warning, message);
    }

    public static void showWarning(final String title, final String message) {
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.open((int)4, (Shell)UIUtils.getShell(), (String)title, (String)message, (int)0x10000000);
            }
        });
    }

    public static boolean showConfirmation(String title, String message) {
        RunnableQuestion questionMessage = new RunnableQuestion(title, message);
        UIUtils.getDisplay().syncExec((Runnable)questionMessage);
        return questionMessage.getResult();
    }

    public static RunnableCancelQuestion.RESPONSE_TYPE showCancellableConfirmation(String title, String message) {
        RunnableCancelQuestion questionMessage = new RunnableCancelQuestion(title, message);
        UIUtils.getDisplay().syncExec((Runnable)questionMessage);
        return questionMessage.getResponse();
    }

    public static Pair<RunnableCancelQuestion.RESPONSE_TYPE, Boolean> showCancellableConfirmation(String title, String message, String checkBoxMessage) {
        RunnableCancelQuestion questionMessage = new RunnableCancelQuestion(title, message, checkBoxMessage);
        UIUtils.getDisplay().syncExec((Runnable)questionMessage);
        return new Pair<RunnableCancelQuestion.RESPONSE_TYPE, Boolean>(questionMessage.getResponse(), questionMessage.getCheckboxResult());
    }

    public static Boolean[] showConfirmation(String title, String message, String checkBox) {
        RunnableQuestion questionMessage = new RunnableQuestion(title, message, checkBox);
        UIUtils.getDisplay().syncExec((Runnable)questionMessage);
        return new Boolean[]{questionMessage.getResult(), questionMessage.getCheckboxResult()};
    }

    public static boolean showDeleteConfirmation() {
        RunnableQuestion questionMessage = new RunnableQuestion(Messages.UIUtils_DeleteConfirmation.replace("&", ""), Messages.UIUtils_ResourceDeleteConfirmationMsg);
        questionMessage.setDefaultButton(1);
        UIUtils.getDisplay().syncExec((Runnable)questionMessage);
        return questionMessage.getResult();
    }

    public static boolean showDeleteConfirmation(Shell shell) {
        return UIUtils.showDeleteConfirmation(shell, Messages.UIUtils_DeleteConfirmation.replace("&", ""));
    }

    public static boolean showDeleteConfirmation(String msg) {
        RunnableQuestion questionMessage = new RunnableQuestion(Messages.UIUtils_2, msg);
        questionMessage.setDefaultButton(1);
        UIUtils.getDisplay().syncExec((Runnable)questionMessage);
        return questionMessage.getResult();
    }

    public static boolean showDeleteConfirmation(Shell shell, String msg) {
        ExtendedMessageDialog dialog = new ExtendedMessageDialog(shell, "Question", null, msg, 3, new String[]{Messages.UIUtils_AnswerYes, Messages.UIUtils_AnswerNo}, 1, null);
        dialog.open();
        return dialog.getResult();
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static void showInformation(String message) {
        UIUtils.showInformation(Messages.UIUtils_InformationTitle, message);
    }

    public static void showInformation(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.open((int)2, (Shell)UIUtils.getShell(), (String)title, (String)message, (int)0x10000000);
            }
        });
    }

    public static Display getDisplay() {
        Display d = Display.getCurrent();
        if (d != null) {
            return d;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        d = Display.getDefault();
        if (d != null) {
            return d;
        }
        throw new SWTError(22);
    }

    public static Shell getShell() {
        Shell shell = null;
        if (Util.isWindows() && (shell = UIUtils.getDisplay().getActiveShell()) != null) {
            return shell;
        }
        IWorkbenchWindow window = null;
        if (PlatformUI.isWorkbenchRunning()) {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        shell = window != null ? window.getShell() : UIUtils.getDisplay().getActiveShell();
        return shell;
    }

    public static Shell getShellForWizardDialog() {
        return UIUtils.isMacOSX() ? UIUtils.getDisplay().getActiveShell() : UIUtils.getShell();
    }

    public static String truncateStringForLabel(String str, int maxChars, String suffix) {
        Assert.isNotNull((Object)str);
        String result = str.substring(0, Math.min(str.length(), maxChars));
        if (str.length() > maxChars) {
            result = String.valueOf(result) + (suffix != null ? suffix : "");
        }
        return result;
    }

    public static void resizeAndCenterShell(Shell shell, int newWidth, int newHeight) {
        newWidth = newWidth == -1 ? shell.getSize().x : newWidth;
        newHeight = newHeight == -1 ? shell.getSize().y : newHeight;
        shell.setSize(newWidth, newHeight);
        UIUtils.centerDialog(shell);
    }

    public static void relayoutDialog(Shell shell, int maxWidth, int maxHeight) {
        Point oldsize = shell.getSize();
        shell.layout();
        shell.pack();
        Point sizeAfterPack = shell.getSize();
        Point sizeToSet = new Point(sizeAfterPack.x, sizeAfterPack.y);
        Rectangle r = Display.getCurrent().getClientArea();
        sizeToSet.x = UIUtils.getMaxSize(maxWidth, oldsize.x, r.width, sizeAfterPack.x);
        sizeToSet.y = UIUtils.getMaxSize(maxHeight, oldsize.y, r.height, sizeAfterPack.y);
        shell.setSize(sizeToSet.x, sizeToSet.y);
        shell.layout();
    }

    public static void relayoutDialogHeight(Shell shell, int maxHeight) {
        Point oldsize = shell.getSize();
        shell.layout();
        shell.pack();
        Point sizeAfterPack = shell.getSize();
        Point sizeToSet = new Point(sizeAfterPack.x, sizeAfterPack.y);
        Rectangle r = Display.getCurrent().getClientArea();
        sizeToSet.y = UIUtils.getMaxSize(maxHeight, oldsize.y, r.height, sizeAfterPack.y);
        shell.setSize(oldsize.x, sizeToSet.y);
        shell.layout();
    }

    public static void centerDialog(Shell shell) {
        Point clocation = UIUtils.getShellCenterLocation(shell);
        shell.setLocation(clocation.x, clocation.y);
    }

    public static Point getShellCenterLocation(Shell shell) {
        Shell mainApplicationShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Rectangle bounds = mainApplicationShell.getMonitor().getClientArea();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        return new Point(x, y);
    }

    private static int getMaxSize(int max, int old, int val, int afterPack) {
        switch (max) {
            case -1: {
                return afterPack > val ? val : afterPack;
            }
            case 0: {
                return old;
            }
        }
        return afterPack > max ? max : afterPack;
    }

    public static Image awt2Swt(BufferedImage img) {
        DataBuffer buffer = img.getData().getDataBuffer();
        if (buffer instanceof DataBufferInt) {
            int[] data = ((DataBufferInt)buffer).getData();
            ImageData imageData = new ImageData(img.getWidth(), img.getHeight(), 32, palette);
            imageData.setPixels(0, 0, data.length, data, 0);
            return new Image((Device)UIUtils.getDisplay(), imageData);
        }
        if (buffer instanceof DataBufferByte) {
            byte[] data = ((DataBufferByte)buffer).getData();
            return new Image((Device)UIUtils.getDisplay(), new ImageData(img.getWidth(), img.getHeight(), 32, palette, 4, data));
        }
        return null;
    }

    public static IShellProvider getShellProvider() {
        return SHELL_PROVIDER;
    }

    public static void setEnabled(Control c, boolean enabled) {
        Control[] children;
        c.setEnabled(enabled);
        if (c instanceof Composite && (children = ((Composite)c).getChildren()) != null) {
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                UIUtils.setEnabled(child, enabled);
                ++n2;
            }
        }
    }

    public static void setEnabled(Control c, Map<Control, Boolean> map, boolean enabled) {
        Control[] children;
        CTabFolder tf;
        if (c instanceof CTabFolder) {
            tf = (CTabFolder)c;
            CTabItem[] cTabItemArray = tf.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem it = cTabItemArray[n2];
                UIUtils.setEnabled(it.getControl(), map, enabled);
                ++n2;
            }
        } else if (c instanceof TabFolder) {
            tf = (TabFolder)c;
            TabItem[] tabItemArray = tf.getItems();
            int n = tabItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                TabItem it = tabItemArray[n3];
                UIUtils.setEnabled(it.getControl(), map, enabled);
                ++n3;
            }
        } else if (c instanceof Composite && (children = ((Composite)c).getChildren()) != null) {
            Control[] controlArray = children;
            int n = children.length;
            int n4 = 0;
            while (n4 < n) {
                Control child = controlArray[n4];
                UIUtils.setEnabled(child, map, enabled);
                ++n4;
            }
        }
        if (enabled) {
            Boolean en = map.get(c);
            if (en != null) {
                c.setEnabled(en.booleanValue());
            } else {
                c.setEnabled(true);
            }
        } else {
            map.put(c, c.getEnabled());
            c.setEnabled(false);
        }
    }

    public static synchronized boolean isUIThread() {
        Display currDisplay = Display.getCurrent();
        return currDisplay != null && currDisplay.getThread() == Thread.currentThread();
    }

    public static synchronized void checkUIThread() {
        if (!UIUtils.isUIThread()) {
            SWT.error((int)22);
        }
    }

    public static boolean isDevMode() {
        String devmode = System.getProperty("devmode");
        return devmode != null && devmode.equals("true");
    }

    public static void debugCompositeInfo(Composite cmp, String cmpName) {
        System.out.println("|========================|");
        System.out.println(NLS.bind((String)"Composite {0} details: ", (Object)cmpName));
        System.out.println("Actual size: " + cmp.getSize());
        System.out.println("Client area:" + cmp.getClientArea());
        System.out.println("Bounds: " + cmp.getBounds());
    }

    public static boolean isMacOSX() {
        return "macosx".equals(Platform.getOS());
    }

    public static boolean isLinux() {
        return "linux".equals(Platform.getOS());
    }

    public static boolean isWindows() {
        return "win32".equals(Platform.getOS());
    }

    public static Point getScaledSize(Point size) {
        if (UIUtils.isWindows()) {
            Point currentDPI = UIUtils.getDisplay().getDPI();
            int xScaled = (int)((float)size.x * ((float)currentDPI.x / 96.0f));
            int yScaled = (int)((float)size.y * ((float)currentDPI.y / 96.0f));
            return new Point(xScaled, yScaled);
        }
        return size;
    }

    public static int getScaledWidth(int width) {
        Point scaledSize = UIUtils.getScaledSize(new Point(width, 0));
        return scaledSize.x;
    }

    public static int getScaledHeight(int height) {
        Point scaledSize = UIUtils.getScaledSize(new Point(0, height));
        return scaledSize.y;
    }
}

