/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.ui.validator;

import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PathValidator
implements IValidator<String> {
    private static final char[] allowed = "_./".toCharArray();
    private boolean optional = true;

    public PathValidator(boolean optional) {
        this.optional = optional;
    }

    public IStatus validate(String v) {
        String[] m;
        if (this.optional && Misc.isNullOrEmpty(v)) {
            return Status.OK_STATUS;
        }
        if (!v.startsWith("/")) {
            return ValidationStatus.error((String)"Path is not starting with /");
        }
        String[] stringArray = m = v.split("/");
        int n = m.length;
        int n2 = 0;
        while (n2 < n) {
            String vm = stringArray[n2];
            if (vm.length() > 100) {
                return ValidationStatus.error((String)"ID size between 0 and 100");
            }
            char[] cArray = vm.toCharArray();
            int n3 = cArray.length;
            int n4 = 0;
            while (n4 < n3) {
                char c = cArray[n4];
                if (!Character.isLetterOrDigit(c)) {
                    boolean isAllowed = false;
                    char[] cArray2 = allowed;
                    int n5 = allowed.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        char a = cArray2[n6];
                        if (c == a) {
                            isAllowed = true;
                            break;
                        }
                        ++n6;
                    }
                    if (!isAllowed) {
                        return ValidationStatus.error((String)Messages.IDStringValidator_InvalidChars);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public static String safeChar(String input) {
        char[] charArray = input.toString().toCharArray();
        StringBuilder result = new StringBuilder();
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            Character newc = null;
            if (Character.isLetterOrDigit(c)) {
                newc = Character.valueOf(c);
            } else {
                char[] cArray2 = allowed;
                int n3 = allowed.length;
                int n4 = 0;
                while (n4 < n3) {
                    char a = cArray2[n4];
                    if (c == a) {
                        newc = Character.valueOf(c);
                        break;
                    }
                    ++n4;
                }
            }
            if (newc == null) {
                newc = Character.valueOf('_');
            }
            result.append(newc);
            ++n2;
        }
        return result.toString();
    }
}

