/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.messages.Messages;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.swt.ResourceManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public final class BundleCommonUtils {
    public static final String REFERENCE_SCHEME = "reference:";
    public static final String REFERENCE_FILE_SCHEMA = "reference:file:";
    private static Map<String, File> JARS_DESTINATION_FOLDERS_MAP = new HashMap<String, File>();

    private BundleCommonUtils() {
    }

    public static Bundle getBundle(String bundleID) {
        Bundle bundle = Platform.getBundle((String)bundleID);
        if (bundle == null) {
            return null;
        }
        return bundle;
    }

    public static String getFileLocation(String bundleID, String path) throws IOException {
        Assert.isNotNull((Object)bundleID);
        Assert.isNotNull((Object)path);
        Bundle bundle = BundleCommonUtils.getBundle(bundleID);
        if (bundle != null) {
            return FileLocator.toFileURL((URL)bundle.getEntry(path)).getPath();
        }
        return null;
    }

    public static boolean checkIfResourceExists(String bundleID, String path) {
        Assert.isNotNull((Object)bundleID);
        Assert.isNotNull((Object)path);
        Bundle bundle = BundleCommonUtils.getBundle(bundleID);
        if (bundle != null) {
            return bundle.getEntry(path) != null;
        }
        throw new RuntimeException(NLS.bind((String)"An error occurred: the bundle {0} was not found.", (Object)bundleID));
    }

    public static ImageDescriptor getImageDescriptor(String bundleID, String path) {
        Assert.isNotNull((Object)bundleID);
        Assert.isNotNull((Object)path);
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)bundleID, (String)path);
    }

    public static Image getImage(String bundleID, String path) {
        Assert.isNotNull((Object)bundleID);
        Assert.isNotNull((Object)path);
        return ResourceManager.getPluginImage(bundleID, path);
    }

    public static Image getImage(ImageDescriptor descriptor) {
        return ResourceManager.getImage(descriptor);
    }

    public static URL getInstallUrl(String bundleID) {
        Bundle bundle = BundleCommonUtils.getBundle(bundleID);
        if (bundle == null) {
            return null;
        }
        return bundle.getEntry("/");
    }

    public static void logTrace(String bundleID, String message) {
        Bundle bundle = BundleCommonUtils.getBundle(bundleID);
        if (bundle == null) {
            System.err.println(NLS.bind((String)Messages.BundleCommonUtils_LoggingToStdErr, (Object)bundleID));
            System.err.println(String.valueOf(Messages.BundleCommonUtils_MessagePrefix) + message);
            return;
        }
        Platform.getLog((Bundle)bundle).log((IStatus)new Status(1, bundleID, message));
    }

    public static void logTrace(String bundleID, Throwable e) {
        Bundle bundle = BundleCommonUtils.getBundle(bundleID);
        if (bundle == null) {
            System.err.println(NLS.bind((String)Messages.BundleCommonUtils_LoggingToStdErr, (Object)bundleID));
            System.err.println(String.valueOf(Messages.BundleCommonUtils_MessagePrefix) + e.getMessage());
            e.printStackTrace();
            return;
        }
        Platform.getLog((Bundle)bundle).log((IStatus)new Status(1, bundleID, e.getMessage(), e));
    }

    public static void logError(String bundleID, String message, Throwable exception) {
        Bundle bundle = BundleCommonUtils.getBundle(bundleID);
        if (bundle == null) {
            System.err.println(NLS.bind((String)Messages.BundleCommonUtils_LoggingToStdErr, (Object)bundleID));
            System.err.println(String.valueOf(Messages.BundleCommonUtils_MessagePrefix) + message);
            exception.printStackTrace();
            return;
        }
        Platform.getLog((Bundle)bundle).log((IStatus)new Status(4, bundleID, message, exception));
    }

    public static void logWarning(String bundleID, String message, Throwable exception) {
        Bundle bundle = BundleCommonUtils.getBundle(bundleID);
        if (bundle == null) {
            System.err.println(NLS.bind((String)Messages.BundleCommonUtils_LoggingToStdErr, (Object)bundleID));
            System.err.println(String.valueOf(Messages.BundleCommonUtils_MessagePrefix) + message);
            exception.printStackTrace();
            return;
        }
        Platform.getLog((Bundle)bundle).log((IStatus)new Status(2, bundleID, message, exception));
    }

    public static void logInfo(String bundleID, String message) {
        Bundle bundle = BundleCommonUtils.getBundle(bundleID);
        if (bundle == null) {
            System.out.println(NLS.bind((String)Messages.BundleCommonUtils_LoggingToStdOut, (Object)bundleID));
            System.out.println(String.valueOf(Messages.BundleCommonUtils_MessagePrefix) + message);
            return;
        }
        Platform.getLog((Bundle)bundle).log((IStatus)new Status(1, bundleID, message));
    }

    public static void logStatus(String bundleID, IStatus status) {
        Bundle bundle = BundleCommonUtils.getBundle(bundleID);
        if (bundle == null) {
            return;
        }
        Platform.getLog((Bundle)bundle).log(status);
    }

    public static String getWorkspaceLocation() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        File wsDirLocation = ws.getRoot().getLocation().toFile();
        return wsDirLocation.getAbsolutePath();
    }

    public static String eventTypeToString(BundleEvent event) {
        switch (event.getType()) {
            case 1: {
                return "Installed";
            }
            case 32: {
                return "Resolved";
            }
            case 512: {
                return "Lazy Activation";
            }
            case 128: {
                return "Starting";
            }
            case 2: {
                return "Started";
            }
            case 256: {
                return "Stopping";
            }
            case 4: {
                return "Stopped";
            }
            case 8: {
                return "Updated";
            }
            case 64: {
                return "Unresolved";
            }
            case 16: {
                return "Uninstalled";
            }
        }
        return "<UNDEFINED>";
    }

    public static String getBundleAbsoluteLocation(Bundle bundle) {
        Assert.isNotNull((Object)bundle);
        try {
            File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
            if (bundleFile != null && bundleFile.exists()) {
                return bundleFile.getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            JasperReportsPlugin.getDefault().logError(NLS.bind((String)Messages.JRDependenciesClasspathContainer_AddLocationError, (Object)bundle.getSymbolicName()), null);
        }
        return null;
    }

    private static File getTempDirectoryForInnerJars(Bundle bundle) {
        String bundleName = bundle.getSymbolicName();
        File extractedJarsLocation = JARS_DESTINATION_FOLDERS_MAP.get(bundleName);
        if (extractedJarsLocation == null) {
            IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
            File configFolder = stateLocation.toFile();
            extractedJarsLocation = new File(configFolder, "extractedJars");
            if (extractedJarsLocation.exists()) {
                try {
                    FileUtils.deleteDirectory((File)extractedJarsLocation);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            extractedJarsLocation.mkdirs();
            JARS_DESTINATION_FOLDERS_MAP.put(bundleName, extractedJarsLocation);
        }
        return extractedJarsLocation;
    }

    public static List<File> extractAllJarsFromBundle(Bundle bundle) {
        ArrayList<File> results = new ArrayList<File>();
        List<String> classpathLibs = BundleCommonUtils.getBundleClasspathJars(bundle);
        File jarsDestinationDir = BundleCommonUtils.getTempDirectoryForInnerJars(bundle);
        if (jarsDestinationDir != null) {
            String tempDirPath = jarsDestinationDir.getAbsolutePath();
            for (String lib : classpathLibs) {
                File extractedJar = BundleCommonUtils.extractJarFromBundle(bundle, lib, String.valueOf(tempDirPath) + "/" + lib);
                if (extractedJar == null) continue;
                results.add(extractedJar);
            }
        }
        return results;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static File extractJarFromBundle(Bundle bundle, String libname, String targeFileLocation) {
        block19: {
            block16: {
                block17: {
                    extractedJar = null;
                    bundleLocation = BundleCommonUtils.getBundleAbsoluteLocation(bundle);
                    if (bundleLocation == null) break block19;
                    bundleJar = null;
                    in /* !! */  = null;
                    fos = null;
                    bundleFile = new File(bundleLocation);
                    if (bundleFile.isDirectory()) ** GOTO lbl28
                    bundleJar = new JarFile(bundleFile);
                    in /* !! */  = null;
                    libEntry = bundleJar.getEntry(libname);
                    if (libEntry != null && !libEntry.isDirectory()) break block16;
                    if (bundleJar == null) break block17;
                    try {
                        bundleJar.close();
                    }
                    catch (IOException v0) {}
                }
                IOUtils.closeQuietly((InputStream)in /* !! */ );
                IOUtils.closeQuietly(fos);
                return null;
            }
            try {
                try {
                    block20: {
                        in /* !! */  = bundleJar.getInputStream(libEntry);
                        break block20;
lbl28:
                        // 1 sources

                        in /* !! */  = new FileInputStream(String.valueOf(bundleFile.getAbsolutePath()) + "/" + libname);
                    }
                    extractedJar = new File(targeFileLocation);
                    extractedJar.getParentFile().mkdirs();
                    fos = new FileOutputStream(extractedJar);
                    IOUtils.copy((InputStream)in /* !! */ , (OutputStream)fos);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (bundleJar != null) {
                        try {
                            bundleJar.close();
                        }
                        catch (IOException v1) {}
                    }
                    IOUtils.closeQuietly(in /* !! */ );
                    IOUtils.closeQuietly(fos);
                }
            }
            catch (Throwable var10_11) {
                if (bundleJar != null) {
                    try {
                        bundleJar.close();
                    }
                    catch (IOException v2) {}
                }
                IOUtils.closeQuietly(in /* !! */ );
                IOUtils.closeQuietly(fos);
                throw var10_11;
            }
            if (bundleJar != null) {
                try {
                    bundleJar.close();
                }
                catch (IOException v3) {}
            }
            IOUtils.closeQuietly((InputStream)in /* !! */ );
            IOUtils.closeQuietly((OutputStream)fos);
        }
        return extractedJar;
    }

    public static List<String> getBundleClasspathJars(Bundle bundle) {
        ArrayList<String> entries = new ArrayList<String>();
        String bundleClasspathStr = (String)bundle.getHeaders().get("Bundle-ClassPath");
        try {
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)bundleClasspathStr);
            if (elements != null) {
                ManifestElement[] manifestElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    ManifestElement el = manifestElementArray[n2];
                    String entry = el.getValue();
                    if (entry != null && entry.endsWith(".jar")) {
                        entries.add(entry);
                    }
                    ++n2;
                }
            }
        }
        catch (BundleException bundleException) {}
        return entries;
    }

    public static String getBundleVersion(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle != null) {
            Version version = bundle.getVersion();
            return version.toString();
        }
        return null;
    }
}

