/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.util;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CacheMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 362498820763181265L;
    private int timeout = 1000;
    private Map<K, Date> expmap = new HashMap<K, Date>();

    public CacheMap(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public V put(K key, V value) {
        V oldval = super.put(key, value);
        this.expmap.put(key, new Date());
        return oldval;
    }

    @Override
    public boolean containsKey(Object key) {
        boolean b = super.containsKey(key);
        if (b) {
            Date time = this.expmap.get(key);
            long newtime = System.currentTimeMillis();
            if (newtime - time.getTime() > (long)this.timeout) {
                this.remove(key);
                return false;
            }
        }
        return b;
    }

    @Override
    public V get(Object key) {
        Object val = super.get(key);
        if (val != null) {
            Date time = this.expmap.get(key);
            long newtime = System.currentTimeMillis();
            if (newtime - time.getTime() > (long)this.timeout) {
                this.remove(key);
                return null;
            }
        }
        return val;
    }
}

