/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.util;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.Preferences;

public class ResourceScope
implements IScopeContext {
    public static final String SCOPE = "resource";
    private IResource context;
    private Preferences pref;

    public ResourceScope(IResource context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.context = context;
    }

    public IEclipsePreferences getNode(String qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException();
        }
        if (this.pref == null) {
            Preferences pnode = Platform.getPreferencesService().getRootNode().node(SCOPE);
            String ps = this.context.getFullPath().makeRelative().toPortableString();
            ps = ps.replace('/', ';');
            this.pref = pnode.node(ps);
        }
        return (IEclipsePreferences)this.pref.node(qualifier);
    }

    public IPath getLocation() {
        IPath location = this.context.getLocation();
        return location == null ? null : location;
    }

    public String getName() {
        return SCOPE;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ResourceScope)) {
            return false;
        }
        ResourceScope other = (ResourceScope)obj;
        return this.context.equals((Object)other.context);
    }

    public int hashCode() {
        return super.hashCode() + this.context.getFullPath().hashCode();
    }
}

