/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.util.query;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.eclipse.util.query.EmptyQueryExecuterFactory;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.DefaultQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.query.QueryExecuterFactory;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EmptyQueryExecuterFactoryBundle
implements JRQueryExecuterFactoryBundle {
    private final Log log = LogFactory.getLog(EmptyQueryExecuterFactory.class);
    private static final JRSingletonCache cache = new JRSingletonCache(QueryExecuterFactory.class);
    private static final EmptyQueryExecuterFactoryBundle INSTANCE = new EmptyQueryExecuterFactoryBundle();
    private JasperReportsContext jasperReportsContext;
    private String[] languages;
    private Map<String, QueryExecuterFactory> mqef;
    private ExtensionsRegistry oldExtensionsRegistry;

    private EmptyQueryExecuterFactoryBundle() {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance());
    }

    private EmptyQueryExecuterFactoryBundle(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static EmptyQueryExecuterFactoryBundle getInstance() {
        return INSTANCE;
    }

    public static EmptyQueryExecuterFactoryBundle getInstance(JasperReportsContext jasperReportsContext) {
        return new EmptyQueryExecuterFactoryBundle(jasperReportsContext);
    }

    public String[] getLanguages() {
        ExtensionsRegistry extensionsRegistry = ExtensionsEnvironment.getExtensionsRegistry();
        if (extensionsRegistry != this.oldExtensionsRegistry) {
            this.init(extensionsRegistry);
        }
        return this.languages;
    }

    protected void init(ExtensionsRegistry extensionsRegistry) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Object cl = this.jasperReportsContext.getValue("CURRENT_CLASS_LOADER");
        if (cl != null && cl instanceof ClassLoader) {
            Thread.currentThread().setContextClassLoader((ClassLoader)cl);
        }
        try {
            this.oldExtensionsRegistry = extensionsRegistry;
            HashSet<String> langs = new HashSet<String>();
            this.mqef = new HashMap<String, QueryExecuterFactory>();
            List bundles = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(JRQueryExecuterFactoryBundle.class);
            for (JRQueryExecuterFactoryBundle bundle : bundles) {
                String[] l;
                if (bundle.getClass().equals(this.getClass())) continue;
                if (bundle instanceof DefaultQueryExecuterFactoryBundle) {
                    bundle = DefaultQueryExecuterFactoryBundle.getInstance((JasperReportsContext)this.jasperReportsContext);
                }
                String[] stringArray = l = bundle.getLanguages();
                int n = l.length;
                int n2 = 0;
                while (n2 < n) {
                    String lang = stringArray[n2];
                    langs.add(lang);
                    if (!this.mqef.containsKey(lang)) {
                        try {
                            this.mqef.put(lang, bundle.getQueryExecuterFactory(lang));
                        }
                        catch (JRException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
            }
            this.languages = langs.toArray(new String[langs.size()]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public QueryExecuterFactory getQueryExecuterFactory(String language) throws JRException {
        QueryExecuterFactory qef;
        ExtensionsRegistry extensionsRegistry = ExtensionsEnvironment.getExtensionsRegistry();
        if (extensionsRegistry != this.oldExtensionsRegistry) {
            this.init(extensionsRegistry);
        }
        if ((qef = this.mqef.get(language)) == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)MessageFormat.format(Messages.EmptyQueryExecuterFactoryBundle_NoFactoryClassRegistered, language));
            }
            qef = (QueryExecuterFactory)cache.getCachedInstance(EmptyQueryExecuterFactory.class.getName());
        }
        return qef;
    }
}

