/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.viewer;

import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.viewer.BrowserUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.view.JRHyperlinkListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class DefaultHyperlinkHandler
implements JRHyperlinkListener {
    public void gotoHyperlink(final JRPrintHyperlink link) throws JRException {
        if (link == null) {
            return;
        }
        BusyIndicator.showWhile((Display)UIUtils.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                String href;
                HyperlinkTypeEnum linkType = link.getHyperlinkTypeValue();
                if (linkType.equals((Object)HyperlinkTypeEnum.REFERENCE)) {
                    DefaultHyperlinkHandler.this.openLink(link.getHyperlinkReference());
                } else if (linkType.equals((Object)HyperlinkTypeEnum.REMOTE_ANCHOR)) {
                    String href2 = link.getHyperlinkReference();
                    if (href2 != null) {
                        if (link.getHyperlinkAnchor() != null) {
                            href2 = String.valueOf(href2) + "#" + link.getHyperlinkAnchor();
                        }
                        DefaultHyperlinkHandler.this.openLink(href2);
                    }
                } else if (linkType.equals((Object)HyperlinkTypeEnum.REMOTE_PAGE) && (href = link.getHyperlinkReference()) != null) {
                    if (link.getHyperlinkPage() != null) {
                        href = String.valueOf(href) + "#JR_PAGE_ANCHOR_0_" + link.getHyperlinkPage();
                    }
                    DefaultHyperlinkHandler.this.openLink(href);
                }
            }
        });
    }

    private void openLink(String href) {
        if (href != null && !href.isEmpty()) {
            BrowserUtils.openLink(href);
        }
    }
}

