/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.viewer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.eclipse.viewer.IReportViewer;
import net.sf.jasperreports.eclipse.viewer.IReportViewerListener;
import net.sf.jasperreports.eclipse.viewer.ReportViewerEvent;
import net.sf.jasperreports.eclipse.viewer.ViewerCanvas;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPart;
import net.sf.jasperreports.engine.PrintParts;
import net.sf.jasperreports.engine.util.PartsUtil;
import net.sf.jasperreports.view.JRHyperlinkListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ReportViewer
implements IReportViewer {
    private JasperPrint document;
    private int pageIndex = -1;
    private int style;
    private ViewerCanvas viewerCanvas;
    private Composite viewerComposite;
    private List<JRHyperlinkListener> hyperlinkListeners;
    private JasperReportsContext jContext;
    private static final int TABNAMELENGHT = 30;
    private Set<IReportViewerListener> listenerSet = new LinkedHashSet<IReportViewerListener>();
    private CTabFolder tFolder;
    private boolean startsAtZero;
    private FormData tFolderFD;

    public ReportViewer(JasperReportsContext jContext) {
        this(0, jContext);
    }

    public ReportViewer(int style, JasperReportsContext jContext) {
        this.style = style;
        this.jContext = jContext;
    }

    @Override
    public void exportImage(String file, int width, int height) {
        ImageLoader loader = new ImageLoader();
        Image actualImage = this.viewerCanvas.getActualImage();
        int resizeWidth = width > 0 ? width : actualImage.getBounds().width;
        int resizeHeight = height > 0 ? height : actualImage.getBounds().height;
        loader.data = new ImageData[]{actualImage.getImageData().scaledTo(resizeWidth, resizeHeight)};
        loader.save(file, 5);
    }

    public String getReportPath() {
        IFile reportFile = (IFile)this.jContext.getValue("ifile");
        if (reportFile != null) {
            String fileName = reportFile.getName();
            String path = reportFile.getLocation().toPortableString();
            path = path.substring(0, path.lastIndexOf(fileName));
            return path;
        }
        return null;
    }

    @Override
    public String getReportName() {
        IFile reportFile = (IFile)this.jContext.getValue("ifile");
        if (reportFile != null) {
            String fileName = reportFile.getName();
            String extension = reportFile.getFileExtension();
            String path = reportFile.getLocation().toPortableString();
            path = path.substring(0, path.lastIndexOf(fileName));
            fileName = fileName.substring(0, fileName.lastIndexOf(extension) - 1);
            return fileName;
        }
        return null;
    }

    @Override
    public void setReport(JasperPrint document) {
        this.setReport(document, this.pageIndex);
    }

    @Override
    public void setReport(JasperPrint document, int page) {
        try {
            this.document = document;
            this.setupTabs();
            this.pageIndex = Math.min(Math.max(0, this.pageIndex), this.getPageCount() - 1);
            if (this.viewerCanvas != null) {
                this.viewerCanvas.setZoomInternal(this.viewerCanvas.computeZoom());
            }
            if (this.getPageCount() == 0) {
                this.viewerCanvas.refresh();
            }
            this.fireViewerModelChanged(page != this.pageIndex);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.document = null;
        }
    }

    private void setupTabs() {
        if (this.tFolder == null) {
            return;
        }
        CTabItem[] cTabItemArray = this.tFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem c = cTabItemArray[n2];
            c.dispose();
            ++n2;
        }
        if (this.document == null) {
            return;
        }
        PrintParts visibleParts = PartsUtil.instance((JasperReportsContext)this.jContext).getVisibleParts(this.document);
        if (visibleParts.hasParts()) {
            this.tFolder.setLayoutData((Object)this.tFolderFD);
            this.startsAtZero = false;
            Iterator it = visibleParts.partsIterator();
            while (it.hasNext() && !this.startsAtZero) {
                boolean bl = this.startsAtZero = (Integer)((Map.Entry)it.next()).getKey() == 0;
            }
            if (!this.startsAtZero) {
                this.setupTab(this.document.getName(), null);
            }
            it = visibleParts.partsIterator();
            while (it.hasNext()) {
                Map.Entry p = (Map.Entry)it.next();
                PrintPart printPart = (PrintPart)p.getValue();
                this.setupTab(printPart.getName(), p);
            }
        } else {
            FormData fd = new FormData();
            fd.height = 0;
            fd.bottom = new FormAttachment(0, 0);
            this.tFolder.setLayoutData((Object)fd);
        }
        this.viewerComposite.layout(true);
    }

    private void setupTab(String name, Object data) {
        CTabItem tab = new CTabItem(this.tFolder, 0);
        tab.setData(data);
        tab.setToolTipText(name);
        name = name.replaceAll("(\\r|\\n)+", " ");
        if (name.length() > 30) {
            name = String.valueOf(name.substring(0, 30)) + " ...";
        }
        tab.setText(name);
    }

    @Override
    public boolean hasReport() {
        return this.document != null;
    }

    @Override
    public JasperPrint getReport() {
        return this.document;
    }

    @Override
    public void setZoom(float zoom) {
        this.viewerCanvas.setZoom(zoom);
    }

    @Override
    public boolean canChangeZoom() {
        return this.viewerCanvas.hasReport();
    }

    @Override
    public int getZoomMode() {
        return this.viewerCanvas.getZoomMode();
    }

    @Override
    public void setZoomMode(int zoomMode) {
        this.viewerCanvas.setZoomMode(zoomMode);
    }

    @Override
    public float[] getZoomLevels() {
        return this.viewerCanvas.getZoomLevels();
    }

    @Override
    public void zoomIn() {
        this.viewerCanvas.zoomIn();
    }

    @Override
    public boolean canZoomIn() {
        return this.viewerCanvas.canZoomIn();
    }

    @Override
    public float getZoom() {
        return this.viewerCanvas.getZoom();
    }

    @Override
    public void zoomOut() {
        this.viewerCanvas.zoomOut();
    }

    @Override
    public boolean canZoomOut() {
        return this.viewerCanvas.canZoomOut();
    }

    public int getPageCount() {
        return this.document == null ? 0 : this.document.getPages().size();
    }

    @Override
    public int getPageIndex() {
        return Math.max(0, this.pageIndex);
    }

    @Override
    public void setPageIndex(int pageIndex) {
        if (pageIndex != this.getPageIndex()) {
            this.pageIndex = Math.min(Math.max(0, pageIndex), this.getPageCount() - 1);
            this.fireViewerModelChanged(false);
            if (this.tFolder != null && this.document != null && this.document.hasParts()) {
                int ind = 0;
                Iterator it = this.document.getParts().partsIterator();
                while (it.hasNext()) {
                    int index = (Integer)((Map.Entry)it.next()).getKey();
                    if (index > pageIndex) break;
                    ++ind;
                }
                if (!this.startsAtZero && ind > 0) {
                    ++ind;
                }
                this.tFolder.setSelection(ind - 1);
            }
        }
    }

    @Override
    public boolean canGotoFirstPage() {
        return this.hasReport() && this.pageIndex > 0;
    }

    @Override
    public void gotoFirstPage() {
        if (this.pageIndex != 0 && this.canGotoFirstPage()) {
            this.setPageIndex(0);
        }
    }

    @Override
    public boolean canGotoLastPage() {
        return this.hasReport() && this.pageIndex < this.getPageCount() - 1;
    }

    @Override
    public void gotoLastPage() {
        if (this.canGotoLastPage()) {
            this.setPageIndex(this.getPageCount() - 1);
        }
    }

    @Override
    public boolean canGotoNextPage() {
        return this.hasReport() && this.pageIndex < this.getPageCount() - 1;
    }

    @Override
    public void gotoNextPage() {
        if (this.canGotoNextPage()) {
            this.setPageIndex(this.pageIndex + 1);
        }
    }

    @Override
    public boolean canGotoPreviousPage() {
        return this.hasReport() && this.pageIndex > 0;
    }

    @Override
    public void gotoPreviousPage() {
        if (this.canGotoPreviousPage()) {
            this.setPageIndex(this.pageIndex - 1);
        }
    }

    @Override
    public void addReportViewerListener(IReportViewerListener listener) {
        this.listenerSet.add(listener);
    }

    @Override
    public void removeReportViewerListener(IReportViewerListener listener) {
        this.listenerSet.remove(listener);
    }

    @Override
    public void fireViewerModelChanged(boolean isCurrentPage) {
        ReportViewerEvent e = new ReportViewerEvent(this, isCurrentPage);
        for (IReportViewerListener l : this.listenerSet) {
            l.viewerStateChanged(e);
        }
    }

    public Control createControl(Composite parent) {
        if (this.viewerComposite == null) {
            this.viewerComposite = new Composite(parent, 0);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.viewerComposite.setLayout((Layout)layout);
            this.tFolder = new CTabFolder(this.viewerComposite, 0x800080);
            this.tFolderFD = new FormData();
            this.tFolderFD.height = 0;
            this.tFolderFD.left = new FormAttachment(0, 0);
            this.tFolderFD.right = new FormAttachment(100, 0);
            this.tFolder.setLayoutData((Object)this.tFolderFD);
            this.tFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CTabItem tItem = ReportViewer.this.tFolder.getSelection();
                    Object obj = tItem.getData();
                    if (obj != null) {
                        Map.Entry p = (Map.Entry)obj;
                        ReportViewer.this.setPageIndex((Integer)p.getKey());
                    } else {
                        ReportViewer.this.gotoFirstPage();
                    }
                }
            });
            this.viewerCanvas = new ViewerCanvas(this.viewerComposite, this.style, this.jContext);
            this.viewerCanvas.setReportViewer(this);
            FormData fd = new FormData();
            fd.top = new FormAttachment((Control)this.tFolder, 0);
            fd.bottom = new FormAttachment(100, 0);
            fd.left = new FormAttachment(0, 0);
            fd.right = new FormAttachment(100, 0);
            this.viewerCanvas.setLayoutData(fd);
        }
        return this.viewerComposite;
    }

    @Override
    public Control getControl() {
        return this.viewerComposite;
    }

    @Override
    public void addHyperlinkListener(JRHyperlinkListener listener) {
        if (this.hyperlinkListeners == null) {
            this.hyperlinkListeners = new ArrayList<JRHyperlinkListener>();
        } else {
            this.hyperlinkListeners.remove(listener);
        }
        this.hyperlinkListeners.add(listener);
    }

    @Override
    public void removeHyperlinkListener(JRHyperlinkListener listener) {
        if (this.hyperlinkListeners != null) {
            this.hyperlinkListeners.remove(listener);
        }
    }

    @Override
    public JRHyperlinkListener[] getHyperlinkListeners() {
        return this.hyperlinkListeners == null ? new JRHyperlinkListener[]{} : this.hyperlinkListeners.toArray(new JRHyperlinkListener[this.hyperlinkListeners.size()]);
    }
}

