/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.eclipse.viewer.action;

import java.text.DecimalFormat;
import net.sf.jasperreports.eclipse.viewer.IReportViewer;
import net.sf.jasperreports.eclipse.viewer.IReportViewerListener;
import net.sf.jasperreports.eclipse.viewer.ReportViewerEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ZoomComboContributionItem
extends ContributionItem {
    private SelectionListener selListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (ZoomComboContributionItem.this.isRefresh) {
                return;
            }
            ZoomComboContributionItem.this.onSelection();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private FocusListener fListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
        }

        public void focusGained(FocusEvent e) {
            if (ZoomComboContributionItem.this.isRefresh) {
                return;
            }
        }
    };
    private IReportViewerListener viewListener = new IReportViewerListener(){

        @Override
        public void viewerStateChanged(ReportViewerEvent evt) {
            if (!evt.isCurrentPage()) {
                ZoomComboContributionItem.this.refresh();
            }
        }
    };
    private static DecimalFormat ZOOM_FORMAT = new DecimalFormat("####%");
    private IReportViewer rViewer;
    private Combo zCombo;
    private ToolItem tItem;
    private float[] zoomLevels;
    private boolean isRefresh = false;

    public ZoomComboContributionItem(IReportViewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.rViewer = viewer;
        this.rViewer.addReportViewerListener(this.viewListener);
    }

    private void refresh() {
        block5: {
            if (this.zCombo == null || this.zCombo.isDisposed()) {
                return;
            }
            try {
                this.zCombo.setEnabled(this.rViewer.canChangeZoom());
                if (!this.rViewer.canChangeZoom()) {
                    this.zCombo.setText("");
                } else {
                    this.setZoom();
                }
            }
            catch (SWTException exception) {
                if (SWT.getPlatform().equals("gtk")) break block5;
                throw exception;
            }
        }
    }

    private String[] getZoomLevelsAsText() {
        this.zoomLevels = this.rViewer.getZoomLevels();
        if (this.zoomLevels == null) {
            return new String[]{"100%"};
        }
        String[] textZoomLevels = new String[this.zoomLevels.length];
        int i = 0;
        while (i < textZoomLevels.length) {
            textZoomLevels[i] = ZOOM_FORMAT.format(this.zoomLevels[i]);
            ++i;
        }
        return textZoomLevels;
    }

    private Control createControl(Composite parent) {
        Composite comboComp = new Composite(parent, 0);
        GridLayout comboCompL = new GridLayout();
        comboCompL.horizontalSpacing = 0;
        comboCompL.verticalSpacing = 0;
        comboCompL.marginHeight = 0;
        comboCompL.marginWidth = 0;
        comboComp.setLayout((Layout)comboCompL);
        this.zCombo = new Combo(comboComp, 4);
        GridData comboGD = new GridData(4, 0x1000000, true, true);
        this.zCombo.setLayoutData((Object)comboGD);
        this.zCombo.addSelectionListener(this.selListener);
        this.zCombo.addFocusListener(this.fListener);
        this.zCombo.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (ZoomComboContributionItem.this.isRefresh) {
                    return;
                }
                String t = ZoomComboContributionItem.this.zCombo.getText();
                int end = t.indexOf("%");
                if (e.end > end) {
                    e.doit = false;
                    ZoomComboContributionItem.this.zCombo.setSelection(new Point(end - 1, end - 1));
                }
                if (!Character.isDigit(e.character) && e.character != '\b' && e.character != '\u007f' && e.character != '\r') {
                    e.doit = false;
                    return;
                }
                if (e.character == '\u007f' && !Character.isDigit(ZoomComboContributionItem.this.zCombo.getText().charAt(e.start))) {
                    e.doit = false;
                }
            }
        });
        this.zCombo.setItems(this.getZoomLevelsAsText());
        this.tItem.setWidth(this.computeWidth((Control)comboComp));
        this.refresh();
        return comboComp;
    }

    protected int computeWidth(Control control) {
        return control.computeSize((int)-1, (int)-1, (boolean)true).x;
    }

    public void dispose() {
        this.zCombo = null;
        this.rViewer.removeReportViewerListener(this.viewListener);
        this.rViewer = null;
    }

    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    public void fill(ToolBar parent, int index) {
        this.tItem = new ToolItem(parent, 2, index);
        Control ctrl = this.createControl((Composite)parent);
        this.tItem.setControl(ctrl);
    }

    private void onSelection() {
        if (this.isRefresh) {
            return;
        }
        if (this.rViewer.hasReport()) {
            int ind = this.zCombo.getSelectionIndex();
            this.setZoomAsText(ind >= 0 ? this.zCombo.getItem(ind) : this.zCombo.getText());
        }
    }

    private void setZoomAsText(String value) {
        int ind = value.indexOf(37);
        if (ind != -1) {
            value = value.substring(0, ind);
        }
        try {
            final float zoom = Float.parseFloat(value) / 100.0f;
            if (zoom != this.rViewer.getZoom()) {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ZoomComboContributionItem.this.rViewer.setZoom(zoom);
                    }
                });
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    protected void setZoom() {
        this.isRefresh = true;
        String zoom = ZOOM_FORMAT.format(this.rViewer.getZoom());
        this.zCombo.setText(zoom);
        this.isRefresh = false;
    }
}

