/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.expressions.annotations;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.eclipse.JasperReportsPlugin;
import net.sf.jasperreports.eclipse.builder.jdt.JDTUtils;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.MessageUtil;
import net.sf.jasperreports.expressions.annotations.JRExprFunction;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionBean;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionCategories;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionCategoryBean;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionParameterBean;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionParameters;
import net.sf.jasperreports.functions.annotations.Function;
import net.sf.jasperreports.functions.annotations.FunctionCategories;
import net.sf.jasperreports.functions.annotations.FunctionCategory;
import net.sf.jasperreports.functions.annotations.FunctionMessagesBundle;
import net.sf.jasperreports.functions.annotations.FunctionParameter;
import net.sf.jasperreports.functions.annotations.FunctionParameters;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;

public final class JRExprAnnotationsUtils {
    private final JasperReportsContext jasperReportsContext;
    private final MessageUtil messageUtil;

    private JRExprAnnotationsUtils(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        this.messageUtil = MessageUtil.getInstance((JasperReportsContext)jasperReportsContext);
    }

    public static JRExprAnnotationsUtils getInstance(JasperReportsContext jasperReportsContext) {
        return new JRExprAnnotationsUtils(jasperReportsContext);
    }

    public static List<JRExprFunctionBean> getJRFunctionsList(Class<?> clazz) {
        return JRExprAnnotationsUtils.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).getFunctionsList(clazz);
    }

    private String getFunctionMessBundle(Class clazz) {
        String functionMessBundle = "jasperreports_messages";
        if (clazz.getPackage() != null) {
            functionMessBundle = String.valueOf(clazz.getPackage().getName()) + ".jasperreports_messages";
        }
        return functionMessBundle;
    }

    private JRExprFunctionBean createJRFunction(List<Method> methods, Class<?> clazz) {
        FunctionParameters newParametersAnnotation;
        Object[] objectArray;
        JRExprFunctionBean funct = new JRExprFunctionBean(clazz.getCanonicalName());
        Method first = methods.get(0);
        funct.setId(first.getName());
        funct.setReturnType(first.getReturnType());
        String functionMessBundle = this.getFunctionMessBundle(clazz);
        FunctionMessagesBundle functionMessBundleAnn = first.getAnnotation(FunctionMessagesBundle.class);
        if (functionMessBundleAnn == null) {
            functionMessBundleAnn = clazz.getAnnotation(FunctionMessagesBundle.class);
        }
        if (functionMessBundleAnn != null) {
            functionMessBundle = functionMessBundleAnn.value();
        }
        String functionName = null;
        String functionDescription = null;
        Function newFunctionAnnotation = first.getAnnotation(Function.class);
        if (newFunctionAnnotation == null) {
            JRExprFunction functionAnnotation = first.getAnnotation(JRExprFunction.class);
            functionName = functionAnnotation.name();
            functionDescription = functionAnnotation.description();
        } else {
            String description;
            functionName = newFunctionAnnotation.value();
            String name = this.messageUtil.getMessageProvider(functionMessBundle).getMessage(String.valueOf(clazz.getName()) + "." + funct.getId() + ".name", null, Locale.getDefault());
            if (name != null) {
                functionName = name;
            }
            if ((description = this.messageUtil.getMessageProvider(functionMessBundle).getMessage(String.valueOf(clazz.getName()) + "." + funct.getId() + ".description", null, Locale.getDefault())) != null) {
                functionDescription = description;
            }
        }
        funct.setName(functionName);
        funct.setDescription(functionDescription);
        JRExprFunctionCategories functionCategoriesAnnotation = first.getAnnotation(JRExprFunctionCategories.class);
        if (functionCategoriesAnnotation == null) {
            FunctionCategories newFunctionCategoriesAnnotation = first.getAnnotation(FunctionCategories.class);
            if (newFunctionCategoriesAnnotation == null) {
                newFunctionCategoriesAnnotation = clazz.getAnnotation(FunctionCategories.class);
            }
            if (newFunctionCategoriesAnnotation != null) {
                Class[] categories = newFunctionCategoriesAnnotation.value();
                objectArray = categories;
                int n = categories.length;
                int n2 = 0;
                while (n2 < n) {
                    String description;
                    String name;
                    Class categoryClass = objectArray[n2];
                    String categoryId = categoryClass.getName();
                    String categoryName = null;
                    String categoryDescription = null;
                    FunctionCategory functionCategory = categoryClass.getAnnotation(FunctionCategory.class);
                    if (functionCategory != null) {
                        String id = functionCategory.value();
                        if (id != null && id.trim().length() > 0) {
                            categoryId = id;
                        }
                        categoryName = functionCategory.value();
                    }
                    String categoryMessBundle = this.getFunctionMessBundle(categoryClass);
                    FunctionMessagesBundle categMessBundleAnn = categoryClass.getAnnotation(FunctionMessagesBundle.class);
                    if (categMessBundleAnn != null) {
                        categoryMessBundle = categMessBundleAnn.value();
                    }
                    if ((name = this.messageUtil.getMessageProvider(categoryMessBundle).getMessage(String.valueOf(categoryId) + ".name", null, Locale.getDefault())) != null) {
                        categoryName = name;
                    }
                    if ((description = this.messageUtil.getMessageProvider(categoryMessBundle).getMessage(String.valueOf(categoryId) + ".description", null, Locale.getDefault())) != null) {
                        categoryDescription = description;
                    }
                    JRExprFunctionCategoryBean categDescriptor = new JRExprFunctionCategoryBean();
                    categDescriptor.setId(categoryId);
                    categDescriptor.setName(categoryName);
                    categDescriptor.setDescription(categoryDescription);
                    funct.getCategories().add(categDescriptor);
                    ++n2;
                }
            }
        } else {
            String[] stringArray = functionCategoriesAnnotation.value();
            int categoryClass = stringArray.length;
            int categories = 0;
            while (categories < categoryClass) {
                String category = stringArray[categories];
                JRExprFunctionCategoryBean categDescriptor = new JRExprFunctionCategoryBean();
                categDescriptor.setId(category);
                categDescriptor.setName(this.messageUtil.getMessageProvider("MessagesBundle").getMessage("Category." + category + ".display", null, Locale.getDefault()));
                categDescriptor.setDescription(this.messageUtil.getMessageProvider("MessagesBundle").getMessage("Category." + category + ".description", null, Locale.getDefault()));
                funct.getCategories().add(categDescriptor);
                ++categories;
            }
        }
        if ((newParametersAnnotation = first.getAnnotation(FunctionParameters.class)) == null) {
            JRExprFunctionParameters parametersAnnotation = first.getAnnotation(JRExprFunctionParameters.class);
            if (parametersAnnotation != null) {
                objectArray = parametersAnnotation.value();
                int categDescriptor = objectArray.length;
                int n = 0;
                while (n < categDescriptor) {
                    Object param = objectArray[n];
                    JRExprFunctionParameterBean paramDescriptor = new JRExprFunctionParameterBean();
                    paramDescriptor.setName(param.name());
                    paramDescriptor.setDescription(param.description());
                    funct.getParameters().add(paramDescriptor);
                    ++n;
                }
            }
        } else {
            FunctionParameter[] categDescriptor = newParametersAnnotation.value();
            int n = categDescriptor.length;
            int param = 0;
            while (param < n) {
                FunctionParameter param2 = categDescriptor[param];
                JRExprFunctionParameterBean paramDescriptor = new JRExprFunctionParameterBean();
                String parameterId = param2.value();
                String parameterName = null;
                String parameterDescription = null;
                if (parameterId != null && parameterId.trim().length() > 0) {
                    String description;
                    String name = this.messageUtil.getMessageProvider(functionMessBundle).getMessage(String.valueOf(clazz.getName()) + "." + funct.getId() + "." + parameterId + ".name", null, Locale.getDefault());
                    if (name != null) {
                        parameterName = name;
                    }
                    if ((description = this.messageUtil.getMessageProvider(functionMessBundle).getMessage(String.valueOf(clazz.getName()) + "." + funct.getId() + "." + parameterId + ".description", null, Locale.getDefault())) != null) {
                        parameterDescription = description;
                    }
                }
                paramDescriptor.setName(parameterName);
                paramDescriptor.setDescription(parameterDescription);
                funct.getParameters().add(paramDescriptor);
                ++param;
            }
        }
        int paramIndex = 0;
        int paramsNum = funct.getParameters().size();
        int i = 0;
        while (i < methods.size() && paramIndex < paramsNum) {
            Method currMethod = methods.get(i);
            Class<?>[] parameterTypes = currMethod.getParameterTypes();
            boolean isOptional = i != 0;
            int j = paramIndex;
            while (j < parameterTypes.length) {
                boolean isMulti = parameterTypes[j].isArray();
                JRExprFunctionParameterBean paramFunctBean = funct.getParameters().get(paramIndex);
                if (paramFunctBean != null) {
                    paramFunctBean.setOptional(isOptional);
                    paramFunctBean.setMulti(isMulti);
                    paramFunctBean.setParameterType(parameterTypes[j]);
                }
                ++j;
                ++paramIndex;
            }
            ++i;
        }
        return funct;
    }

    private Map<String, List<Method>> buildAnnotatedMethodsCache(Class<?> clazz) {
        List<Method> methods;
        String methodName;
        Function jrNewFunctionAnn;
        JRExprFunction jrFunctionAnn;
        Method m;
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        IProject currProj = JDTUtils.getCurrentProjectForOpenEditor();
        String classCanonicalName = clazz.getCanonicalName();
        if (currProj != null && !classCanonicalName.startsWith("net.sf.jasperreports.functions.standard") && ctxClassLoader == null) {
            ctxClassLoader = this.getClass().getClassLoader();
        }
        HashMap<String, List<Method>> methodsByNameMap = new HashMap<String, List<Method>>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            m = methodArray[n2];
            jrFunctionAnn = m.getAnnotation(JRExprFunction.class);
            jrNewFunctionAnn = m.getAnnotation(Function.class);
            if (jrNewFunctionAnn != null || jrFunctionAnn != null) {
                methodName = m.getName();
                methods = (ArrayList<Method>)methodsByNameMap.get(methodName);
                if (methods == null) {
                    methods = new ArrayList<Method>();
                }
                methods.add(m);
                methodsByNameMap.put(methodName, methods);
            }
            ++n2;
        }
        methodArray = clazz.getMethods();
        n = methodArray.length;
        n2 = 0;
        while (n2 < n) {
            m = methodArray[n2];
            jrFunctionAnn = m.getAnnotation(JRExprFunction.class);
            jrNewFunctionAnn = m.getAnnotation(Function.class);
            if ((jrNewFunctionAnn == null || jrFunctionAnn == null) && (methods = (List)methodsByNameMap.get(methodName = m.getName())) != null) {
                methods.add(m);
            }
            ++n2;
        }
        return methodsByNameMap;
    }

    public List<JRExprFunctionBean> getFunctionsList(Class<?> clazz) {
        Map<String, List<Method>> methodsCache = this.buildAnnotatedMethodsCache(clazz);
        ArrayList<JRExprFunctionBean> functionsList = new ArrayList<JRExprFunctionBean>();
        for (String functionName : methodsCache.keySet()) {
            try {
                JRExprFunctionBean jrFunction = this.createJRFunction(methodsCache.get(functionName), clazz);
                functionsList.add(jrFunction);
            }
            catch (Exception ex) {
                JasperReportsPlugin.getDefault().logError(NLS.bind((String)"Unable to create the function ''{0}'' from class ''{1}''. See full stacktrace.", (Object)functionName, (Object)clazz.getCanonicalName()), ex);
            }
        }
        return functionsList;
    }
}

