/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jaspersoft.jasperserver.api.JasperServerAPI;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;

@JasperServerAPI
@XmlRootElement(name="resourceReference")
public class ResourceReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean local;
    private String referenceURI;
    private ResourceLookup referenceLookup;
    private Resource localResource;

    public ResourceReference(String referenceURI) {
        this.setReference(referenceURI);
    }

    public ResourceReference(ResourceLookup referenceLookup) {
        this.setReference(referenceLookup);
    }

    public ResourceReference(Resource localResource) {
        this.setLocalResource(localResource);
    }

    public boolean isLocal() {
        return this.local;
    }

    public Resource getLocalResource() {
        return this.localResource;
    }

    public String getReferenceURI() {
        return this.referenceURI;
    }

    public ResourceLookup getReferenceLookup() {
        return this.referenceLookup;
    }

    public String getTargetURI() {
        String uri = this.isLocal() ? (this.localResource == null ? null : this.localResource.getURIString()) : this.referenceURI;
        return uri;
    }

    public void setLocalResource(Resource localResource) {
        this.local = true;
        this.referenceURI = null;
        this.referenceLookup = null;
        this.localResource = localResource;
    }

    public void setReference(String referenceURI) {
        this.local = false;
        this.referenceURI = referenceURI;
        this.referenceLookup = null;
        this.localResource = null;
    }

    @JsonIgnore
    public void setReference(ResourceLookup referenceLookup) {
        this.local = false;
        this.referenceURI = referenceLookup.getURIString();
        this.referenceLookup = referenceLookup;
        this.localResource = null;
    }
}

