/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.exception;

import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;

public class RemoteException
extends RuntimeException {
    private ErrorDescriptor errorDescriptor;

    public RemoteException() {
        this.errorDescriptor = new ErrorDescriptor();
    }

    public RemoteException(String message) {
        super(message);
        this.errorDescriptor = new ErrorDescriptor().setMessage(message);
    }

    public RemoteException(String message, Throwable cause) {
        super(message, cause);
        this.errorDescriptor = new ErrorDescriptor().setMessage(message);
    }

    public RemoteException(Throwable cause) {
        super(cause);
        this.errorDescriptor = new ErrorDescriptor().setException(cause);
    }

    public RemoteException(ErrorDescriptor errorDescriptor) {
        super(errorDescriptor.getMessage());
        this.errorDescriptor = errorDescriptor;
    }

    public RemoteException(ErrorDescriptor errorDescriptor, Throwable e) {
        super(errorDescriptor.getMessage(), e);
        this.errorDescriptor = errorDescriptor;
    }

    public ErrorDescriptor getErrorDescriptor() {
        return this.errorDescriptor;
    }

    public void setErrorDescriptor(ErrorDescriptor errorDescriptor) {
        this.errorDescriptor = errorDescriptor;
    }

    public Boolean isUnexpected() {
        if (this.getErrorDescriptor() != null && "unexpected.error".equals(this.getErrorDescriptor().getErrorCode())) {
            return true;
        }
        return false;
    }
}

