/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.remote.services.ExecutionStatus;
import com.jaspersoft.jasperserver.remote.services.ExportExecution;
import com.jaspersoft.jasperserver.remote.services.ExportExecutionOptions;
import com.jaspersoft.jasperserver.remote.services.ReportExecutionOptions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class ReportExecution {
    private ExecutionStatus status;
    private Integer totalPages;
    private Integer currentPage;
    private ErrorDescriptor errorDescriptor;
    private Map<ExportExecutionOptions, ExportExecution> exports = new ConcurrentHashMap<ExportExecutionOptions, ExportExecution>();
    private ReportUnitResult reportUnitResult;
    private Map<String, String[]> rawParameters;
    private String requestId;
    private String reportURI;
    private ReportExecutionOptions options;
    private final Lock resultLock = new ReentrantLock();
    private final Condition resultExist = this.resultLock.newCondition();

    @XmlTransient
    public Map<String, String[]> getRawParameters() {
        return this.rawParameters;
    }

    public void setRawParameters(Map<String, String[]> rawParameters) {
        this.rawParameters = rawParameters;
    }

    @XmlTransient
    public ReportExecutionOptions getOptions() {
        return this.options;
    }

    public void setOptions(ReportExecutionOptions options) {
        this.options = options;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @XmlTransient
    public ReportUnitResult getFinalReportUnitResult() {
        this.resultLock.lock();
        try {
            try {
                while (this.reportUnitResult == null) {
                    if (this.status == ExecutionStatus.cancelled) return this.reportUnitResult;
                    if (this.status == ExecutionStatus.failed) {
                        return this.reportUnitResult;
                    }
                    this.resultExist.await();
                }
                return this.reportUnitResult;
            }
            catch (InterruptedException e) {
                throw new JSException(e);
            }
        }
        finally {
            this.resultLock.unlock();
        }
    }

    @XmlTransient
    public ReportUnitResult getReportUnitResult() {
        return this.reportUnitResult;
    }

    public void setReportUnitResult(ReportUnitResult reportUnitResult) {
        this.resultLock.lock();
        try {
            this.reportUnitResult = reportUnitResult;
            this.resultExist.signalAll();
        }
        finally {
            this.resultLock.unlock();
        }
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @XmlElement(name="export")
    @XmlElementWrapper(name="exports")
    public Set<ExportExecution> getExportsSet() {
        return this.exports != null && !this.exports.isEmpty() ? new HashSet<ExportExecution>(this.exports.values()) : null;
    }

    public void setExportsSet(Set<ExportExecution> exportsSet) {
        if (exportsSet != null) {
            HashMap<ExportExecutionOptions, ExportExecution> exports = new HashMap<ExportExecutionOptions, ExportExecution>();
            for (ExportExecution currentExport : exportsSet) {
                exports.put(currentExport.getOptions(), currentExport);
            }
            this.setExports(exports);
        } else {
            this.setExports(null);
        }
    }

    @XmlTransient
    public Map<ExportExecutionOptions, ExportExecution> getExports() {
        return this.exports;
    }

    public void setExports(Map<ExportExecutionOptions, ExportExecution> exports) {
        this.exports = exports;
    }

    public ErrorDescriptor getErrorDescriptor() {
        return this.errorDescriptor;
    }

    public void setErrorDescriptor(ErrorDescriptor errorDescriptor) {
        this.errorDescriptor = errorDescriptor;
    }

    public String getReportURI() {
        return this.reportURI;
    }

    public void setReportURI(String reportURI) {
        this.reportURI = reportURI;
    }

    public ExecutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(ExecutionStatus status) {
        this.resultLock.lock();
        try {
            this.status = status;
            this.resultExist.signalAll();
        }
        finally {
            this.resultLock.unlock();
        }
    }

    public Integer getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(Integer totalPages) {
        this.totalPages = totalPages;
    }
}

