/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services;

import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReportOutputPages {
    private Integer page;
    private Integer startPage;
    private Integer endPage;

    public Integer getPage() {
        return this.page;
    }

    public ReportOutputPages setPage(Integer page) {
        this.page = page;
        return this;
    }

    public Integer getStartPage() {
        return this.startPage;
    }

    public ReportOutputPages setStartPage(Integer startPage) {
        this.startPage = startPage;
        return this;
    }

    public Integer getEndPage() {
        return this.endPage;
    }

    public ReportOutputPages setEndPage(Integer endPage) {
        this.endPage = endPage;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReportOutputPages setPages(String pages) throws IllegalParameterValueException {
        if (Pattern.matches("\\d+", pages)) {
            this.setPage(Integer.valueOf(pages));
            return this;
        } else {
            Integer endPage;
            Matcher matcher = Pattern.compile("^(\\d+)-(\\d+)$").matcher(pages);
            if (!matcher.find()) throw new IllegalParameterValueException(new ErrorDescriptor().setErrorCode("report.invalid.page.range").setParameters(new String[]{pages}));
            Integer startPage = Integer.valueOf(matcher.group(1));
            if (startPage.compareTo(endPage = Integer.valueOf(matcher.group(2))) >= 0) throw new IllegalParameterValueException(new ErrorDescriptor().setErrorCode("report.start.page.greater.then.end.page").setParameters(new String[]{"Start page: " + startPage, "End page: " + endPage}));
            this.setStartPage(startPage);
            this.setEndPage(endPage);
        }
        return this;
    }

    public static ReportOutputPages valueOf(String pages) throws IllegalParameterValueException {
        return pages != null && !pages.isEmpty() ? new ReportOutputPages().setPages(pages) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReportOutputPages)) {
            return false;
        }
        ReportOutputPages that = (ReportOutputPages)o;
        if (this.endPage != null ? !this.endPage.equals(that.endPage) : that.endPage != null) {
            return false;
        }
        if (this.page != null ? !this.page.equals(that.page) : that.page != null) {
            return false;
        }
        return !(this.startPage != null ? !this.startPage.equals(that.startPage) : that.startPage != null);
    }

    public int hashCode() {
        int result = this.page != null ? this.page.hashCode() : 0;
        result = 31 * result + (this.startPage != null ? this.startPage.hashCode() : 0);
        result = 31 * result + (this.endPage != null ? this.endPage.hashCode() : 0);
        return result;
    }

    public String toString() {
        String result = "no pages information";
        if (this.page != null) {
            result = this.page.toString();
        } else if (this.startPage != null && this.endPage != null) {
            result = String.valueOf(this.startPage.toString()) + "-" + this.endPage.toString();
        }
        return result;
    }
}

