/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.xml;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceProperty;
import java.io.Serializable;
import java.io.StringWriter;

public class Marshaller {
    private String currentIndentation = "";
    public static final String[] special_chars = new String[]{"&", "&amp;", "\"", "&quot;", "'", "&apos;", "<", "&lt;", ">", "&gt;"};
    private String encoding = "UTF-8";

    public static void marshal(Object obj, StringWriter out) {
        Marshaller marshaller = new Marshaller();
        if (obj instanceof Request) {
            out.write(marshaller.marshal((Request)obj));
        } else if (obj instanceof OperationResult) {
            out.write(marshaller.marshal((OperationResult)obj));
        }
    }

    public static String xmlEscape(String text) {
        if (text == null) {
            return "";
        }
        int i = 0;
        i = 0;
        while (i < special_chars.length) {
            text = Marshaller.string_replace(special_chars[i + 1], special_chars[i], text);
            i += 2;
        }
        return text;
    }

    public static String string_replace(String s1, String s2, String s3) {
        String string = "";
        string = "";
        if (s2 == null || s3 == null || s2.length() == 0) {
            return s3;
        }
        int pos_i = 0;
        int pos_f = 0;
        int len = s2.length();
        while ((pos_f = s3.indexOf(s2, pos_i)) >= 0) {
            string = String.valueOf(string) + s3.substring(pos_i, pos_f) + s1;
            pos_f = pos_i = pos_f + len;
        }
        string = String.valueOf(string) + s3.substring(pos_i);
        return string;
    }

    public String marshal(Request request) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\"?>\n");
        xml.append("<request operationName=\"" + request.getOperationName() + "\"");
        if (request.getLocale() != null) {
            xml.append(" locale=\"" + request.getLocale() + "\"");
        }
        xml.append(">\n");
        this.currentIndentation = "\t";
        int i = 0;
        while (i < request.getArguments().size()) {
            Argument a = (Argument)request.getArguments().get(i);
            String value = a.getValue() == null ? "/>" : "><![CDATA[" + a.getValue() + "]]></argument>";
            xml.append(String.valueOf(this.currentIndentation) + "<argument name=\"" + Marshaller.xmlEscape(a.getName()) + "\"" + value + "\n");
            ++i;
        }
        xml.append(this.writeResourceDescriptor(request.getResourceDescriptor()));
        xml.append("</request>\n");
        return xml.toString();
    }

    public String writeResourceDescriptor(ResourceDescriptor rd) {
        Serializable rdchild;
        int i;
        if (rd == null) {
            return "";
        }
        StringBuffer xml = new StringBuffer();
        xml.append(String.valueOf(this.currentIndentation) + "<resourceDescriptor");
        if (rd.getName() != null && !rd.getName().equals("")) {
            xml.append(" name=\"" + Marshaller.xmlEscape(rd.getName()) + "\"");
        }
        if (rd.getWsType() != null && !rd.getWsType().equals("")) {
            xml.append(" wsType=\"" + Marshaller.xmlEscape(rd.getWsType()) + "\"");
            if (rd.getWsType().equals("reference") && rd.getReferenceType() != null && !rd.getReferenceType().equals("")) {
                xml.append(" referenceType=\"" + Marshaller.xmlEscape(rd.getReferenceType()) + "\"");
            }
        }
        if (rd.getUriString() != null && !rd.getUriString().equals("")) {
            xml.append(" uriString=\"" + Marshaller.xmlEscape(rd.getUriString()) + "\"");
        }
        xml.append(" isNew=\"" + rd.getIsNew() + "\"");
        xml.append(">\n");
        this.currentIndentation = String.valueOf(this.currentIndentation) + "\t";
        if (rd.getLabel() != null && !rd.getLabel().equals("")) {
            xml.append(String.valueOf(this.currentIndentation) + "<label><![CDATA[" + rd.getLabel() + "]]></label>\n");
        }
        if (rd.getDescription() != null && rd.getDescription().length() > 0) {
            xml.append(String.valueOf(this.currentIndentation) + "<description><![CDATA[" + rd.getDescription() + "]]></description>\n");
        }
        if (rd.getCreationDate() != null) {
            xml.append(this.currentIndentation);
            xml.append("<creationDate>");
            this.writeCreationDateText(rd, xml);
            xml.append("</creationDate>\n");
        }
        if (rd.getProperties() != null) {
            i = 0;
            while (i < rd.getProperties().size()) {
                ResourceProperty rp = rd.getProperties().get(i);
                String s = this.writeResourceProperty(rd, rp);
                xml.append(s);
                ++i;
            }
        }
        if (rd.getChildren() != null) {
            i = 0;
            while (i < rd.getChildren().size()) {
                rdchild = rd.getChildren().get(i);
                xml.append(this.writeResourceDescriptor((ResourceDescriptor)rdchild));
                ++i;
            }
        }
        if (rd.getParameters() != null) {
            i = 0;
            while (i < rd.getParameters().size()) {
                rdchild = rd.getParameters().get(i);
                xml.append(this.writeResourceParameter((ListItem)rdchild));
                ++i;
            }
        }
        this.currentIndentation = this.currentIndentation.substring(0, this.currentIndentation.length() - 1);
        xml.append(String.valueOf(this.currentIndentation) + "</resourceDescriptor>\n");
        return xml.toString();
    }

    protected void writeCreationDateText(ResourceDescriptor rd, StringBuffer xml) {
        long timestamp = rd.getCreationDate().getTime();
        xml.append(timestamp);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private String writeResourceProperty(ResourceDescriptor rd, ResourceProperty rp) {
        StringBuffer xml = new StringBuffer();
        xml.append(String.valueOf(this.currentIndentation) + "<resourceProperty name=\"" + Marshaller.xmlEscape(rp.getName()) + "\">\n");
        this.currentIndentation = String.valueOf(this.currentIndentation) + "\t";
        if (rp.getValue() != null) {
            xml.append(String.valueOf(this.currentIndentation) + "<value><![CDATA[" + rp.getValue() + "]]></value>\n");
        }
        int i = 0;
        while (i < rp.getProperties().size()) {
            ResourceProperty rpChild = rp.getProperties().get(i);
            xml.append(this.writeResourceProperty(rd, rpChild));
            ++i;
        }
        this.currentIndentation = this.currentIndentation.substring(0, this.currentIndentation.length() - 1);
        xml.append(String.valueOf(this.currentIndentation) + "</resourceProperty>\n");
        return xml.toString();
    }

    private String writeResourceParameter(ListItem rp) {
        StringBuffer xml = new StringBuffer();
        xml.append(String.valueOf(this.currentIndentation) + "<parameter name=\"" + Marshaller.xmlEscape(rp.getLabel()) + "\"");
        if (rp.isIsListItem()) {
            xml.append(" isListItem=\"true\"");
        }
        xml.append("><![CDATA[");
        if (rp.getValue() != null) {
            xml.append(rp.getValue());
        }
        xml.append("]]></parameter>\n");
        return xml.toString();
    }

    public String marshal(OperationResult response) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\"?>\n");
        xml.append("<operationResult version=\"" + response.getVersion() + "\">\n");
        this.currentIndentation = "\t";
        xml.append(String.valueOf(this.currentIndentation) + "<returnCode><![CDATA[" + response.getReturnCode() + "]]></returnCode>\n");
        if (response.getMessage() != null && response.getMessage().length() > 0) {
            xml.append(String.valueOf(this.currentIndentation) + "<returnMessage><![CDATA[" + response.getMessage() + "]]></returnMessage>\n");
        }
        if (response.getResourceDescriptors() != null) {
            int i = 0;
            while (i < response.getResourceDescriptors().size()) {
                ResourceDescriptor rd = (ResourceDescriptor)response.getResourceDescriptors().get(i);
                xml.append(this.writeResourceDescriptor(rd));
                ++i;
            }
        }
        this.currentIndentation = this.currentIndentation.substring(0, this.currentIndentation.length() - 1);
        xml.append("</operationResult>\n");
        return xml.toString();
    }
}

