/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server;

import com.jaspersoft.studio.property.dataset.fields.table.widget.WJRProperty;
import com.jaspersoft.studio.server.JRSBuiltInParameterProvider;
import com.jaspersoft.studio.server.export.AExporter;
import com.jaspersoft.studio.server.ic.ICParameterContributor;
import com.jaspersoft.studio.server.ic.ResourcePropertyDescription;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MJrxml;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.plugin.ExtensionManager;
import com.jaspersoft.studio.server.utils.HttpUtils;
import com.jaspersoft.studio.server.wizard.resource.page.selector.SelectorDatasource;
import net.sf.jasperreports.eclipse.AbstractJRUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractJRUIPlugin {
    public static final String PLUGIN_ID = "com.jaspersoft.studio.server";
    private static Activator plugin;
    public static final String ICPATH = "icpath";
    public static final String DSPATH = "dspath";
    public static final String RSPATH = "rspath";
    public static final String RUPATH = "rupath";
    public static final String REPPATH = "reppath";
    public static final String SERVER_CATEGORY = "com.jaspersoft.studio.jrs.category:JasperReports.server";
    private static ExtensionManager extensionManager;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        HttpUtils.patchURIClass();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    protected void postStartOperations() {
        super.postStartOperations();
        ICParameterContributor.initMetadata();
        AExporter.initMetadata();
        WJRProperty.addCallback((String)ICPATH, c -> new ResourcePropertyDescription(c.getPropertyName(), c.getLabel(), c.getDescription(), false, null, c.getValue()){

            @Override
            protected boolean isResourceCompatible(AMResource r) {
                return r.getValue().getWsType().equals("inputControl");
            }
        });
        WJRProperty.addCallback((String)DSPATH, c -> new ResourcePropertyDescription(c.getPropertyName(), c.getLabel(), c.getDescription(), false, null, c.getValue()){

            @Override
            protected boolean isResourceCompatible(AMResource r) {
                return SelectorDatasource.isDatasource(r.getValue());
            }
        });
        WJRProperty.addCallback((String)RUPATH, c -> new ResourcePropertyDescription(c.getPropertyName(), c.getLabel(), c.getDescription(), false, null, c.getValue()){

            @Override
            protected boolean isResourceCompatible(AMResource r) {
                return r instanceof MReportUnit;
            }
        });
        WJRProperty.addCallback((String)RSPATH, c -> new ResourcePropertyDescription(c.getPropertyName(), c.getLabel(), c.getDescription(), false, null, c.getValue()));
        WJRProperty.addCallback((String)REPPATH, c -> new ResourcePropertyDescription(c.getPropertyName(), c.getLabel(), c.getDescription(), false, null, c.getValue()){

            @Override
            protected boolean isResourceCompatible(AMResource r) {
                return r instanceof MJrxml;
            }
        });
        Job initParametersJob = new Job("Init JRS built-in parameters"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    JRSBuiltInParameterProvider.init();
                }
                catch (Exception ex) {
                    Activator.this.logError(ex);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        initParametersJob.setPriority(30);
        initParametersJob.schedule(5000L);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ExtensionManager getExtManager() {
        if (extensionManager == null) {
            extensionManager = new ExtensionManager();
            extensionManager.init();
        }
        return extensionManager;
    }

    public String getPluginID() {
        return PLUGIN_ID;
    }
}

