/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server;

import com.jaspersoft.studio.prm.ParameterSet;
import com.jaspersoft.studio.prm.ParameterSetProvider;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.IOException;
import net.sf.jasperreports.eclipse.MScopedPreferenceStore;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.eclipse.jface.preference.IPreferenceStore;

public class JRSBuiltInParameterProvider {
    public static final String PARAMETERSET_JRS = "Jaspersoft Server Built In Parameters";

    public static void init() {
        MScopedPreferenceStore pstore = JasperReportsConfiguration.getDefaultInstance().getPrefStore();
        ParameterSet pset = ParameterSetProvider.getParameterSet((String)PARAMETERSET_JRS, (IPreferenceStore)pstore);
        if (pset == null) {
            pset = new ParameterSet();
            pset.setName(PARAMETERSET_JRS);
            pset.setBuiltIn(true);
            JRDesignParameter p = new JRDesignParameter();
            p.setName("LoggedInUser");
            p.setDescription("Not usable in query input control, but is used as parameter to report");
            p.setValueClassName("com.jaspersoft.jasperserver.api.metadata.user.domain.client.UserImpl");
            p.setDefaultValueExpression((JRExpression)new JRDesignExpression("new com.jaspersoft.jasperserver.api.metadata.user.domain.client.UserImpl()"));
            p.setForPrompting(false);
            pset.getParameters().add(p);
            p = new JRDesignParameter();
            p.setName("LoggedInUsername");
            p.setDescription("Of logged in user");
            p.setValueClassName("java.lang.String");
            p.setDefaultValueExpression((JRExpression)new JRDesignExpression("\"joeuser\""));
            p.setForPrompting(false);
            pset.getParameters().add(p);
            p = new JRDesignParameter();
            p.setName("LoggedInUserFullName");
            p.setDescription("Of logged in user");
            p.setValueClassName("java.lang.String");
            p.setDefaultValueExpression((JRExpression)new JRDesignExpression("\"Joe Smith\""));
            p.setForPrompting(false);
            pset.getParameters().add(p);
            p = new JRDesignParameter();
            p.setName("LoggedInUserEmailAddress");
            p.setDescription("Of logged in user");
            p.setValueClassName("java.lang.String");
            p.setDefaultValueExpression((JRExpression)new JRDesignExpression("\"joe@some.email\""));
            p.setForPrompting(false);
            pset.getParameters().add(p);
            p = new JRDesignParameter();
            p.setName("LoggedInUserEnabled");
            p.setDescription("Is logged in user enabled?");
            p.setValueClassName("java.lang.Boolean");
            p.setDefaultValueExpression((JRExpression)new JRDesignExpression("Boolean.TRUE"));
            p.setForPrompting(false);
            pset.getParameters().add(p);
            p = new JRDesignParameter();
            p.setName("LoggedInUserExternallyDefined");
            p.setDescription("Is logged in user externally defined? ie. authenticated externally");
            p.setValueClassName("java.lang.Boolean");
            p.setDefaultValueExpression((JRExpression)new JRDesignExpression("Boolean.FALSE"));
            p.setForPrompting(false);
            pset.getParameters().add(p);
            p = new JRDesignParameter();
            p.setName("LoggedInUserTenantId");
            p.setDescription("Of logged in user. Only relevant in Pro/Enterprise.");
            p.setValueClassName("java.lang.String");
            p.setDefaultValueExpression((JRExpression)new JRDesignExpression(""));
            p.setForPrompting(false);
            pset.getParameters().add(p);
            p = new JRDesignParameter();
            p.setName("LoggedInUserRoles");
            p.setDescription("Current set of roles of logged in user. Useful for $X parameter");
            p.setValueClassName("java.util.Collection");
            p.setNestedTypeName("java.lang.String");
            p.setDefaultValueExpression((JRExpression)new JRDesignExpression("new ArrayList()"));
            p.setForPrompting(false);
            pset.getParameters().add(p);
            p = new JRDesignParameter();
            p.setName("LoggedInUserAttributes");
            p.setDescription("Not usable in query input control, but is used as parameter to report. Empty map if no attributes");
            p.setValueClassName("java.util.Map");
            p.setNestedTypeName("java.lang.String");
            p.setDefaultValueExpression((JRExpression)new JRDesignExpression("new HashMap()"));
            p.setForPrompting(false);
            pset.getParameters().add(p);
            p = new JRDesignParameter();
            p.setName("LoggedInUserAttributeNames");
            p.setDescription("User profile attribute names. Useful for $X parameters. Empty collection if no attributes");
            p.setValueClassName("java.util.Collection");
            p.setNestedTypeName("java.lang.String");
            p.setDefaultValueExpression((JRExpression)new JRDesignExpression("new ArrayList()"));
            p.setForPrompting(false);
            pset.getParameters().add(p);
            p = new JRDesignParameter();
            p.setName("LoggedInUserAttributeValues");
            p.setDescription("");
            p.setValueClassName("java.util.Collection");
            p.setDefaultValueExpression((JRExpression)new JRDesignExpression("new ArrayList()"));
            p.setForPrompting(false);
            pset.getParameters().add(p);
            ParameterSetProvider.storeParameterSet((ParameterSet)pset, (IPreferenceStore)pstore);
        }
        try {
            String str = pstore.getString("com.jaspersoft.studio.parametersets");
            if (str != null) {
                String[] sets;
                try {
                    str = Misc.decodeBase64String((String)str, (String)"ISO-8859-1");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        pstore.save();
                    }
                    catch (IOException e2) {
                        Activator.getDefault().logError(e2);
                    }
                    return;
                }
                String[] stringArray = sets = str.split("\n");
                int n = sets.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    if (key.equals(PARAMETERSET_JRS)) {
                        return;
                    }
                    ++n2;
                }
            }
            str = PARAMETERSET_JRS + (str == null ? "" : "\n" + str);
            try {
                pstore.setValue("com.jaspersoft.studio.parametersets", Misc.encodeBase64String((String)str, (String)"ISO-8859-1"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                pstore.save();
            }
            catch (IOException e) {
                Activator.getDefault().logError(e);
            }
        }
    }
}

