/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server;

import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.IConversionFilenameProvider;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MDummy;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.util.ModelVisitor;
import com.jaspersoft.studio.server.ServerNameProvider;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.editor.JRSEditorContributor;
import com.jaspersoft.studio.server.export.AExporter;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.model.server.MServers;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.CastorHelper;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ServerManager {
    public static final String PREF_TAG = "serverprofiles";
    public static final String SERVERPROFILE = "SERVERPROFILE";
    private static PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(JaspersoftStudioPlugin.getInstance());
    private static HashMap<MServerProfile, String> serverProfiles;

    public static List<MServerProfile> getServerProfiles() {
        if (serverProfiles == null) {
            serverProfiles = new HashMap();
            ServerManager.loadServerProfiles(new MServers(null));
        }
        return new ArrayList<MServerProfile>(serverProfiles.keySet());
    }

    private static void saveIntoStrage(MServerProfile serverProfile, String fileName) {
        block5: {
            FileOutputStream stream = null;
            try {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(new InputSource(new StringReader(serverProfile.toXML())));
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource source = new DOMSource(doc);
                    File storage = ConfigurationManager.getStorage((String)PREF_TAG);
                    File destination = new File(storage, fileName);
                    stream = new FileOutputStream(destination);
                    StreamResult result = new StreamResult(stream);
                    transformer.transform(source, result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FileUtils.closeStream(stream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(stream);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)stream);
        }
    }

    public static List<ServerProfile> getServerList() {
        ServerManager.getServerProfiles();
        ArrayList<ServerProfile> servers = new ArrayList<ServerProfile>();
        for (MServerProfile ms : serverProfiles.keySet()) {
            servers.add(ms.getValue());
        }
        return servers;
    }

    public static String[] getServers() {
        List<ServerProfile> serverList = ServerManager.getServerList();
        String[] res = new String[serverList.size()];
        int i = 0;
        while (i < res.length) {
            res[i] = serverList.get(i).getName();
            ++i;
        }
        return res;
    }

    public static PropertyChangeSupport getPropertyChangeSupport() {
        return propertyChangeSupport;
    }

    public static boolean isUniqueName(MServerProfile sprofile, String name) {
        if (sprofile.getParent() != null && sprofile.getValue().getName().equals(name)) {
            return true;
        }
        for (MServerProfile sp : ServerManager.getServerProfiles()) {
            if (!sp.getValue().getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public static void addServerProfile(MServerProfile adapter) {
        if (!serverProfiles.containsKey((Object)adapter)) {
            ServerNameProvider nameProvider = new ServerNameProvider();
            String resourceName = nameProvider.getFileName(null);
            serverProfiles.put(adapter, resourceName);
            ServerManager.saveIntoStrage(adapter, resourceName);
            propertyChangeSupport.firePropertyChange(new PropertyChangeEvent((Object)adapter, SERVERPROFILE, null, (Object)adapter));
        }
    }

    public static void removeServerProfile(MServerProfile adapter) {
        if (serverProfiles.containsKey((Object)adapter)) {
            String fileName = serverProfiles.remove((Object)adapter);
            ConfigurationManager.removeStoregeResource((String)PREF_TAG, (String)fileName);
            adapter.getParent().removeChild((ANode)adapter);
            propertyChangeSupport.firePropertyChange(new PropertyChangeEvent((Object)adapter, SERVERPROFILE, null, (Object)adapter));
        }
    }

    public static void saveServerProfile(MServerProfile adapter) {
        if (serverProfiles.containsKey((Object)adapter)) {
            String path = serverProfiles.get((Object)adapter);
            ConfigurationManager.removeStoregeResource((String)PREF_TAG, (String)path);
            ServerManager.saveIntoStrage(adapter, path);
            UIUtils.getDisplay().syncExec(() -> propertyChangeSupport.firePropertyChange(new PropertyChangeEvent((Object)adapter, SERVERPROFILE, null, (Object)adapter)));
        }
    }

    public static void loadServerProfilesCopy(MServers root) {
        if (serverProfiles == null) {
            serverProfiles = new HashMap();
        }
        if (serverProfiles.isEmpty()) {
            ServerManager.loadServerProfiles(root);
        }
        for (MServerProfile msp : serverProfiles.keySet()) {
            MServerProfile newServerProfile = new MServerProfile(root, msp.getValue());
            newServerProfile.setWsClient(msp.getWsClient());
            new MDummy((ANode)newServerProfile);
        }
    }

    public static void loadServerProfiles(MServers root) {
        File[] storageContent;
        root.removeChildren();
        if (serverProfiles == null) {
            serverProfiles = new HashMap();
        }
        serverProfiles.clear();
        ConfigurationManager.convertPropertyToStorage((String)PREF_TAG, (String)PREF_TAG, (IConversionFilenameProvider)new ServerNameProvider());
        File[] fileArray = storageContent = ConfigurationManager.getStorageContent((String)PREF_TAG);
        int n = storageContent.length;
        int n2 = 0;
        while (n2 < n) {
            File storageElement = fileArray[n2];
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (FileInputStream inputStream = new FileInputStream(storageElement);){
                    InputStreamReader reader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
                    InputSource is = new InputSource(reader);
                    is.setEncoding("UTF-8");
                    Document document = JRXmlUtils.parse((InputSource)is);
                    Element serverNode = document.getDocumentElement();
                    if (serverNode.getNodeType() == 1) {
                        try {
                            ServerProfile sprof = (ServerProfile)CastorHelper.read((Node)serverNode, (String)"com/jaspersoft/studio/server/model/server/ServerProfileImpl.xml");
                            MServerProfile sp = new MServerProfile(root, sprof);
                            new MDummy((ANode)sp);
                            serverProfiles.put(sp, storageElement.getName());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                UIUtils.showError((Throwable)e);
            }
            ++n2;
        }
    }

    public static MServerProfile getServerProfile(String key) {
        int ind = key.indexOf(":");
        if (ind > 0) {
            String[] tokens = key.split(":");
            String name = new String(Base64.decodeBase64((String)tokens[0]));
            if (tokens.length > 2) {
                String urls = new String(Base64.decodeBase64((String)tokens[2]));
                String[] urlt = urls.split("\n");
                String url = urlt[0];
                String user = null;
                if (urlt.length > 1) {
                    user = urlt[1];
                }
                String organization = null;
                if (urlt.length > 2) {
                    organization = urlt[2];
                }
                for (MServerProfile sp : serverProfiles.keySet()) {
                    ServerProfile serv = sp.getValue();
                    try {
                        if (!serv.getName().equals(name) || url == null || !serv.getUrl().equals(url)) continue;
                        if (user == null) {
                            return sp;
                        }
                        if (!serv.getUser().equals(user) || !Misc.isNullOrEmpty((String)organization) && (serv.getOrganisation() == null || !serv.getOrganisation().equals(organization))) continue;
                        return sp;
                    }
                    catch (MalformedURLException | URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public static IConnection getServer(String url, IProgressMonitor monitor) throws Exception {
        for (MServerProfile sp : ServerManager.getServerProfiles()) {
            if (!sp.getValue().getUrl().equals(url)) continue;
            return sp.getWsClient(monitor);
        }
        return null;
    }

    public static IConnection getServer(String url, String user, IProgressMonitor monitor) throws Exception {
        MServerProfile msp = ServerManager.getServerByUrl(url, user);
        if (msp != null) {
            return msp.getWsClient(monitor);
        }
        return null;
    }

    public static MServerProfile getServerByUrl(String url) {
        String nurl = ServerProfile.normaliseUrl(url);
        for (MServerProfile sp : ServerManager.getServerProfiles()) {
            try {
                if (!ServerProfile.normaliseUrl(sp.getValue().getUrl()).equals(nurl)) continue;
                return sp;
            }
            catch (MalformedURLException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static MServerProfile getServerByUrl(String url, String user) {
        MServerProfile res = null;
        String nurl = ServerProfile.normaliseUrl(url);
        for (MServerProfile sp : ServerManager.getServerProfiles()) {
            ServerProfile v = sp.getValue();
            try {
                if (!ServerProfile.normaliseUrl(v.getUrl()).equals(nurl)) continue;
                res = sp;
                if (user != null) {
                    if (!AExporter.encodeUsr(v).equals(user)) continue;
                    return sp;
                }
                return sp;
            }
            catch (MalformedURLException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public static int getServerIndexByUrl(String url) {
        int i = 0;
        String nurl = ServerProfile.normaliseUrl(url);
        for (MServerProfile sp : ServerManager.getServerProfiles()) {
            try {
                if (ServerProfile.normaliseUrl(sp.getValue().getUrl()).equals(nurl)) {
                    return i;
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return -1;
    }

    public static int getServerIndexByUrl(String url, String user) {
        int i = 0;
        int j = -1;
        String nurl = ServerProfile.normaliseUrl(url);
        if (user != null && user.endsWith("|")) {
            user = user.substring(0, user.length() - 1);
        }
        for (MServerProfile sp : ServerManager.getServerProfiles()) {
            block6: {
                ServerProfile v = sp.getValue();
                try {
                    if (!ServerProfile.normaliseUrl(v.getUrl()).equals(nurl)) break block6;
                    j = i;
                    if (user != null) {
                        String u = String.valueOf(v.getUser()) + (!Misc.isNullOrEmpty((String)v.getOrganisation()) ? "|" + v.getOrganisation() : "");
                        if (u.equals(user)) {
                            return j;
                        }
                        break block6;
                    }
                    return j;
                }
                catch (MalformedURLException | URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return j;
    }

    public static String getKey(AMResource res) {
        return ServerManager.getKey(res, res.getValue().getUriString(), null);
    }

    public static String getKey(AMResource res, String uri, String option) {
        INode n = res.getRoot();
        if (n instanceof MServerProfile) {
            MServerProfile sp = (MServerProfile)n;
            ServerProfile serv = sp.getValue();
            try {
                String srvurl = serv.getUrl();
                srvurl = String.valueOf(srvurl) + "\n" + serv.getUser();
                srvurl = !Misc.isNullOrEmpty((String)serv.getOrganisation()) ? String.valueOf(srvurl) + "\n" + serv.getOrganisation() : String.valueOf(srvurl) + "\n";
                if (!Misc.isNullOrEmpty((String)option)) {
                    srvurl = String.valueOf(srvurl) + "\n" + option;
                }
                return String.valueOf(Base64.encodeBase64String((byte[])serv.getName().getBytes())) + ":" + uri + ":" + Base64.encodeBase64String((byte[])srvurl.getBytes());
            }
            catch (MalformedURLException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getVersion(ANode node) {
        INode n = node.getRoot();
        if (n instanceof MServerProfile) {
            MServerProfile server = (MServerProfile)n;
            ServerProfile srvrd = server.getValue();
            return srvrd.getJrVersion();
        }
        return "last";
    }

    public static MServerProfile getMServerProfileCopy(MServerProfile original) {
        ServerProfile spFound = null;
        for (ServerProfile sp : ServerManager.getServerList()) {
            if (!sp.equals(original.getValue())) continue;
            spFound = sp;
            break;
        }
        if (spFound == null) {
            return null;
        }
        MServerProfile newServerProfile = new MServerProfile((ANode)new MRoot(null, null), spFound);
        newServerProfile.setWsClient(original.getWsClient());
        return newServerProfile;
    }

    public static MServerProfile getServerProfile(JasperDesign jd, JasperReportsConfiguration jConfig, IProgressMonitor monitor) {
        MRoot root = new MRoot(null, null);
        root.setJasperConfiguration(jConfig);
        MServerProfile sp = null;
        ServerManager.getServerProfiles();
        for (MServerProfile ms : serverProfiles.keySet()) {
            sp = new MServerProfile((ANode)root, ms.getValue());
            sp.setWsClient(ms.getWsClient());
            sp.setJasperConfiguration(jConfig);
            new MDummy((ANode)sp);
        }
        String[] prop = JRSEditorContributor.getServerURL(jd, (IFile)jConfig.get("ifile"), monitor);
        if (prop != null && !Misc.isNullOrEmpty((String)prop[0])) {
            for (INode n : root.getChildren()) {
                if (!(n instanceof MServerProfile)) continue;
                MServerProfile msp = (MServerProfile)n;
                ServerProfile serv = msp.getValue();
                try {
                    if (!serv.getUrl().equals(prop[0])) continue;
                    sp = msp;
                    if (Misc.isNullOrEmpty((String)prop[1])) break;
                    String usr = serv.getUser();
                    if (!Misc.isNullOrEmpty((String)serv.getOrganisation())) {
                        usr = String.valueOf(usr) + "|" + serv.getOrganisation();
                    }
                    if (!usr.equals(prop[1])) continue;
                    break;
                }
                catch (MalformedURLException | URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        return sp;
    }

    public static List<MServerProfile> getServerProfiles(JasperDesign jd, JasperReportsConfiguration jConfig, IProgressMonitor monitor) {
        MRoot root = new MRoot(null, null);
        root.setJasperConfiguration(jConfig);
        ArrayList<MServerProfile> profiles = new ArrayList<MServerProfile>();
        String[] prop = JRSEditorContributor.getServerURL(jd, (IFile)jConfig.get("ifile"), monitor);
        if (prop != null && !Misc.isNullOrEmpty((String)prop[0])) {
            for (ServerProfile serv : ServerManager.getServerList()) {
                try {
                    if (!serv.getUrl().equals(prop[0])) continue;
                    if (Misc.isNullOrEmpty((String)prop[1])) {
                        profiles.add(ServerManager.createServerProfile(root, serv, jConfig));
                        continue;
                    }
                    String usr = serv.getUser();
                    if (!Misc.isNullOrEmpty((String)serv.getOrganisation())) {
                        usr = String.valueOf(usr) + "|" + serv.getOrganisation();
                    }
                    if (!usr.equals(prop[1])) continue;
                    profiles.add(ServerManager.createServerProfile(root, serv, jConfig));
                }
                catch (MalformedURLException | URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        return profiles;
    }

    private static MServerProfile createServerProfile(MRoot root, ServerProfile s, JasperReportsConfiguration jConfig) {
        MServerProfile sp = new MServerProfile((ANode)root, s);
        sp.setJasperConfiguration(jConfig);
        new MDummy((ANode)sp);
        return sp;
    }

    public static void selectIfExists(IProgressMonitor monitor, AMResource mres) {
        MServerProfile sp = (MServerProfile)mres.getRoot();
        try {
            sp = ServerManager.getServerByUrl(sp.getValue().getUrl());
            ServerManager.selectIfExists(monitor, sp, mres);
        }
        catch (MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static void selectIfExists(final IProgressMonitor monitor, MServerProfile sp, AMResource mres) {
        if (mres.getParent() instanceof MServerProfile) {
            try {
                WSClientHelper.connectGetData(sp, monitor);
                propertyChangeSupport.firePropertyChange(new PropertyChangeEvent((Object)sp, SERVERPROFILE, null, (Object)sp));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            final String puri = ((AMResource)mres.getParent()).getValue().getUriString();
            final String uri = mres.getValue().getUriString();
            if (ModelUtils.isEmpty((ANode)sp)) {
                try {
                    WSClientHelper.connectGetData(sp, monitor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            new ModelVisitor<AMResource>((INode)sp){

                public boolean visit(INode n) {
                    AMResource r;
                    if (n instanceof AMResource && (r = (AMResource)n).getValue().getUriString().equals(puri)) {
                        for (INode cn : r.getChildren()) {
                            if (!(cn instanceof AMResource) || !((AMResource)cn).getValue().getUriString().equals(uri)) continue;
                            this.doRefresh((AMResource)cn, monitor);
                        }
                        this.doRefresh(r, monitor);
                    }
                    if (monitor.isCanceled()) {
                        this.stop();
                    }
                    return true;
                }

                private void doRefresh(AMResource r, IProgressMonitor monitor2) {
                    try {
                        WSClientHelper.refreshResource(r, monitor2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.stop();
                }
            };
        }
    }
}

