/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.action.resource;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.server.action.resource.OpenInEditorAction;
import com.jaspersoft.studio.server.export.AExporter;
import com.jaspersoft.studio.server.export.JrxmlExporter;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class DownloadFileAction
extends OpenInEditorAction {
    private static final String ID = "DOWNLOADJSRESOURCE";

    public DownloadFileAction(TreeViewer treeViewer) {
        super(treeViewer, true);
        this.setId(ID);
        this.setText(Messages.DownloadFileAction_1);
        this.setDescription(Messages.DownloadFileAction_2);
        this.setToolTipText(Messages.DownloadFileAction_3);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/drive-download.png"));
        this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/drive-download.png"));
    }

    @Override
    protected boolean preDownload(AFileResource fres, IProgressMonitor monitor) {
        SaveAsDialog saveAsDialog = new SaveAsDialog(Display.getDefault().getActiveShell());
        String defaultFileExtension = fres.getDefaultFileExtension();
        saveAsDialog.setOriginalName(AExporter.getNewFileName(fres.getValue(), StringUtils.isNotEmpty((String)defaultFileExtension) ? "." + defaultFileExtension : null));
        if (saveAsDialog.open() == 0) {
            this.path = saveAsDialog.getResult();
            return true;
        }
        return false;
    }

    @Override
    protected void doExportJrxml(AFileResource res, ResourceDescriptor rd, String fkeyname, IProgressMonitor monitor) throws Exception {
        IFile f = new JrxmlExporter(this.path).exportToIFile(res, rd, fkeyname, monitor);
        if (f != null) {
            JasperReportsConfiguration jrconf = JasperReportsConfiguration.getDefaultJRConfig((IFile)f);
            try {
                jrconf.getPrefStore().setValue("PUBLISH2JSS.SILENT", true);
                this.openEditor(f, res);
            }
            finally {
                jrconf.dispose();
            }
        }
    }
}

