/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.action.resource;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.bean.BeanDataAdapterDescriptor;
import com.jaspersoft.studio.data.jdbc.JDBCDataAdapterDescriptor;
import com.jaspersoft.studio.data.jndi.JndiDataAdapterDescriptor;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.datasource.MRDatasourceBean;
import com.jaspersoft.studio.server.model.datasource.MRDatasourceJDBC;
import com.jaspersoft.studio.server.model.datasource.MRDatasourceJNDI;
import java.text.MessageFormat;
import java.util.UUID;
import net.sf.jasperreports.data.bean.BeanDataAdapter;
import net.sf.jasperreports.data.jdbc.JdbcDataAdapter;
import net.sf.jasperreports.data.jndi.JndiDataAdapter;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.SecureStorageUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;

public class ImportDataSourceInJSSAction
extends Action {
    public static final String ID = "IMPORT_DATASOURCE_IN_JSS";
    private TreeViewer treeViewer;

    public ImportDataSourceInJSSAction(TreeViewer treeViewer) {
        this.setId(ID);
        this.setText(Messages.ImportDataSourceInJSSAction_ActionText);
        this.setToolTipText(Messages.ImportDataSourceInJSSAction_ActionTooltip);
        this.setImageDescriptor(ResourceManager.getPluginImageDescriptor((String)"com.jaspersoft.studio", (String)"/icons/resources/eclipse/etool16/import_wiz.gif"));
        this.treeViewer = treeViewer;
    }

    public boolean isEnabled() {
        Object firstElement = ((TreeSelection)this.treeViewer.getSelection()).getFirstElement();
        return firstElement != null && this.isValidDataSource(firstElement);
    }

    public void run() {
        final Object firstElement = ((TreeSelection)this.treeViewer.getSelection()).getFirstElement();
        Job job = new Job("Building report"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("", -1);
                try {
                    if (firstElement instanceof AMResource) {
                        AMResource mres = (AMResource)((Object)firstElement);
                        mres.setValue(mres.getWsClient().get(monitor, mres.getValue(), null));
                        final DataAdapterDescriptor dad = ImportDataSourceInJSSAction.this.importDataSourceAsDataAdapter(mres);
                        UIUtils.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                DataAdapterManager.getPreferencesStorage().addDataAdapter(dad);
                                MessageDialog.openInformation((Shell)UIUtils.getShell(), (String)Messages.ImportDataSourceInJSSAction_OperationInfoTitle, (String)Messages.ImportDataSourceInJSSAction_OperationInfoMsg);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    UIUtils.showError((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    private boolean isValidDataSource(Object element) {
        return element instanceof MRDatasourceJDBC || element instanceof MRDatasourceJNDI || element instanceof MRDatasourceBean;
    }

    private DataAdapterDescriptor importDataSourceAsDataAdapter(AMResource datasource) {
        if (datasource instanceof MRDatasourceJDBC) {
            MRDatasourceJDBC jdbcDS = (MRDatasourceJDBC)datasource;
            JDBCDataAdapterDescriptor jdbcDA = new JDBCDataAdapterDescriptor();
            JdbcDataAdapter jdbcDataAdapter = (JdbcDataAdapter)jdbcDA.getDataAdapter();
            jdbcDataAdapter.setName(this.getValidName(jdbcDS.getValue().getLabel(), "JDBC"));
            jdbcDataAdapter.setDriver(jdbcDS.getValue().getDriverClass());
            jdbcDataAdapter.setUsername(jdbcDS.getValue().getUsername());
            jdbcDataAdapter.setPassword(this.getPasswordValue(jdbcDS.getValue().getPassword()));
            jdbcDataAdapter.setUrl(jdbcDS.getValue().getConnectionUrl());
            jdbcDataAdapter.setSavePassword(true);
            return jdbcDA;
        }
        if (datasource instanceof MRDatasourceJNDI) {
            MRDatasourceJNDI jndiDS = (MRDatasourceJNDI)datasource;
            JndiDataAdapterDescriptor jndiDA = new JndiDataAdapterDescriptor();
            JndiDataAdapter jndiDataAdapter = jndiDA.getDataAdapter();
            jndiDataAdapter.setName(this.getValidName(jndiDS.getValue().getLabel(), "JNDI"));
            jndiDataAdapter.setDataSourceName(jndiDS.getValue().getJndiName());
            return jndiDA;
        }
        if (datasource instanceof MRDatasourceBean) {
            MRDatasourceBean beanDS = (MRDatasourceBean)datasource;
            BeanDataAdapterDescriptor beanDA = new BeanDataAdapterDescriptor();
            BeanDataAdapter beanDataAdapter = beanDA.getDataAdapter();
            beanDataAdapter.setName(this.getValidName(beanDS.getValue().getLabel(), "Bean"));
            beanDataAdapter.setFactoryClass(beanDS.getValue().getBeanName());
            beanDataAdapter.setMethodName(beanDS.getValue().getBeanMethod());
            return beanDA;
        }
        throw new RuntimeException(Messages.ImportDataSourceInJSSAction_DataSourceNotSupportedError);
    }

    private String getValidName(String proposedName, String prefix) {
        ADataAdapterStorage prefStorage = DataAdapterManager.getPreferencesStorage();
        if (prefStorage.isDataAdapterNameValid(proposedName)) {
            return proposedName;
        }
        MessageFormat msgF = new MessageFormat(Messages.ImportDataSourceInJSSAction_DataAdapterNameTemplate);
        int i = 1;
        while (i < 1000) {
            String name = msgF.format(new Object[]{prefix, i > 1 ? "(" + i + ")" : ""});
            if (prefStorage.isDataAdapterNameValid(name)) {
                return name;
            }
            ++i;
        }
        throw new RuntimeException(Messages.ImportDataSourceInJSSAction_UnableToGetNameError);
    }

    private String getPasswordValue(String passwordFieldTxt) {
        return JaspersoftStudioPlugin.shouldUseSecureStorage() ? this.getSecretStorageKey(passwordFieldTxt) : passwordFieldTxt;
    }

    private String getSecretStorageKey(String pass) {
        try {
            UUID uuidKey = UUID.randomUUID();
            SecureStorageUtils.saveToDefaultSecurePreferences((String)"net.sf.jasperreports.data.adapter", (String)uuidKey.toString(), (String)pass);
            return uuidKey.toString();
        }
        catch (StorageException e) {
            Activator.getDefault().logError(Messages.Common_ErrSecurePrefStorage, e);
            return pass;
        }
    }
}

