/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.action.resource;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MReference;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.utils.ReferenceResolver;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.viewer.BrowserUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class OpenInBrowserAction
extends Action {
    private static final String ID = "OPENINBROWSER";
    private TreeViewer treeViewer;

    public OpenInBrowserAction(TreeViewer treeViewer) {
        this.setId(ID);
        this.setText(Messages.OpenInBrowserAction_1);
        this.setToolTipText(Messages.OpenInBrowserAction_2);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/jrs.png"));
        this.treeViewer = treeViewer;
    }

    public boolean isEnabled() {
        TreeSelection treeSelection = (TreeSelection)this.treeViewer.getSelection();
        Object firstElement = treeSelection.getFirstElement();
        return treeSelection.size() == 1 && this.isResourceOpenable(firstElement);
    }

    private boolean isResourceOpenable(Object selectedEl) {
        if (selectedEl instanceof MReportUnit) {
            return true;
        }
        if (selectedEl instanceof MServerProfile) {
            return true;
        }
        return selectedEl instanceof AMResource && !(selectedEl instanceof AFileResource);
    }

    public void run() {
        block6: {
            try {
                TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
                Object obj = s.getFirstElement();
                if (obj instanceof MServerProfile) {
                    MServerProfile msp = (MServerProfile)((Object)obj);
                    BrowserUtils.openExternalBrowser((String)msp.getValue().getUrl());
                    break block6;
                }
                if (!(obj instanceof AMResource)) break block6;
                final AMResource mr = (AMResource)((Object)obj);
                MServerProfile msp = (MServerProfile)mr.getRoot();
                final String uri = msp.getValue().getUrl();
                try {
                    if (mr instanceof MReference) {
                        Job job = new Job(Messages.FindReportUnit_jobname){

                            protected IStatus run(IProgressMonitor monitor) {
                                monitor.beginTask("Resolving reference", -1);
                                try {
                                    ResourceDescriptor rd = ReferenceResolver.resolveReference((MReference)mr, monitor);
                                    AMResource mres = ResourceFactory.getResource(null, rd, -1);
                                    if (mres != null) {
                                        OpenInBrowserAction.this.openInBrowser(mres, uri);
                                    }
                                    return Status.OK_STATUS;
                                }
                                catch (Exception e) {
                                    UIUtils.showError((Throwable)e);
                                    return Status.CANCEL_STATUS;
                                }
                            }
                        };
                        job.setPriority(30);
                        job.schedule();
                        break block6;
                    }
                    this.openInBrowser(mr, uri);
                }
                catch (UnsupportedEncodingException e) {
                    UIUtils.showError((Throwable)e);
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                UIUtils.showError((Throwable)e);
            }
        }
    }

    private void openInBrowser(AMResource mr, String uri) throws UnsupportedEncodingException {
        String jrsUrl = mr.getJRSUrl();
        if (jrsUrl == null) {
            UIUtils.showInformation((String)"This resource url can't be opened directly from here.");
            return;
        }
        uri = String.valueOf(uri) + jrsUrl;
        BrowserUtils.openExternalBrowser((String)uri);
    }
}

