/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.action.resource;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.action.resource.PasteResourceAction;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.protocol.IConnection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TreeViewer;

public class PasteResourceAsLinkAction
extends PasteResourceAction {
    public static final String PASTE_ASLINK = "PASTEASLINK";

    public PasteResourceAsLinkAction(TreeViewer treeViewer) {
        super(treeViewer);
        this.setId(PASTE_ASLINK);
        this.setText(Messages.PasteResourceAsLinkAction_1);
        this.setToolTipText(Messages.PasteResourceAsLinkAction_2);
    }

    @Override
    public boolean isEnabled() {
        boolean res = false;
        ANode n = this.getSelected();
        if (n instanceof MReportUnit && (res = super.isEnabled()) && this.contents != null && this.contents instanceof List) {
            List list = (List)this.contents;
            for (Object obj : list) {
                if (!(obj instanceof AMResource) || !(obj instanceof ICopyable)) continue;
                ICopyable c = (ICopyable)obj;
                if (c.isCopyable2((Object)n) == ICopyable.RESULT.COPYABLE) {
                    if (((AMResource)((Object)obj)).isCut()) {
                        res = false;
                        break;
                    }
                    res = true;
                    break;
                }
                return false;
            }
        }
        return res;
    }

    @Override
    protected void saveToReportUnit(IProgressMonitor monitor, AMResource parent, IConnection ws, ResourceDescriptor origin, boolean doSave) throws Exception {
        ResourceDescriptor prd = parent.getValue();
        ResourceDescriptor rd = null;
        rd = new ResourceDescriptor();
        rd.setName(origin.getName());
        rd.setLabel(origin.getLabel());
        rd.setDescription(origin.getDescription());
        rd.setIsNew(true);
        rd.setIsReference(true);
        if (parent.getWsClient().isSupported(Feature.SEARCHREPOSITORY)) {
            rd.setParentFolder(String.valueOf(prd.getParentFolder()) + "/" + prd.getName() + "_files");
            rd.setUriString(origin.getUriString());
            rd.setWsType(origin.getWsType());
        } else {
            rd.setReferenceUri(origin.getUriString());
            rd.setParentFolder(String.valueOf(prd.getParentFolder()) + "/" + prd.getName() + "_files");
            if (ResourceFactory.isFileResourceType(origin)) {
                rd.setWsType("reference");
            } else {
                rd.setWsType(origin.getWsType());
            }
            rd.setUriString(String.valueOf(prd.getParentFolder()) + "/" + prd.getName() + "_files/" + prd.getName());
        }
        prd.getChildren().add(rd);
        if (doSave) {
            ws.addOrModifyResource(monitor, prd, null);
        }
    }
}

