/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.action.resource;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.action.server.EditServerAction;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionFactory;

public class RefreshResourcesAction
extends Action {
    private TreeViewer treeViewer;

    public RefreshResourcesAction(TreeViewer treeViewer) {
        this.setId(ActionFactory.REFRESH.getId());
        this.setText(Messages.RefreshResourcesAction_0);
        this.setToolTipText(Messages.common_delete);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/eclipseicons/reload.gif"));
        this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/eclipseicons/reload.gif"));
        this.treeViewer = treeViewer;
    }

    public void run() {
        final TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
        TreePath[] p = s.getPaths();
        int i = 0;
        while (i < p.length) {
            final Object obj = p[i].getLastSegment();
            if (obj instanceof AMResource) {
                ProgressMonitorDialog pm = new ProgressMonitorDialog(UIUtils.getShell());
                try {
                    pm.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                try {
                                    AMResource res = (AMResource)((Object)obj);
                                    WSClientHelper.refreshResource(res, monitor);
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            (this).RefreshResourcesAction.this.treeViewer.refresh(true);
                                            (this).RefreshResourcesAction.this.treeViewer.setSelection((ISelection)s);
                                        }
                                    });
                                }
                                catch (Throwable e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    UIUtils.showError((Throwable)e.getCause());
                }
                catch (InterruptedException e) {
                    UIUtils.showError((Throwable)e);
                }
            } else if (obj instanceof MServerProfile) {
                EditServerAction.fillServerProfile((MServerProfile)((Object)obj), this.treeViewer);
            }
            ++i;
        }
    }
}

