/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.action.server;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.actions.DuplicateDataAdapterAction;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.action.server.EditServerAction;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import java.util.ArrayList;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class DuplicateServerAction
extends Action {
    public static final String ID = "duplicateServerAction";
    private TreeViewer treeViewer;
    private EditServerAction editAction;

    public DuplicateServerAction(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.setId(ID);
        this.setText(Messages.DuplicateServerAction_title);
        this.setDescription(Messages.DuplicateServerAction_desc);
        this.setToolTipText(Messages.DuplicateServerAction_desc);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("IMG_TOOL_COPY"));
    }

    public boolean isEnabled() {
        Object firstElement = ((TreeSelection)this.treeViewer.getSelection()).getFirstElement();
        return firstElement != null && firstElement instanceof MServerProfile;
    }

    public void run() {
        TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
        TreePath[] p = s.getPaths();
        ArrayList<MServerProfile> copies = new ArrayList<MServerProfile>();
        int i = 0;
        while (i < p.length) {
            Object obj = p[i].getLastSegment();
            if (obj instanceof MServerProfile) {
                try {
                    MServerProfile oldMSP = (MServerProfile)((Object)obj);
                    ServerProfile copy = (ServerProfile)oldMSP.getValue().clone();
                    copy.setName(String.valueOf(DuplicateDataAdapterAction.COPY_OF) + copy.getName());
                    copy.setProjectPath(null);
                    MServerProfile copyDataAdapter = new MServerProfile(oldMSP.getParent(), copy);
                    ServerManager.addServerProfile(copyDataAdapter);
                    copies.add(copyDataAdapter);
                    JaspersoftStudioPlugin.getInstance().getUsageManager().audit("CreatedJasperServerConnection", "JasperServer");
                }
                catch (CloneNotSupportedException e) {
                    UIUtils.showError((Throwable)e);
                }
            }
            ++i;
        }
        if (!copies.isEmpty()) {
            this.treeViewer.refresh(true);
            if (copies.size() == 1) {
                MServerProfile copy = (MServerProfile)((Object)copies.get(0));
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)copy));
                this.treeViewer.reveal((Object)copy);
                this.runEditAction();
            }
        }
    }

    private void runEditAction() {
        if (this.editAction == null) {
            this.editAction = new EditServerAction(this.treeViewer);
        }
        this.editAction.run();
    }
}

