/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.action.server;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MDummy;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.wizard.ServerProfileWizard;
import com.jaspersoft.studio.server.wizard.ServerProfileWizardDialog;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;

public class EditServerAction
extends Action {
    public static final String ID = "editServerAction";
    private TreeViewer treeViewer;

    public EditServerAction(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.setId(ID);
        this.setText(Messages.EditServerAction_title);
        this.setDescription(Messages.EditServerAction_desc);
        this.setToolTipText(Messages.EditServerAction_desc);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/server--pencil.png"));
    }

    public boolean isEnabled() {
        Object firstElement = ((TreeSelection)this.treeViewer.getSelection()).getFirstElement();
        return firstElement != null && firstElement instanceof MServerProfile;
    }

    public void run() {
        Object obj = ((TreeSelection)this.treeViewer.getSelection()).getFirstElement();
        if (obj instanceof MServerProfile) {
            MServerProfile mspold = (MServerProfile)((Object)obj);
            MServerProfile mspCopy = ServerManager.getMServerProfileCopy(mspold);
            try {
                mspCopy.setValue(mspCopy.getValue().clone());
            }
            catch (CloneNotSupportedException e) {
                UIUtils.showError((Throwable)e);
            }
            ServerProfileWizard wizard = new ServerProfileWizard(mspCopy);
            ServerProfileWizardDialog dialog = new ServerProfileWizardDialog(UIUtils.getShell(), (IWizard)wizard);
            wizard.bindTestButton(dialog);
            dialog.create();
            if (dialog.open() == 0) {
                MServerProfile msprof = wizard.getServerProfile();
                mspold.setValue(msprof.getValue());
                mspold.setWsClient(null);
                ServerManager.saveServerProfile(mspold);
                mspold.setWsClient(msprof.getWsClient());
                EditServerAction.fillServerProfile(mspold, this.treeViewer);
            }
        }
    }

    public static void fillServerProfile(final MServerProfile mspold, final TreeViewer treeViewer) {
        Job job = new Job(Messages.EditServerAction_jobname){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.EditServerAction_taskname, -1);
                    mspold.removeChildren();
                    new MDummy((ANode)mspold);
                    this.showSelection();
                    WSClientHelper.connectGetData(mspold, monitor, false);
                    this.showSelection();
                }
                catch (InvocationTargetException e) {
                    UIUtils.showError((Throwable)e);
                    mspold.setWsClient(null);
                    return Status.CANCEL_STATUS;
                }
                catch (Exception e) {
                    UIUtils.showError((Throwable)e);
                    mspold.setWsClient(null);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            private void showSelection() {
                UIUtils.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        treeViewer.refresh(true);
                        TreeSelection s = (TreeSelection)treeViewer.getSelection();
                        if (!s.isEmpty()) {
                            TreePath[] p = s.getPaths();
                            treeViewer.expandToLevel((Object)p[0], 1);
                        }
                    }
                });
            }
        };
        job.setSystem(false);
        job.schedule();
    }
}

