/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.dnd;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.dnd.NodeTransfer;
import com.jaspersoft.studio.dnd.NodeTreeDropAdapter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.dnd.InputControlDragSourceListener;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.IInputControlsContainer;
import com.jaspersoft.studio.server.model.MInputControl;
import com.jaspersoft.studio.server.model.MReportUnit;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.TreeItem;

public class InputControlDropTargetListener
extends NodeTreeDropAdapter
implements TransferDropTargetListener {
    public InputControlDropTargetListener(TreeViewer treeViewer) {
        super(treeViewer);
    }

    public boolean validateDrop(Object target, int op, TransferData type) {
        return super.validateDrop(target, op, type);
    }

    public boolean performDrop(Object data) {
        if (data == null) {
            return false;
        }
        final ArrayList<MInputControl> mc = new ArrayList<MInputControl>();
        if (data.getClass().isArray()) {
            Object[] ar;
            Object[] objectArray = ar = (Object[])data;
            int n = ar.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof MInputControl) {
                    mc.add((MInputControl)((Object)obj));
                }
                ++n2;
            }
        } else if (data instanceof MInputControl) {
            mc.add((MInputControl)((Object)data));
        }
        Job job = new Job(Messages.common_reorder_elements){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                monitor.beginTask(Messages.common_reorder_elements, -1);
                try {
                    Object target = InputControlDropTargetListener.this.getCurrentTarget();
                    if (target instanceof ANode && ((ANode)target).getParent() instanceof MReportUnit) {
                        status = InputControlDropTargetListener.this.doRun((ANode)target, mc, monitor);
                    } else if (target instanceof ANode && InputControlDragSourceListener.isDragable(((ANode)target).getParent())) {
                        status = InputControlDropTargetListener.this.doRun((ANode)target, mc, monitor);
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        job.setPriority(30);
        job.setUser(true);
        job.schedule();
        return true;
    }

    protected IStatus doRun(ANode target, List<MInputControl> toMove, IProgressMonitor monitor) {
        int i;
        AMResource container = null;
        if (target instanceof IInputControlsContainer) {
            container = (AMResource)target;
        } else if (target.getParent() instanceof IInputControlsContainer) {
            container = (AMResource)target.getParent();
        }
        int indx = container.getChildren().indexOf(target);
        if (this.getCurrentLocation() == 2) {
            ++indx;
        }
        ArrayList<MInputControl> tm = new ArrayList<MInputControl>();
        block2: for (INode n : container.getChildren()) {
            if (!(n instanceof MInputControl)) continue;
            String uri = ((MInputControl)n).getValue().getUriString();
            for (MInputControl mc : toMove) {
                if (!mc.getValue().getUriString().equals(uri)) continue;
                tm.add((MInputControl)n);
                continue block2;
            }
        }
        if (!tm.isEmpty()) {
            container.removeChildren(tm);
            i = 0;
            while (i < tm.size()) {
                container.addChild((ANode)tm.get(i), i + indx);
                ++i;
            }
        } else {
            i = 0;
            while (i < toMove.size()) {
                container.addChild((ANode)toMove.get(i), i + indx);
                ++i;
            }
        }
        String uriString = container.getValue().getUriString();
        try {
            container.getWsClient().reorderInputControls(uriString, this.doBuildICResourceDescriptorList(container), monitor);
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
        }
        ServerManager.selectIfExists(monitor, container);
        return Status.OK_STATUS;
    }

    protected List<ResourceDescriptor> doBuildICResourceDescriptorList(AMResource mrunit) {
        ArrayList<ResourceDescriptor> ics = new ArrayList<ResourceDescriptor>();
        for (INode n : mrunit.getChildren()) {
            if (!(n instanceof MInputControl)) continue;
            ics.add(((MInputControl)n).getValue());
        }
        return ics;
    }

    public boolean isEnabled(DropTargetEvent event) {
        TreeItem item;
        Object d;
        return event.item instanceof TreeItem && (d = (item = (TreeItem)event.item).getData()) instanceof MInputControl && InputControlDragSourceListener.isDragable(((MInputControl)((Object)d)).getParent());
    }

    public Transfer getTransfer() {
        return NodeTransfer.getInstance();
    }
}

