/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.dnd;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MJar;
import com.jaspersoft.studio.server.model.MJrxml;
import com.jaspersoft.studio.server.model.MRDataAdapter;
import com.jaspersoft.studio.server.model.MRFont;
import com.jaspersoft.studio.server.model.MRImage;
import com.jaspersoft.studio.server.model.MRStyleTemplate;
import com.jaspersoft.studio.server.model.MResourceBundle;
import com.jaspersoft.studio.server.model.MXmlFile;
import com.jaspersoft.studio.server.utils.ResourceDescriptorUtil;
import com.jaspersoft.studio.utils.ImageUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;

public final class RepositoryDNDHelper {
    private static final String JRML_EXTENSION = "jrxml";
    private static final String XML_EXTENSION = "xml";
    private static final String DATA_ADAPTER_EXTENSION = "xml";
    private static final String RESOURCE_BUNDLE_EXTENSION = "properties";
    private static final String JAR_EXTENSION = "jar";
    private static final String FONT_EXTENSION = "ttf";
    private static final String TEMPLATE_EXTENSION = "jrtx";
    private static final List<String> ALLOWED_EXTENSIONS = new ArrayList<String>();

    static {
        ALLOWED_EXTENSIONS.add(JRML_EXTENSION);
        ALLOWED_EXTENSIONS.add("xml");
        ALLOWED_EXTENSIONS.add("xml");
        ALLOWED_EXTENSIONS.add(RESOURCE_BUNDLE_EXTENSION);
        ALLOWED_EXTENSIONS.add(JAR_EXTENSION);
        ALLOWED_EXTENSIONS.add(FONT_EXTENSION);
        ALLOWED_EXTENSIONS.add(TEMPLATE_EXTENSION);
        ALLOWED_EXTENSIONS.addAll(ImageUtils.getAllowedImageFileExtensions());
    }

    private RepositoryDNDHelper() {
    }

    public static boolean isDropOperationAllowed(String extension) {
        Assert.isNotNull((Object)extension);
        return ALLOWED_EXTENSIONS.contains(extension.toLowerCase());
    }

    public static void performDropOperation(final AMResource targetParentResource, final String fullFilename) {
        final File file = new File(fullFilename);
        final String suggestedId = FilenameUtils.removeExtension((String)file.getName());
        final String suggestedName = FilenameUtils.removeExtension((String)file.getName());
        final String fileExt = Misc.nvl((String)FilenameUtils.getExtension((String)fullFilename)).toLowerCase();
        try {
            ProgressMonitorDialog pm = new ProgressMonitorDialog(UIUtils.getShell());
            pm.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(NLS.bind((String)Messages.RepositoryDNDHelper_SavingResourceTask, (Object)fullFilename), -1);
                            List<ResourceDescriptor> childrenDescriptors = WSClientHelper.listFolder((ANode)targetParentResource, WSClientHelper.getClient(monitor, targetParentResource), targetParentResource.getValue().getUriString(), (IProgressMonitor)new NullProgressMonitor(), 0);
                            ResourceDescriptor newRD = RepositoryDNDHelper.getResourceDescriptor(targetParentResource, fileExt);
                            ResourceDescriptorUtil.setProposedResourceDescriptorIDAndName(childrenDescriptors, newRD, suggestedId, suggestedName);
                            AFileResource fileResource = RepositoryDNDHelper.createNewFileResource(targetParentResource, newRD, fileExt);
                            fileResource.setFile(file);
                            monitor.setTaskName(NLS.bind((String)Messages.RepositoryDNDHelper_SavingResourceTask, (Object)fullFilename));
                            WSClientHelper.saveResource(fileResource, monitor);
                        }
                        catch (Throwable e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
        }
    }

    private static AFileResource createNewFileResource(AMResource targetParentResource, ResourceDescriptor rd, String fileExt) {
        if (ImageUtils.hasValidFileImageExtension((String)fileExt)) {
            return new MRImage((ANode)targetParentResource, rd, -1);
        }
        if (JRML_EXTENSION.equals(fileExt)) {
            return new MJrxml((ANode)targetParentResource, rd, -1);
        }
        if ("xml".equals(fileExt)) {
            return new MXmlFile((ANode)targetParentResource, rd, -1);
        }
        if ("xml".equals(fileExt)) {
            return new MRDataAdapter((ANode)targetParentResource, rd, -1);
        }
        if (RESOURCE_BUNDLE_EXTENSION.equals(fileExt)) {
            return new MResourceBundle((ANode)targetParentResource, rd, -1);
        }
        if (JAR_EXTENSION.equals(fileExt)) {
            return new MJar((ANode)targetParentResource, rd, -1);
        }
        if (FONT_EXTENSION.equals(fileExt)) {
            return new MRFont((ANode)targetParentResource, rd, -1);
        }
        if (TEMPLATE_EXTENSION.equals(fileExt)) {
            return new MRStyleTemplate((ANode)targetParentResource, rd, -1);
        }
        throw new UnsupportedOperationException(MessageFormat.format(Messages.RepositoryDNDHelper_NewFileResourceErrMsg, fileExt));
    }

    private static ResourceDescriptor getResourceDescriptor(AMResource targetParentResource, String fileExt) {
        if (ImageUtils.hasValidFileImageExtension((String)fileExt)) {
            return MRImage.createDescriptor((ANode)targetParentResource);
        }
        if (JRML_EXTENSION.equals(fileExt)) {
            return MJrxml.createDescriptor((ANode)targetParentResource);
        }
        if ("xml".equals(fileExt)) {
            return MXmlFile.createDescriptor((ANode)targetParentResource);
        }
        if ("xml".equals(fileExt)) {
            return MRDataAdapter.createDescriptor((ANode)targetParentResource);
        }
        if (RESOURCE_BUNDLE_EXTENSION.equals(fileExt)) {
            return MResourceBundle.createDescriptor((ANode)targetParentResource);
        }
        if (JAR_EXTENSION.equals(fileExt)) {
            return MJar.createDescriptor((ANode)targetParentResource);
        }
        if (FONT_EXTENSION.equals(fileExt)) {
            return MRFont.createDescriptor((ANode)targetParentResource);
        }
        if (TEMPLATE_EXTENSION.equals(fileExt)) {
            return MRStyleTemplate.createDescriptor((ANode)targetParentResource);
        }
        throw new UnsupportedOperationException(MessageFormat.format(Messages.RepositoryDNDHelper_NewResourceDescriptorErrMsg, fileExt));
    }
}

