/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.editor;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.storage.FileDataAdapterStorage;
import com.jaspersoft.studio.data.storage.PreferencesDataAdapterStorage;
import com.jaspersoft.studio.editor.context.AEditorContext;
import com.jaspersoft.studio.editor.context.JSSClasspathListener;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.editor.JrsClassLoader;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import net.sf.jasperreports.eclipse.classpath.JavaProjectClassLoader;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.CompositeClassloader;
import net.sf.jasperreports.repo.RepositoryService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class JRSEditorContext
extends AEditorContext {
    public static final String JRS_ID = "jrs";
    public static final String JRS_NAME = Messages.JRSEditorContext_1;
    private JrsClassLoader cLoader;

    public String getName() {
        return JRS_NAME;
    }

    public List<String> getRepositoryRoots() {
        Path fpath = Paths.get(this.f.getLocation().toFile().getAbsolutePath(), new String[0]);
        Path ppath = Paths.get(this.f.getProject().getLocation().toFile().getAbsolutePath(), new String[0]);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (ServerProfile sp : ServerManager.getServerList()) {
            Path jrsp;
            IResource r;
            if (sp.getProjectPath() == null || (r = root.findMember(sp.getProjectPath())) == null || !(jrsp = Paths.get(r.getLocation().toFile().getAbsolutePath(), new String[0])).startsWith(ppath) || !fpath.startsWith(jrsp)) continue;
            ArrayList<String> res = new ArrayList<String>();
            res.add(jrsp.toAbsolutePath().toString());
            return res;
        }
        return super.getRepositoryRoots();
    }

    protected void configRepositoryPaths(List<RepositoryService> list) {
        HashSet rset = new HashSet();
        if (this.f.isLinked()) {
            this.add(list, rset, this.f.getRawLocation().toFile().getParentFile().getAbsolutePath());
        }
        if (!this.f.getParent().isVirtual()) {
            this.add(list, rset, this.f.getParent().getLocation().toFile().getAbsolutePath());
        }
        Path fpath = Paths.get(this.f.getLocation().toFile().getAbsolutePath(), new String[0]);
        Path ppath = Paths.get(this.f.getProject().getLocation().toFile().getAbsolutePath(), new String[0]);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (ServerProfile sp : ServerManager.getServerList()) {
            Path jrsp;
            IResource r;
            if (sp.getProjectPath() == null || (r = root.findMember(sp.getProjectPath())) == null || !(jrsp = Paths.get(r.getLocation().toFile().getAbsolutePath(), new String[0])).startsWith(ppath) || !fpath.startsWith(jrsp)) continue;
            this.add(list, rset, r.getLocation().toOSString());
            break;
        }
        this.add(list, rset, this.f.getProject().getLocation().toFile().getAbsolutePath());
    }

    public void initClassloader() {
        if (this.javaclassloader != null && this.classpathlistener != null) {
            this.javaclassloader.removeClasspathListener((PropertyChangeListener)this.classpathlistener);
            this.jConf.remove("javaProjectClassLoader");
        }
        if (this.cLoader != null) {
            this.cLoader.dispose();
            this.cLoader = null;
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (this.f != null) {
                cl = this.createJrsClassLoader(cl);
                IProject project = this.f.getProject();
                if (project != null && project.getNature("org.eclipse.jdt.core.javanature") != null) {
                    this.javaclassloader = JavaProjectClassLoader.instance((IJavaProject)JavaCore.create((IProject)project), (ClassLoader)cl);
                    this.jConf.put("javaProjectClassLoader", (Object)this.javaclassloader);
                    this.classpathlistener = new JSSClasspathListener((AEditorContext)this, this.jConf);
                    this.javaclassloader.addClasspathListener((PropertyChangeListener)this.classpathlistener);
                    cl = this.javaclassloader;
                }
            }
            cl = JaspersoftStudioPlugin.getDriversManager().getClassLoader(cl);
            cl = new CompositeClassloader(cl, ((Object)((Object)this)).getClass().getClassLoader()){

                protected URL findResource(String name) {
                    if (name.endsWith("GroovyEvaluator.groovy")) {
                        return null;
                    }
                    return super.findResource(name);
                }

                protected Class<?> findClass(String className) throws ClassNotFoundException {
                    if (className.endsWith("GroovyEvaluator")) {
                        throw new ClassNotFoundException(className);
                    }
                    return super.findClass(className);
                }
            };
            this.setClassLoader(cl);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private ClassLoader createJrsClassLoader(ClassLoader cl) {
        this.cLoader = new JrsClassLoader(cl, this.f.getParent());
        return this.cLoader;
    }

    public void dispose() {
        super.dispose();
        this.cLoader.dispose();
    }

    public boolean needCompilation() {
        return false;
    }

    public boolean saveOnPreview() {
        return true;
    }

    public boolean hasBookmarks() {
        return false;
    }

    public boolean hasExporterSettings() {
        return false;
    }

    public boolean hasSortFields() {
        return false;
    }

    public String jrVersion() {
        return "any";
    }

    public Properties getJrProperties() {
        Properties props = new Properties();
        List lst = JRPropertiesUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).getProperties("");
        for (JRPropertiesUtil.PropertySuffix ps : lst) {
            props.setProperty(ps.getKey(), ps.getValue());
        }
        return props;
    }

    public boolean isDataAdapterStorage(ADataAdapterStorage storage) {
        return storage instanceof PreferencesDataAdapterStorage || storage instanceof FileDataAdapterStorage && ((FileDataAdapterStorage)storage).getProject().equals((Object)this.f.getProject());
    }
}

