/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.editor;

import com.jaspersoft.studio.editor.AbstractJRXMLEditor;
import com.jaspersoft.studio.editor.IEditorContributor;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import com.jaspersoft.studio.server.editor.JRSRepositoryService;
import com.jaspersoft.studio.server.publish.PublishUtil;
import com.jaspersoft.studio.server.publish.action.JrxmlPublishAction;
import com.jaspersoft.studio.server.publish.wizard.SaveConfirmationDialog;
import com.jaspersoft.studio.utils.AContributorAction;
import com.jaspersoft.studio.utils.jasper.JSSFileRepositoryService;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.MScopedPreferenceStore;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.repo.FileRepositoryService;
import net.sf.jasperreports.repo.RepositoryService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.part.EditorPart;

public class JRSEditorContributor
implements IEditorContributor {
    private static final String IS_FROM_SAVE_AS = "isFromSaveAs";
    public static final String KEY_PUBLISH2JSS = "PUBLISH2JSS";
    public static final String KEY_PUBLISH2JSS_SILENT = "PUBLISH2JSS.SILENT";

    public void onInitContext(JasperReportsConfiguration jConfig) {
        JSSFileRepositoryService repService = jConfig.getFileRepositoryService();
        if (repService != null) {
            List rservices = repService.getRepositoryServices();
            ArrayList<Object> toDel = new ArrayList<Object>();
            for (RepositoryService rs : rservices) {
                if (!(rs instanceof JRSRepositoryService)) continue;
                toDel.add(rs);
                FileRepositoryService frs = ((JRSRepositoryService)rs).getFileRepositoryService();
                if (frs == null) continue;
                toDel.add(frs);
            }
            rservices.removeAll(toDel);
            rservices.add(new JRSRepositoryService(repService, jConfig));
        }
    }

    public void onLoad(JasperDesign jd, EditorPart editor) {
        if (!(editor instanceof AbstractJRXMLEditor)) {
            return;
        }
        AbstractJRXMLEditor jEditor = (AbstractJRXMLEditor)editor;
        this.onInitContext(jEditor.getJrContext(null));
    }

    public void onSave(JasperReportsContext jrConfig, IProgressMonitor monitor) {
        boolean allways;
        String isSaveAs = jrConfig.getProperty(IS_FROM_SAVE_AS);
        if (isSaveAs != null) {
            jrConfig.removeProperty(IS_FROM_SAVE_AS);
            return;
        }
        JasperReportsConfiguration jConfig = (JasperReportsConfiguration)jrConfig;
        JasperDesign jd = jConfig.getJasperDesign();
        String[] prop = JRSEditorContributor.getServerURL(jd, (IFile)jrConfig.getValue("ifile"), monitor);
        if (prop == null || prop[0] == null) {
            return;
        }
        Boolean doSave = jConfig.getPropertyBoolean("PUBLISH_REPORT_TOJRSONSAVE", Boolean.TRUE.booleanValue());
        if (!doSave.booleanValue()) {
            return;
        }
        MScopedPreferenceStore pStore = jConfig.getPrefStore();
        pStore.setWithDefault(false);
        String sRun = Misc.nullIfEmpty((String)pStore.getString(KEY_PUBLISH2JSS));
        String sAllways = Misc.nullIfEmpty((String)pStore.getString(KEY_PUBLISH2JSS_SILENT));
        pStore.setWithDefault(true);
        boolean run = sRun == null ? true : Boolean.parseBoolean(sRun);
        boolean bl = allways = sAllways == null ? true : Boolean.parseBoolean(sAllways);
        if (allways) {
            SaveConfirmationDialog dialog = new SaveConfirmationDialog(UIUtils.getShell());
            run = dialog.open() == 0;
            pStore.setValue(KEY_PUBLISH2JSS_SILENT, Boolean.toString(!dialog.getAllways()));
        }
        pStore.setValue(KEY_PUBLISH2JSS, Boolean.toString(run));
        if (run) {
            JrxmlPublishAction action = JRSEditorContributor.getAction(monitor, jConfig);
            action.setSilent(run);
            action.run();
        }
    }

    public void onRename(IFile oldName, IFile newName, JasperReportsContext jrConfig, IProgressMonitor monitor) {
        JasperReportsConfiguration jConfig = (JasperReportsConfiguration)jrConfig;
        JasperDesign jd = jConfig.getJasperDesign();
        if (jd != null) {
            if (!this.replaceURL("ireport.jasperserver.reportUnit", jd, oldName, newName)) {
                this.replaceURL("ireport.jasperserver.report.resource", jd, oldName, newName);
            } else {
                jd.removeProperty("ireport.jasperserver.report.resource");
            }
        }
    }

    public void onSaveAs(IFile oldName, IFile newName, JasperReportsContext jrConfig, IProgressMonitor monitor) {
        JasperReportsConfiguration jConfig = (JasperReportsConfiguration)jrConfig;
        JasperDesign jd = jConfig.getJasperDesign();
        jConfig.setProperty(IS_FROM_SAVE_AS, "true");
        if (!this.replaceURL("ireport.jasperserver.reportUnit", jd, oldName, newName)) {
            this.replaceURL("ireport.jasperserver.report.resource", jd, oldName, newName);
        } else {
            jd.removeProperty("ireport.jasperserver.report.resource");
        }
    }

    private boolean replaceURL(String prop, JasperDesign jd, IFile oldName, IFile newName) {
        String url = jd.getProperty(prop);
        if (url == null) {
            return false;
        }
        String old = "/" + oldName.getName();
        String fext = oldName.getFileExtension();
        if (!Misc.isNullOrEmpty((String)fext)) {
            old = old.substring(0, oldName.getName().length() - fext.length());
        }
        if (url.endsWith(old)) {
            String n = "/" + newName.getName();
            fext = newName.getFileExtension();
            if (!Misc.isNullOrEmpty((String)fext)) {
                n = n.substring(0, newName.getName().length() - fext.length());
            }
            jd.setProperty(prop, String.valueOf(url.substring(0, url.length() - old.length())) + n);
            return true;
        }
        return false;
    }

    public static String[] getServerURL(JasperDesign jd, IFile f, IProgressMonitor monitor) {
        if (jd == null) {
            return null;
        }
        String[] urls = new String[]{jd.getProperty("ireport.jasperserver.url"), jd.getProperty("ireport.jasperserver.user")};
        if (f != null) {
            try {
                if (Misc.isNullOrEmpty((String)urls[0])) {
                    urls[0] = f.getPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", "ireport.jasperserver.url"));
                }
                if (Misc.isNullOrEmpty((String)urls[1])) {
                    List<String[]> paths = PublishUtil.loadPath(monitor, f);
                    for (String[] p : paths) {
                        if (!p[0].startsWith("JRSUSER.")) continue;
                        urls[1] = p[1];
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return urls;
    }

    protected static JrxmlPublishAction getAction(IProgressMonitor monitor, JasperReportsConfiguration jrConfig) {
        JrxmlPublishAction publishAction = new JrxmlPublishAction(1, monitor);
        publishAction.setJrConfig(jrConfig);
        return publishAction;
    }

    public void onRun(JasperReportsConfiguration jrConfig, JasperReport jr, Map<String, Object> params) {
    }

    public AContributorAction[] getActions() {
        return new AContributorAction[]{new JrxmlPublishAction()};
    }

    public Action[] getEditorActions(AbstractVisualEditor editor) {
        return null;
    }

    public String getTitleToolTip(JasperReportsContext jrConfig, String toolTip) {
        String s = toolTip;
        JasperDesign jd = ((JasperReportsConfiguration)jrConfig).getJasperDesign();
        if (jd != null) {
            String p = jd.getProperty("ireport.jasperserver.url");
            if (p != null) {
                s = String.valueOf(s) + "\nServer: " + p;
            }
            if ((p = jd.getProperty("ireport.jasperserver.reportUnit")) != null) {
                s = String.valueOf(s) + "\nReport Unit: " + p;
            }
            if ((p = jd.getProperty("ireport.jasperserver.report.resource")) != null) {
                s = String.valueOf(s) + "\nResource name: " + p;
            }
        }
        return s;
    }

    public String[] getEditorActionsIDs() {
        return null;
    }
}

