/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.editor;

import com.jaspersoft.ireport.jasperserver.ws.FileContent;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.editor.preview.PreviewJRPrint;
import com.jaspersoft.studio.editor.preview.stats.Statistics;
import com.jaspersoft.studio.editor.preview.view.APreview;
import com.jaspersoft.studio.editor.preview.view.control.AVParameters;
import com.jaspersoft.studio.editor.preview.view.control.ReportController;
import com.jaspersoft.studio.editor.preview.view.control.VBookmarks;
import com.jaspersoft.studio.editor.preview.view.control.VExporter;
import com.jaspersoft.studio.editor.preview.view.control.VSimpleErrorPreview;
import com.jaspersoft.studio.editor.preview.view.report.IJRPrintable;
import com.jaspersoft.studio.editor.preview.view.report.IURLViewable;
import com.jaspersoft.studio.editor.preview.view.report.html.ABrowserViewer;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.editor.ReportUnitEditor;
import com.jaspersoft.studio.server.editor.input.InputControlsManager;
import com.jaspersoft.studio.server.editor.input.VInputControls;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.server.protocol.ReportExecution;
import com.jaspersoft.studio.server.protocol.restv2.RESTv2ExceptionHandler;
import com.jaspersoft.studio.utils.Console;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.cookie.Cookie;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;

public class ReportRunControler {
    public static final String FORM_PARAMETERS = "Input Controls";
    private LinkedHashMap<String, APreview> viewmap;
    private ReportUnitEditor pcontainer;
    private VInputControls prmInput;
    private InputControlsManager icm;
    private String reportUnit;
    private Console c;
    private IConnection cli;
    private static File tempDir = new File(System.getProperty("java.io.tmpdir"));
    private Statistics stats;
    private ReportExecution repExec;

    public ReportRunControler(ReportUnitEditor pcontainer) {
        this.pcontainer = pcontainer;
    }

    public void setReportUnit(String key) {
        if (!key.equals(this.reportUnit)) {
            this.repExec = new ReportExecution();
            this.repExec.setStatus("queued");
            this.repExec.setReportURIFull(key);
            this.repExec.setReportURI(WSClientHelper.getReportUnitUri(key));
        }
        this.reportUnit = key;
        if (this.viewmap != null && this.prmInput == null) {
            try {
                this.icm = new InputControlsManager();
                ProgressMonitorDialog pm = new ProgressMonitorDialog(UIUtils.getShell());
                pm.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.ReportRunControler_1, -1);
                        try {
                            try {
                                ReportRunControler.this.cli = WSClientHelper.getClient(monitor, ReportRunControler.this.reportUnit);
                                ReportRunControler.this.icm.setWsclient(ReportRunControler.this.cli);
                                ReportRunControler.this.icm.initInputControls(ReportRunControler.this.cli.initInputControls(ReportRunControler.this.reportUnit, "reportUnit", monitor));
                                ReportRunControler.this.icm.getDefaults();
                                UIUtils.getDisplay().syncExec(() -> {
                                    if (ReportRunControler.this.viewmap != null) {
                                        ReportRunControler.this.fillForms(monitor);
                                    }
                                    ReportRunControler.this.runReport();
                                });
                            }
                            catch (Throwable e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                UIUtils.showError((Throwable)e.getCause());
            }
            catch (InterruptedException e) {
                UIUtils.showError((Throwable)e);
            }
            catch (Exception e1) {
                UIUtils.showError((Throwable)e1);
            }
        } else {
            this.runReport();
        }
    }

    public LinkedHashMap<String, APreview> createControls(Composite composite, JasperReportsConfiguration jContext) {
        this.viewmap = new LinkedHashMap();
        this.viewmap.put(FORM_PARAMETERS, (APreview)new VInputControls(composite, jContext));
        this.viewmap.put("report_configuration_bookmarks", (APreview)new VBookmarks(composite, jContext, (PreviewJRPrint)this.pcontainer));
        this.viewmap.put("report_configuration_exporterParameters", (APreview)new VExporter(composite, jContext));
        return this.viewmap;
    }

    public void viewerChanged(APreview view) {
        VExporter vs = (VExporter)this.viewmap.get("report_configuration_exporterParameters");
        vs.setPreferencesPage(view);
    }

    private void fillForms(IProgressMonitor monitor) {
        this.prmInput = (VInputControls)this.viewmap.get(FORM_PARAMETERS);
        this.prmInput.createInputControls(this.icm, monitor);
        this.prmInput.setReportUnit(this.icm, this.icm.getReportUnit(), monitor, this.reportUnit);
    }

    public void runReport() {
        final VSimpleErrorPreview errorView = this.pcontainer.getErrorView();
        this.pcontainer.getRightContainer().switchView(null, (APreview)errorView);
        errorView.setMessage(Messages.ReportControler_generating);
        this.c = this.pcontainer.getConsole();
        this.c.showConsole();
        this.c.clearConsole();
        this.pcontainer.setJasperPrint(null, null);
        this.stats = new Statistics();
        this.stats.startCount("REPORTEXECUTIONTIME");
        this.c.addMessage(com.jaspersoft.studio.server.messages.Messages.ReportRunControler_statsstart);
        this.pcontainer.setNotRunning(false);
        Job job = new Job(String.valueOf(Messages.PreviewEditor_preview_a) + ": " + this.reportUnit + Messages.PreviewEditor_preview_b){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.ReportRunControler_3, -1);
                try {
                    ReportRunControler.this.prmInput.setReportUnit(ReportRunControler.this.icm, ReportRunControler.this.icm.getReportUnit(), monitor, ReportRunControler.this.reportUnit);
                    if (!ReportRunControler.this.prmInput.checkFieldsFilled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        HashMap<String, Object> prmcopy = new HashMap<String, Object>();
                        for (ResourceDescriptor p : ReportRunControler.this.icm.getInputControls()) {
                            if (!p.isVisible() || p.isReadOnly()) continue;
                            if (p.isMandatory()) {
                                prmcopy.put(p.getName(), ReportRunControler.this.icm.getParameters().get(p.getName()));
                                continue;
                            }
                            if (ReportRunControler.this.icm.getParameters().get(p.getName()) == null) continue;
                            prmcopy.put(p.getName(), ReportRunControler.this.icm.getParameters().get(p.getName()));
                        }
                        ArrayList<Argument> args = new ArrayList<Argument>();
                        String reptype = ReportRunControler.this.pcontainer.getCurrentViewer();
                        args.add(new Argument("RUN_OUTPUT_FORMAT", reptype));
                        args.add(new Argument("IMAGES_URI", ""));
                        ReportRunControler.this.repExec.setArgs(args);
                        ReportRunControler.this.repExec.setStatus("refresh");
                        while (ReportRunControler.this.repExec.getStatus().equals("refresh") || ReportRunControler.this.repExec.getStatus().equals("queued") || ReportRunControler.this.repExec.getStatus().equals("execution")) {
                            monitor.setTaskName(ReportRunControler.this.repExec.getStatus());
                            ReportRunControler.this.repExec = WSClientHelper.runReportUnit(monitor, ReportRunControler.this.repExec, prmcopy);
                            if (ReportRunControler.this.repExec.getStatus().equals("ready")) {
                                ReportRunControler.this.stats.endCount("REPORTEXECUTIONTIME");
                                if (ReportRunControler.this.repExec.getTotalPages() != null) {
                                    ReportRunControler.this.stats.setValue("PAGECOUNT", (Object)ReportRunControler.this.repExec.getTotalPages());
                                }
                                if (ReportRunControler.this.repExec.getReportOutputURL() != null && reptype.equals("HTML")) {
                                    this.showURL(ReportRunControler.this.repExec);
                                } else {
                                    Map<String, FileContent> files = ReportRunControler.this.repExec.getFiles();
                                    if (files.isEmpty()) {
                                        this.showReport(null);
                                    }
                                    for (Map.Entry<String, FileContent> entry : files.entrySet()) {
                                        int ind;
                                        FileContent fc = entry.getValue();
                                        ReportRunControler.this.stats.setValue("REPORTSIZE", (Object)fc.getData().length);
                                        if (reptype.equals("JRPRINT")) {
                                            Object obj = JRLoader.loadObject((InputStream)new ByteArrayInputStream(fc.getData()));
                                            if (obj instanceof JasperPrint) {
                                                this.showReport((JasperPrint)obj);
                                            }
                                            break;
                                        }
                                        File f = null;
                                        f = fc.getName().contains("/") ? new File(FilenameUtils.getFullPath((String)fc.getName()), FilenameUtils.getBaseName((String)fc.getName())) : new File(tempDir, fc.getName());
                                        if (f == null || !f.exists()) {
                                            f.deleteOnExit();
                                            f.createNewFile();
                                        }
                                        if (!entry.getKey().equals("report")) {
                                            if (!f.getName().equals(entry.getKey())) {
                                                File dest = new File(tempDir, entry.getKey());
                                                f.renameTo(dest);
                                                f = dest;
                                            }
                                        } else if (f.getName().endsWith(".att") && (ind = fc.getMimeType().indexOf(47)) >= 0) {
                                            String str = fc.getMimeType().substring(ind + 1);
                                            File dest = new File(f.getAbsolutePath().replaceAll(".att$", "." + str));
                                            f.renameTo(dest);
                                            f = dest;
                                        }
                                        Throwable throwable = null;
                                        Object var11_15 = null;
                                        try (FileOutputStream htmlFile = new FileOutputStream(f);){
                                            htmlFile.write(fc.getData());
                                            if (!entry.getKey().equals("report")) continue;
                                            this.showURL(f.toURI().toASCIIString());
                                        }
                                        catch (Throwable throwable2) {
                                            if (throwable == null) {
                                                throwable = throwable2;
                                            } else if (throwable != throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            throw throwable;
                                        }
                                    }
                                }
                            } else if (ReportRunControler.this.repExec.getStatus().equals("queued") || ReportRunControler.this.repExec.getStatus().equals("execution")) {
                                this.showURL(ReportRunControler.this.repExec);
                                Thread.sleep(100L);
                            } else if (ReportRunControler.this.repExec.getStatus().equals("failed") || ReportRunControler.this.repExec.getStatus().equals("cancelled")) {
                                RESTv2ExceptionHandler reh = new RESTv2ExceptionHandler(WSClientHelper.getClient(monitor, ReportRunControler.this.repExec.getReportURIFull()));
                                throw new Exception(reh.buildMessage(monitor, "", ReportRunControler.this.repExec.getErrorDescriptor()));
                            }
                            if (!monitor.isCanceled()) continue;
                            WSClientHelper.cancelReportUnit(monitor, ReportRunControler.this.repExec);
                            break;
                        }
                    }
                    catch (Throwable e) {
                        ReportController.showRunReport((Console)ReportRunControler.this.c, (PreviewJRPrint)ReportRunControler.this.pcontainer, (Throwable)e);
                    }
                }
                finally {
                    monitor.done();
                    ReportRunControler.this.finishReport();
                }
                return Status.OK_STATUS;
            }

            private void showReport(JasperPrint obj) {
                UIUtils.getDisplay().asyncExec(() -> {
                    ReportRunControler.this.stats.setValue("PAGECOUNT", (Object)(obj == null ? 0 : obj.getPages().size()));
                    APreview pv = ReportRunControler.this.pcontainer.getDefaultViewer();
                    if (pv instanceof IJRPrintable) {
                        try {
                            ((IJRPrintable)pv).setJRPRint(ReportRunControler.this.stats, obj, true);
                            VBookmarks vs = (VBookmarks)ReportRunControler.this.viewmap.get("report_configuration_bookmarks");
                            vs.setJasperPrint(obj);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ReportRunControler.this.pcontainer.setJasperPrint(ReportRunControler.this.stats, obj);
                    ReportRunControler.this.pcontainer.setCurrentViewer(ReportRunControler.this.pcontainer.getDefaultViewerKey(), true);
                    if (obj == null) {
                        errorView.setMessage(Messages.ReportRunControler_22);
                    }
                });
            }

            private void showURL(String url) {
                UIUtils.getDisplay().asyncExec(() -> {
                    APreview pv = ReportRunControler.this.pcontainer.getDefaultViewer();
                    if (pv instanceof IURLViewable) {
                        try {
                            ((IURLViewable)pv).setURL(url);
                            ReportRunControler.this.pcontainer.setCurrentViewer(ReportRunControler.this.pcontainer.getDefaultViewerKey(), true);
                        }
                        catch (Exception e) {
                            UIUtils.showError((Throwable)e);
                        }
                    }
                });
            }

            private void showURL(ReportExecution re) {
                if (re.getReportOutputURL() != null) {
                    UIUtils.getDisplay().asyncExec(() -> {
                        APreview pv = ReportRunControler.this.pcontainer.getDefaultViewer();
                        if (pv instanceof ABrowserViewer) {
                            try {
                                String urlcookie = ReportRunControler.this.cli.getServerProfile().getUrl();
                                StringBuilder scookie = new StringBuilder();
                                String del = "";
                                for (Cookie co : re.getReportOutputCookie()) {
                                    scookie.append(del).append(co.getName()).append("=").append(co.getValue());
                                    del = ";";
                                }
                                ((ABrowserViewer)pv).setURL(re.getReportOutputURL(), urlcookie, scookie.toString());
                                ReportRunControler.this.pcontainer.setCurrentViewer(ReportRunControler.this.pcontainer.getDefaultViewerKey(), true);
                            }
                            catch (Exception e) {
                                UIUtils.showError((Throwable)e);
                            }
                        }
                    });
                }
            }
        };
        job.setPriority(30);
        job.schedule();
    }

    public void finishReport() {
        ReportController.finishCompiledReport((Console)this.c, (AVParameters)this.prmInput, (PreviewJRPrint)this.pcontainer);
    }

    public void resetParametersToDefault(IProgressMonitor monitor) throws Exception {
        this.prmInput.setupDefaultValues(monitor);
    }
}

