/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.editor;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.preview.IParametrable;
import com.jaspersoft.studio.editor.preview.IRunReport;
import com.jaspersoft.studio.editor.preview.MultiPageContainer;
import com.jaspersoft.studio.editor.preview.PreviewJRPrint;
import com.jaspersoft.studio.editor.preview.stats.Statistics;
import com.jaspersoft.studio.editor.preview.view.APreview;
import com.jaspersoft.studio.editor.preview.view.AViewsFactory;
import com.jaspersoft.studio.editor.report.CachedSelectionProvider;
import com.jaspersoft.studio.editor.report.CommonSelectionCacheProvider;
import com.jaspersoft.studio.editor.util.StringInput;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.messages.MessagesByKeys;
import com.jaspersoft.studio.server.editor.LeftToolBarManager;
import com.jaspersoft.studio.server.editor.PreviewTopToolBarManager;
import com.jaspersoft.studio.server.editor.ReportRunControler;
import com.jaspersoft.studio.server.editor.ReportUnitViewsFactory;
import com.jaspersoft.studio.server.editor.action.RunStopAction;
import com.jaspersoft.studio.swt.toolbar.ToolItemContribution;
import com.jaspersoft.studio.swt.widgets.CSashForm;
import java.io.InputStream;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;

public class ReportUnitEditor
extends PreviewJRPrint
implements IRunReport,
IParametrable,
CachedSelectionProvider {
    public static final String ID = "com.jaspersoft.studio.server.editor.ReportUnitEditor";
    private String reportUnitURI;
    private CSashForm sashform;
    private LeftToolBarManager leftToolbar;
    private MultiPageContainer leftContainer;
    private ReportRunControler reportControler;
    private CommonSelectionCacheProvider selectionCache = new CommonSelectionCacheProvider();

    public ReportUnitEditor() {
        super(false);
    }

    protected void loadJRPrint(IEditorInput input) throws PartInitException {
        try {
            this.reportUnitURI = FileUtils.readInputStreamAsString((InputStream)((StringInput)this.getEditorInput()).getStorage().getContents());
        }
        catch (Exception e1) {
            throw new PartInitException(e1.getMessage(), (Throwable)e1);
        }
        UIUtils.getDisplay().asyncExec(this::runReport);
    }

    public void setCurrentViewer(String viewerKey, boolean refresh) {
        super.setCurrentViewer(viewerKey, refresh);
        this.getActionToolBarManager(null).contributeItems(this.getRightContainer().getViewer(viewerKey));
    }

    protected void afterRightSwitchView() {
        this.runReport();
    }

    public void runReport() {
        if (this.isNotRunning()) {
            this.actionToolBarManager.setEnabled(false);
            this.dataDapterToolBarManager.setEnabled(false);
            if (this.leftToolbar != null) {
                this.leftToolbar.setEnabled(false);
            }
            this.getLeftContainer().setEnabled(false);
            this.getLeftContainer().switchView(null, "Input Controls");
            this.reportControler.setReportUnit(this.reportUnitURI);
        }
    }

    protected PreviewTopToolBarManager getDataAdapterToolBarManager(Composite container) {
        if (this.dataDapterToolBarManager == null) {
            this.dataDapterToolBarManager = new PreviewTopToolBarManager(this, container);
        }
        return (PreviewTopToolBarManager)this.dataDapterToolBarManager;
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        this.getDataAdapterToolBarManager(container);
        this.getActionToolBarManager(container);
        Button lbutton = new Button(container, 8);
        lbutton.setLayoutData((Object)new GridData(128));
        lbutton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/application-sidebar-expand.png"));
        lbutton.setToolTipText("Show Parameters");
        lbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportUnitEditor.this.sashform.upRestore();
            }
        });
        this.sashform = new CSashForm(container, 256);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.sashform.setLayoutData((Object)gd);
        this.createLeft(parent, (SashForm)this.sashform);
        this.createRight((Composite)this.sashform);
        this.sashform.setWeights(new int[]{100, 150});
    }

    public String getTitleToolTip() {
        int lastPartIndex;
        if (this.reportUnitURI != null && (lastPartIndex = this.reportUnitURI.lastIndexOf(":")) != -1) {
            return this.reportUnitURI.substring(0, lastPartIndex);
        }
        return super.getTitleToolTip();
    }

    protected void createLeft(Composite parent, SashForm sf) {
        Composite leftComposite = new Composite((Composite)sf, 2048);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        leftComposite.setLayout((Layout)layout);
        this.leftToolbar = new LeftToolBarManager(this, leftComposite);
        Composite cleftcompo = new Composite(leftComposite, 0);
        cleftcompo.setBackground(parent.getDisplay().getSystemColor(1));
        cleftcompo.setLayoutData((Object)new GridData(1808));
        cleftcompo.setLayout((Layout)new StackLayout());
        Composite bottom = new Composite(leftComposite, 0);
        bottom.setLayoutData((Object)new GridData(64));
        bottom.setLayout((Layout)new GridLayout(2, false));
        ToolBar tb = new ToolBar(bottom, 8519744);
        ToolBarManager tbm = new ToolBarManager(tb);
        tbm.add((IAction)new RunStopAction(this));
        ToolItemContribution tireset = new ToolItemContribution("", 8);
        tbm.add((IContributionItem)tireset);
        tbm.update(true);
        ToolItem toolItem = tireset.getToolItem();
        toolItem.setText(Messages.PreviewContainer_resetactiontitle);
        toolItem.setToolTipText(Messages.PreviewContainer_resetactiontooltip);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Job job = new Job("Update Report Options"){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.PreviewContainer_resetactiontooltip, -1);
                        try {
                            (this).ReportUnitEditor.this.reportControler.resetParametersToDefault(monitor);
                        }
                        catch (Exception e) {
                            UIUtils.showError((Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(30);
                job.schedule();
            }
        });
        tbm.update(true);
        this.getLeftContainer().populate(cleftcompo, this.getReportControler().createControls(cleftcompo, this.jrContext));
        this.getLeftContainer().switchView(null, "Input Controls");
    }

    public MultiPageContainer getLeftContainer() {
        if (this.leftContainer == null) {
            this.leftContainer = new MultiPageContainer(){

                public void switchView(Statistics stats, APreview view) {
                    super.switchView(stats, view);
                    for (String key : this.pmap.keySet()) {
                        if (this.pmap.get(key) != view) continue;
                        ReportUnitEditor.this.leftToolbar.setLabelText(MessagesByKeys.getString((String)key));
                        break;
                    }
                }
            };
        }
        return this.leftContainer;
    }

    public void setNotRunning(boolean stopRunning) {
        super.setNotRunning(stopRunning);
        if (stopRunning) {
            this.getLeftContainer().setEnabled(true);
            this.leftToolbar.setEnabled(true);
        }
    }

    public boolean switchRightView(APreview view, Statistics stats, MultiPageContainer container) {
        this.reportControler.viewerChanged(view);
        return super.switchRightView(view, stats, container);
    }

    public String getDefaultViewerKey() {
        if (this.currentViewer == null) {
            this.currentViewer = "HTML";
        }
        return this.currentViewer;
    }

    public AViewsFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new ReportUnitViewsFactory();
        }
        return this.viewFactory;
    }

    public void showParameters(boolean showprm) {
        if (showprm) {
            this.sashform.upRestore();
        } else {
            this.sashform.upHide();
        }
    }

    private ReportRunControler getReportControler() {
        if (this.reportControler == null) {
            this.reportControler = new ReportRunControler(this);
        }
        return this.reportControler;
    }

    public void setMode(String mode) {
    }

    public CommonSelectionCacheProvider getSelectionCache() {
        return this.selectionCache;
    }
}

