/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.editor.action.exporter;

import com.ibm.icu.text.MessageFormat;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.exporter.BaseResource;
import com.jaspersoft.studio.editor.action.exporter.IExportedResourceHandler;
import com.jaspersoft.studio.editor.action.exporter.IResourceDefinition;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.repository.RepositoryView;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.model.server.MServers;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jasperreports.eclipse.ui.util.RunnableOverwriteQuestion;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.CastorHelper;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Pair;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ExportedServersHandler
implements IExportedResourceHandler {
    private static final String EXPORTED_FOLDER_NAME = "jrsConnections";
    private static final String INDEX_FILE_NAME = "index.properties";
    private List<IResourceDefinition> cachedExportableResources = null;
    private Pair<String, List<IResourceDefinition>> cachedImportableResources = null;

    public List<IResourceDefinition> getRestorableResources(File exportedContainer) {
        block9: {
            String containerPath = exportedContainer.getAbsolutePath();
            if (this.cachedImportableResources == null || !((String)this.cachedImportableResources.getKey()).equals(containerPath)) {
                File exportedFolder = new File(exportedContainer, EXPORTED_FOLDER_NAME);
                File indexFile = new File(exportedFolder, INDEX_FILE_NAME);
                if (indexFile.exists()) {
                    FileInputStream is = null;
                    try {
                        try {
                            ArrayList<BaseResource> result = new ArrayList<BaseResource>();
                            is = new FileInputStream(indexFile);
                            Properties loadedProperties = new Properties();
                            loadedProperties.load(is);
                            for (Map.Entry<Object, Object> entry : loadedProperties.entrySet()) {
                                BaseResource resource = new BaseResource(entry.getValue().toString());
                                resource.setData(entry.getKey());
                                result.add(resource);
                            }
                            this.cachedImportableResources = new Pair((Object)containerPath, result);
                        }
                        catch (Exception ex) {
                            JaspersoftStudioPlugin.getInstance().logError((Throwable)ex);
                            this.cachedImportableResources = new Pair((Object)containerPath, new ArrayList());
                            FileUtils.closeStream((Closeable)is);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeStream(is);
                        throw throwable;
                    }
                    FileUtils.closeStream((Closeable)is);
                } else {
                    this.cachedImportableResources = new Pair((Object)containerPath, new ArrayList());
                }
            }
        }
        return (List)this.cachedImportableResources.getValue();
    }

    public List<IResourceDefinition> getExportableResources() {
        if (this.cachedExportableResources == null) {
            List<MServerProfile> profiles = ServerManager.getServerProfiles();
            this.cachedExportableResources = new ArrayList<IResourceDefinition>();
            for (MServerProfile profile : profiles) {
                BaseResource resource = new BaseResource(profile.getDisplayText());
                resource.setData((Object)profile);
                this.cachedExportableResources.add((IResourceDefinition)resource);
            }
        }
        return this.cachedExportableResources;
    }

    public File exportContentFolder(List<IResourceDefinition> resourcesToExport) {
        File destDir;
        block8: {
            HashSet<MServerProfile> resourcesToExportSet = new HashSet<MServerProfile>();
            for (IResourceDefinition definition : resourcesToExport) {
                resourcesToExportSet.add((MServerProfile)((Object)definition.getData()));
            }
            Properties props = new Properties();
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            tempDir.deleteOnExit();
            destDir = new File(tempDir, EXPORTED_FOLDER_NAME);
            if (destDir.exists()) {
                FileUtils.recursiveDelete((File)destDir);
            }
            destDir.mkdirs();
            int index = 0;
            for (MServerProfile serverConnection : ServerManager.getServerProfiles()) {
                if (!resourcesToExportSet.contains((Object)serverConnection)) continue;
                String fileName = "jrsConnection" + index;
                this.save(serverConnection, new File(destDir, fileName));
                props.put(fileName, serverConnection.getDisplayText());
                ++index;
            }
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(new File(destDir, INDEX_FILE_NAME));
                    props.store(out, "Exported Server Index");
                }
                catch (Exception ex) {
                    JaspersoftStudioPlugin.getInstance().logError((Throwable)ex);
                    FileUtils.closeStream(out);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(out);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)out);
        }
        return destDir;
    }

    public void restoreContentFolder(File exportedContainer, List<IResourceDefinition> resourcesToImport) {
        File elementsFolder = new File(exportedContainer, EXPORTED_FOLDER_NAME);
        if (elementsFolder.exists()) {
            List<MServerProfile> loadedProfiles = this.load(elementsFolder, resourcesToImport);
            HashMap<String, MServerProfile> existingProfiles = this.getExistingProfiles();
            ArrayList<String> duplicatedConnection = new ArrayList<String>();
            for (MServerProfile profile : loadedProfiles) {
                if (!existingProfiles.containsKey(profile.getValue().getName())) continue;
                duplicatedConnection.add(profile.getValue().getName());
            }
            RunnableOverwriteQuestion.RESPONSE_TYPE response = RunnableOverwriteQuestion.RESPONSE_TYPE.KEEP_BOTH;
            if (!duplicatedConnection.isEmpty()) {
                response = this.askOverwrite(duplicatedConnection);
            }
            for (MServerProfile profile : loadedProfiles) {
                String name = profile.getValue().getName();
                if (existingProfiles.containsKey(name)) {
                    if (response == RunnableOverwriteQuestion.RESPONSE_TYPE.KEEP_BOTH) {
                        profile.getValue().setName(this.getName(existingProfiles, name));
                        ServerManager.addServerProfile(profile);
                        continue;
                    }
                    if (response != RunnableOverwriteQuestion.RESPONSE_TYPE.OVERWRITE) continue;
                    ServerManager.removeServerProfile(existingProfiles.get(name));
                    ServerManager.addServerProfile(profile);
                    continue;
                }
                ServerManager.addServerProfile(profile);
            }
            this.refreshServers();
        }
    }

    private HashMap<String, MServerProfile> getExistingProfiles() {
        HashMap<String, MServerProfile> result = new HashMap<String, MServerProfile>();
        for (MServerProfile profile : ServerManager.getServerProfiles()) {
            result.put(profile.getValue().getName(), profile);
        }
        return result;
    }

    private void save(MServerProfile serverProfile, File destination) {
        block5: {
            FileOutputStream stream = null;
            try {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(new InputSource(new StringReader(serverProfile.toXML())));
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource source = new DOMSource(doc);
                    stream = new FileOutputStream(destination);
                    StreamResult result = new StreamResult(stream);
                    transformer.transform(source, result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    FileUtils.closeStream(stream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(stream);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)stream);
        }
    }

    private List<MServerProfile> load(File serversFolder, List<IResourceDefinition> resourcesToImport) {
        File[] storageContent;
        ArrayList<MServerProfile> result = new ArrayList<MServerProfile>();
        HashSet<String> filesToImport = new HashSet<String>();
        for (IResourceDefinition resourceToImport : resourcesToImport) {
            filesToImport.add(resourceToImport.getData().toString());
        }
        File[] fileArray = storageContent = serversFolder.listFiles();
        int n = storageContent.length;
        int n2 = 0;
        while (n2 < n) {
            File storageElement = fileArray[n2];
            if (!storageElement.isHidden() && filesToImport.contains(storageElement.getName())) {
                try {
                    FileInputStream inputStream = new FileInputStream(storageElement);
                    InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                    InputSource is = new InputSource(reader);
                    is.setEncoding("UTF-8");
                    Document document = JRXmlUtils.parse((InputSource)is);
                    Element serverNode = document.getDocumentElement();
                    if (serverNode.getNodeType() == 1) {
                        try {
                            ServerProfile sprof = (ServerProfile)CastorHelper.read((Node)serverNode, (String)"com/jaspersoft/studio/server/model/server/ServerProfileImpl.xml");
                            MServerProfile sp = new MServerProfile(null, sprof);
                            result.add(sp);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    UIUtils.showError((Throwable)e);
                }
            }
            ++n2;
        }
        return result;
    }

    public String getResourceNameExport() {
        int serverNumbers = ServerManager.getServerProfiles().size();
        return "JasperReports Server Connections (" + serverNumbers + ")";
    }

    public String getResourceNameImport(File exportedContainer) {
        return "JasperReports Server Connections (" + this.getRestorableResources(exportedContainer).size() + ")";
    }

    private RunnableOverwriteQuestion.RESPONSE_TYPE askOverwrite(List<String> connectionNames) {
        String baseMessage = Messages.ExportedServersHandler_overlappingMessage;
        StringBuilder message = new StringBuilder("\n");
        int index = 1;
        for (String adapter : connectionNames) {
            message.append(adapter);
            message.append(index == connectionNames.size() ? ".\n" : ",\n");
            ++index;
        }
        String composedMessage = MessageFormat.format((String)baseMessage, (Object[])new Object[]{message.toString()});
        return RunnableOverwriteQuestion.showQuestion((String)Messages.ExportedServersHandler_overlappingDescription, (String)composedMessage);
    }

    private String getName(HashMap<String, MServerProfile> existingServers, String baseName) {
        int index = 1;
        String newName = String.valueOf(baseName) + "_" + index;
        while (existingServers.containsKey(newName)) {
            newName = String.valueOf(baseName) + "_" + ++index;
        }
        return newName;
    }

    protected void refreshServers() {
        RepositoryView view = this.getRepositoryView();
        TreeViewer treeViewer = null;
        MServers serversNode = null;
        if (view != null) {
            treeViewer = view.getTreeViewer();
            MRoot root = (MRoot)treeViewer.getInput();
            List lst = root.getChildren();
            for (INode n : lst) {
                if (!(n instanceof MServers)) continue;
                serversNode = (MServers)n;
                break;
            }
        }
        if (serversNode != null) {
            ServerManager.loadServerProfiles(serversNode);
            treeViewer.refresh();
        }
    }

    private RepositoryView getRepositoryView() {
        return (RepositoryView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.jaspersoft.studio.Repository");
    }
}

