/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.editor.input;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceProperty;
import com.jaspersoft.studio.editor.preview.input.ADataInput;
import com.jaspersoft.studio.editor.preview.input.IDataInput;
import com.jaspersoft.studio.server.editor.input.PResourceDescriptor;
import com.jaspersoft.studio.server.editor.input.lov.ListOfValuesInput;
import com.jaspersoft.studio.server.editor.input.query.QueryInput;
import com.jaspersoft.studio.server.protocol.IConnection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class InputControlsManager {
    private List<ResourceDescriptor> inputcontrols;
    private Map<String, Object> defaults;
    private ResourceDescriptor rdrepunit;
    private IConnection wsclient;
    private List<IDataInput> icontrols = new ArrayList<IDataInput>();
    private PropertyChangeListener propChangeListener = new PropertyChangeListener(){
        private int started = 0;
        private boolean ended = true;
        private IDataInput control;

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof IDataInput) {
                this.control = (IDataInput)source;
                this.doCascade();
            }
        }

        protected void doCascade() {
            ++this.started;
            if (this.ended) {
                this.ended = false;
                Job job = new Job("Update Cascading Input Controls"){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask("Update Controls", -1);
                        HashMap<IDataInput, Map<String, Object>> toUpd = new HashMap<IDataInput, Map<String, Object>>();
                        InputControlsManager.this.actionPerformed(control, toUpd);
                        try {
                            try {
                                InputControlsManager.this.updateControls(toUpd, monitor);
                                ended = true;
                                --started;
                                if (started > 0) {
                                    started = 0;
                                    this.doCascade();
                                }
                            }
                            catch (Exception e) {
                                UIUtils.showError((Throwable)e);
                                monitor.done();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.setUser(false);
                job.schedule();
            }
        }
    };

    public IConnection getWsClient() {
        return this.wsclient;
    }

    public void setWsclient(IConnection wsclient) {
        this.wsclient = wsclient;
    }

    public ResourceDescriptor getReportUnit() {
        return this.rdrepunit;
    }

    public Map<String, Object> getParameters() {
        return this.defaults;
    }

    public void getDefaults() {
        ResourceProperty rp;
        List<ResourceProperty> list;
        this.defaults = new HashMap<String, Object>();
        if (this.rdrepunit.getWsType().equals("ReportOptionsResource") && (list = (rp = this.rdrepunit.getResourceProperty("PROP_VALUES")).getProperties()) != null) {
            for (ResourceProperty li : list) {
                if (!li.getProperties().isEmpty()) {
                    ArrayList<String> listVal = new ArrayList<String>();
                    for (ResourceProperty sli : li.getProperties()) {
                        listVal.add(sli.getValue());
                    }
                    this.defaults.put(li.getName(), listVal);
                    continue;
                }
                this.defaults.put(li.getName(), Misc.nvl((String)li.getValue()));
            }
        }
    }

    public List<ResourceDescriptor> getInputControls() {
        return this.inputcontrols;
    }

    public void initInputControls(ResourceDescriptor rdrepunit) {
        this.rdrepunit = rdrepunit;
        this.inputcontrols = new ArrayList<ResourceDescriptor>();
        if (rdrepunit != null) {
            for (ResourceDescriptor sub_rd : rdrepunit.getChildren()) {
                String wsType = sub_rd.getWsType();
                if (!wsType.equals("inputControl")) continue;
                this.inputcontrols.add(sub_rd);
            }
        }
    }

    public List<IDataInput> getControls() {
        return this.icontrols;
    }

    public PropertyChangeListener getPropertyChangeListener() {
        return this.propChangeListener;
    }

    public void actionPerformed(IDataInput ic, Map<IDataInput, Map<String, Object>> controls) {
        String icName = ((PResourceDescriptor)ic.getParameter()).getResourceDescriptor().getName();
        for (IDataInput icToUpdate : this.icontrols) {
            ResourceDescriptor rd;
            List<String> parametersICs;
            if (icToUpdate == ic || controls.containsKey(icToUpdate) || (parametersICs = (rd = ((PResourceDescriptor)icToUpdate.getParameter()).getResourceDescriptor()).getMasterInputControls()) == null || !parametersICs.contains(icName)) continue;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            Map<String, Object> prms = this.getParameters();
            for (String paramName : parametersICs) {
                parameters.put(paramName, prms.get(paramName));
            }
            controls.put(icToUpdate, parameters);
            this.actionPerformed(icToUpdate, controls);
            break;
        }
    }

    private void updateControls(Map<IDataInput, Map<String, Object>> controls, IProgressMonitor monitor) throws Exception {
        ArrayList<ResourceDescriptor> rds = new ArrayList<ResourceDescriptor>();
        for (IDataInput ic : controls.keySet()) {
            ResourceDescriptor rd = ((PResourceDescriptor)ic.getParameter()).getResourceDescriptor();
            rd.setIcValues(controls.get(ic));
            rds.add(rd);
        }
        List<ResourceDescriptor> newRds = this.wsclient.cascadeInputControls(this.rdrepunit, rds, monitor);
        for (IDataInput ic : controls.keySet()) {
            ResourceDescriptor rd = ((PResourceDescriptor)ic.getParameter()).getResourceDescriptor();
            for (ResourceDescriptor r : newRds) {
                if (r == rd || !r.getName().equals(rd.getName())) continue;
                rd.setListOfValues(r.getListOfValues());
                rd.setQueryData(r.getQueryData());
                rd.setValue(r.getValue());
            }
        }
        UIUtils.getDisplay().syncExec(() -> {
            for (IDataInput ic : controls.keySet()) {
                if (ic instanceof QueryInput) {
                    ((QueryInput)ic).fillTable();
                } else if (ic instanceof ListOfValuesInput) {
                    ((ListOfValuesInput)ic).fillTable();
                }
                ic.updateInput();
            }
        });
    }

    public List<ResourceDescriptor> getICValues() {
        ArrayList<ResourceDescriptor> rds = new ArrayList<ResourceDescriptor>();
        for (IDataInput ic : this.icontrols) {
            ResourceDescriptor rd = ((PResourceDescriptor)ic.getParameter()).getResourceDescriptor();
            rd.setIcValues(((ADataInput)ic).getParams());
            rds.add(rd);
        }
        return rds;
    }

    public boolean isAnyVisible() {
        for (ResourceDescriptor ic : this.inputcontrols) {
            if (!InputControlsManager.isICVisible(ic)) continue;
            return true;
        }
        return false;
    }

    public static boolean isICSingle(ResourceDescriptor ic) {
        return ic.getControlType() == 1 || ic.getControlType() == 2;
    }

    protected static boolean isICVisible(ResourceDescriptor ic) {
        return ic.getResourcePropertyValue("PROP_INPUTCONTROL_IS_VISIBLE") == null || ic.getResourcePropertyValue("PROP_INPUTCONTROL_IS_VISIBLE").equals("true");
    }

    public static boolean isRDQuery(ResourceDescriptor sub_ic) {
        return sub_ic.getWsType().equals("query");
    }

    public static boolean isICQuery(ResourceDescriptor ic) {
        return ic.getControlType() == 4 || ic.getControlType() == 9 || ic.getControlType() == 7 || ic.getControlType() == 11;
    }

    public static boolean isICListOfValues(ResourceDescriptor ic) {
        return ic.getControlType() == 3 || ic.getControlType() == 8 || ic.getControlType() == 6 || ic.getControlType() == 10;
    }
}

