/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.editor.input.lov;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class KeyValueDialog
extends ATitledDialog {
    private ListItem listItem;
    private ListItem oldItem;
    private List<ListItem> items;
    private Text vtxt;
    private Text txt;

    public KeyValueDialog(Shell parentShell, ListItem listItem, List<ListItem> items) {
        super(parentShell, false);
        this.listItem = new ListItem(listItem.getLabel(), listItem.getValue());
        this.oldItem = listItem;
        this.items = items;
    }

    public ListItem getListItem() {
        return this.listItem;
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        cmp.setLayout((Layout)new GridLayout(2, false));
        new Label(cmp, 0).setText("Name");
        this.txt = new Text(cmp, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 150;
        this.txt.setLayoutData((Object)gd);
        this.txt.setText(Misc.nvl((String)this.listItem.getLabel()));
        this.txt.addModifyListener(e -> this.handleNameChanged(this.txt.getText()));
        new Label(cmp, 0).setText("Value");
        this.vtxt = new Text(cmp, 2048);
        gd = new GridData(768);
        gd.widthHint = 150;
        this.vtxt.setLayoutData((Object)gd);
        this.vtxt.setText(Misc.nvl((String)((String)this.listItem.getValue())));
        this.vtxt.addModifyListener(e -> this.handleValueChanged(this.vtxt.getText()));
        return cmp;
    }

    protected void handleValueChanged(String txt) {
        this.listItem.setValue(txt);
        this.validateForm();
    }

    protected void handleNameChanged(String txt) {
        this.listItem.setLabel(txt);
        this.validateForm();
    }

    private void validateForm() {
        if (Misc.isNullOrEmpty((String)this.vtxt.getText())) {
            this.setError("Value can't be empty.");
            KeyValueDialog.canFinish((Dialog)this, (boolean)false);
        } else if (Misc.isNullOrEmpty((String)this.txt.getText())) {
            this.setError("Name can't be empty.");
            KeyValueDialog.canFinish((Dialog)this, (boolean)false);
        } else if (this.exists(this.txt.getText())) {
            this.setError("This name already exists.");
            KeyValueDialog.canFinish((Dialog)this, (boolean)false);
        } else {
            this.setError(null);
            KeyValueDialog.canFinish((Dialog)this, (boolean)true);
        }
    }

    private boolean exists(String value) {
        for (ListItem li : this.items) {
            if (li == this.oldItem || !li.getLabel().equals(value)) continue;
            return true;
        }
        return false;
    }
}

