/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.editor.input.query;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.InputControlQueryDataRow;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.server.editor.input.IInput;
import com.jaspersoft.studio.server.editor.input.query.QueryInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableInput
implements IInput {
    protected Table table;
    private QueryInput dataInput;
    private Map<String, Object> params;
    private IParameter param;

    public TableInput(QueryInput dataInput, IParameter param, Map<String, Object> params) {
        this.dataInput = dataInput;
        this.param = param;
        this.params = params;
    }

    @Override
    public void createControl(Composite parent, int style) {
        this.createTable(parent, style);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 8;
        gd.minimumHeight = 100;
        this.table.setLayoutData((Object)gd);
        this.fillControl();
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] ti = TableInput.this.table.getSelection();
                if (TableInput.this.dataInput.getRD().getControlType() == 11) {
                    TableInput.this.doUpdateModel(TableInput.getCheckedElements(TableInput.this.table));
                } else if (TableInput.this.dataInput.getRD().getControlType() == 7) {
                    TableInput.this.doUpdateModel(ti);
                } else {
                    TableInput.this.dataInput.updateModel(ti.length > 0 ? ti[0].getData() : null);
                }
            }
        };
        this.table.addSelectionListener((SelectionListener)listener);
        this.updateInput();
        listener.widgetSelected(null);
    }

    private void doUpdateModel(TableItem[] ti) {
        ArrayList<Object> lst = new ArrayList<Object>();
        TableItem[] tableItemArray = ti;
        int n = ti.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            lst.add(item.getData());
            ++n2;
        }
        this.dataInput.updateModel(lst);
    }

    public static TableItem[] getCheckedElements(Table tbl) {
        TableItem[] children = tbl.getItems();
        ArrayList<TableItem> v = new ArrayList<TableItem>(children.length);
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            if (item.getChecked()) {
                v.add(item);
            }
            ++i;
        }
        return v.toArray(new TableItem[v.size()]);
    }

    protected void createTable(Composite parent, int style) {
        this.table = new Table(parent, style | 0x200 | 0x100 | 0x800 | 0x10000);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(false);
    }

    @Override
    public void fillControl() {
        this.table.select(-1);
        this.table.removeAll();
        List<InputControlQueryDataRow> qvalues = this.dataInput.getRD().getQueryData();
        String[] qcolumns = this.dataInput.getRD().getQueryVisibleColumns();
        Object[] objectArray = this.table.getColumns();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = objectArray[n2];
            tc.dispose();
            ++n2;
        }
        objectArray = qcolumns;
        n = qcolumns.length;
        n2 = 0;
        while (n2 < n) {
            TableColumn c = objectArray[n2];
            new TableColumn(this.table, 0).setText((String)c);
            ++n2;
        }
        ArrayList<Object> toSel = new ArrayList<Object>();
        for (InputControlQueryDataRow item : qvalues) {
            TableItem ti = new TableItem(this.table, 0);
            ti.setData(item.getValue());
            List<String> cvals = item.getColumnValues();
            int i = 0;
            while (i < cvals.size()) {
                ti.setText(i, cvals.get(i));
                ++i;
            }
            if (!item.isSelected()) continue;
            toSel.add(item.getValue());
        }
        this.params.put(this.param.getName(), toSel);
        TableColumn[] tableColumnArray = this.table.getColumns();
        int n3 = tableColumnArray.length;
        int n4 = 0;
        while (n4 < n3) {
            TableColumn tc = tableColumnArray[n4];
            tc.pack();
            ++n4;
        }
        if (qvalues.size() > 4) {
            ((GridData)this.table.getLayoutData()).heightHint = 100;
        }
        this.getControl().getParent().layout();
    }

    @Override
    public void updateInput() {
        Object value = this.params.get(this.param.getName());
        if (value != null) {
            if (this.dataInput.getRD().getControlType() == 7 || this.dataInput.getRD().getControlType() == 11) {
                if (value instanceof List) {
                    ArrayList<TableItem> titems = new ArrayList<TableItem>();
                    List lst = (List)value;
                    TableItem[] tableItemArray = this.table.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem ti = tableItemArray[n2];
                        if (lst.contains(ti.getData())) {
                            titems.add(ti);
                        }
                        ++n2;
                    }
                    this.table.setSelection(titems.toArray(new TableItem[titems.size()]));
                }
            } else {
                if (value instanceof List && !((List)value).isEmpty()) {
                    value = ((List)value).get(0);
                }
                TableItem[] tableItemArray = this.table.getItems();
                int n = tableItemArray.length;
                int n3 = 0;
                while (n3 < n) {
                    TableItem ti = tableItemArray[n3];
                    if (ti.getData().equals(value)) {
                        this.table.setSelection(ti);
                    }
                    ++n3;
                }
            }
        }
    }

    @Override
    public Control getControl() {
        return this.table;
    }
}

