/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.export;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.property.metadata.PropertyMetadataRegistry;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.annotations.properties.PropertyScope;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.properties.StandardPropertyMetadata;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;

public class AExporter {
    public static Map<String, IFile> fileurimap = new HashMap<String, IFile>();
    public static final String PROP_SERVERURL = "ireport.jasperserver.url";
    public static final String PROP_USER = "ireport.jasperserver.user";
    public static final String PROP_REPORTRESOURCE = "ireport.jasperserver.report.resource";
    public static final String PROP_REPORTUNIT = "ireport.jasperserver.reportUnit";
    public static final String COM_JASPERSOFT_STUDIO_REPORT_UNIT_DESCRIPTION = "com.jaspersoft.studio.report.unit.description";
    protected IPath path;

    public static void initMetadata() {
        ArrayList<StandardPropertyMetadata> pm = new ArrayList<StandardPropertyMetadata>();
        StandardPropertyMetadata spm = new StandardPropertyMetadata();
        spm.setName(PROP_SERVERURL);
        spm.setLabel(Messages.AExporter_5);
        spm.setDescription(Messages.AExporter_6);
        spm.setValueType(URL.class.getName());
        ArrayList<PropertyScope> scopes = new ArrayList<PropertyScope>();
        scopes.add(PropertyScope.DATASET);
        spm.setScopes(scopes);
        spm.setCategory("com.jaspersoft.studio.jrs.category:JasperReports.server");
        pm.add(spm);
        spm = new StandardPropertyMetadata();
        spm.setName(PROP_USER);
        spm.setLabel(Messages.AExporter_7);
        spm.setDescription(Messages.AExporter_8);
        spm.setValueType(String.class.getName());
        scopes.add(PropertyScope.DATASET);
        spm.setScopes(scopes);
        spm.setCategory("com.jaspersoft.studio.jrs.category:JasperReports.server");
        pm.add(spm);
        spm = new StandardPropertyMetadata();
        spm.setName(PROP_REPORTRESOURCE);
        spm.setLabel(Messages.AExporter_9);
        spm.setDescription(Messages.AExporter_10);
        spm.setValueType("reppath");
        scopes.add(PropertyScope.DATASET);
        spm.setScopes(scopes);
        spm.setCategory("com.jaspersoft.studio.jrs.category:JasperReports.server");
        pm.add(spm);
        spm = new StandardPropertyMetadata();
        spm.setName(PROP_REPORTUNIT);
        spm.setLabel(Messages.AExporter_11);
        spm.setDescription(Messages.AExporter_12);
        spm.setValueType("rupath");
        scopes.add(PropertyScope.DATASET);
        spm.setScopes(scopes);
        spm.setCategory("com.jaspersoft.studio.jrs.category:JasperReports.server");
        pm.add(spm);
        spm = new StandardPropertyMetadata();
        spm.setName("com.jaspersoft.jrs.data.source");
        spm.setLabel(Messages.AExporter_13);
        spm.setDescription(Messages.AExporter_14);
        spm.setValueType("dspath");
        scopes.add(PropertyScope.DATASET);
        spm.setScopes(scopes);
        spm.setCategory("com.jaspersoft.studio.jrs.category:JasperReports.server");
        pm.add(spm);
        spm = new StandardPropertyMetadata();
        spm.setName(COM_JASPERSOFT_STUDIO_REPORT_UNIT_DESCRIPTION);
        spm.setLabel(Messages.AExporter_15);
        spm.setDescription(Messages.AExporter_16);
        spm.setValueType(String.class.getName());
        scopes.add(PropertyScope.REPORT);
        spm.setScopes(scopes);
        spm.setCategory("com.jaspersoft.studio.jrs.category:JasperReports.server");
        pm.add(spm);
        PropertyMetadataRegistry.addMetadata(pm);
    }

    public AExporter(IPath path) {
        this.path = path;
    }

    public IFile exportToIFile(AMResource res, ResourceDescriptor rd, String fkeyname, IProgressMonitor monitor) throws Exception {
        IFile f = this.getTempFile(res, rd, fkeyname, this.getExtension(res), monitor);
        if (f != null) {
            FileUtils.createResource((IResource)f, (IProgressMonitor)monitor);
            AExporter.setServerLocation(res, f);
        }
        return f;
    }

    public static void setServerLocation(AMResource res, IFile f) throws CoreException {
        if (f != null) {
            MServerProfile sp = (MServerProfile)res.getRoot();
            if (f.exists()) {
                if (sp != null) {
                    ServerProfile v = sp.getValue();
                    try {
                        f.setPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", PROP_SERVERURL), v.getUrl());
                        f.setPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", PROP_USER), AExporter.encodeUsr(v));
                    }
                    catch (MalformedURLException | URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
                f.setPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", PROP_REPORTRESOURCE), res.getValue().getUriString());
            }
        }
    }

    public static String encodeUsr(ServerProfile v) {
        String r;
        String string = r = v.isUseSSO() ? v.getSsoUuid() : v.getUser();
        if (!Misc.isNullOrEmpty((String)v.getOrganisation())) {
            r = String.valueOf(r) + "|" + v.getOrganisation();
        }
        return r;
    }

    protected String getExtension(AMResource res) {
        return "";
    }

    protected IFile getTempFile(AMResource res, ResourceDescriptor rd, String fkeyname, String dextention, IProgressMonitor monitor) throws Exception {
        String newpath;
        IFolder troot;
        IResource r;
        IFile f = fileurimap.get(fkeyname);
        if (this.path != null) {
            f = ResourcesPlugin.getWorkspace().getRoot().getFile(this.path);
            fileurimap.put(fkeyname, f);
            return this.downloadFile(res, rd, f, monitor);
        }
        INode root = res.getRoot();
        Object ttroot = null;
        ttroot = root instanceof MServerProfile ? ((MServerProfile)root).getTempWorkspaceLocation(monitor) : FileUtils.getInProjectFolder((URI)FileUtils.createTempDir().toURI(), (IProgressMonitor)monitor);
        String pfolder = rd.getParentFolder();
        if (pfolder.endsWith("_files")) {
            pfolder = pfolder.substring(0, pfolder.lastIndexOf("_files"));
        }
        if ((r = ttroot.findMember(pfolder)) instanceof IFile) {
            r.delete(true, monitor);
            r = null;
        }
        if (r == null || !r.exists()) {
            if (ttroot instanceof IFolder) {
                r = ((IFolder)ttroot).getFolder(pfolder);
            } else if (ttroot instanceof IProject) {
                r = ((IProject)ttroot).getFolder(pfolder);
            } else {
                throw new Exception("The temp workspace location for the JRS files can only be a project or folder instance. Check the settings!");
            }
        }
        if ((r = (troot = (IFolder)r).findMember(newpath = AExporter.getNewFileName(rd, dextention))) instanceof IFolder) {
            r.delete(true, monitor);
            r = null;
        }
        if (r == null || !r.exists()) {
            f = troot.getFile(newpath);
            File file = f.getFullPath().toFile();
            if (f.getLocationURI() != null) {
                file = f.getLocation().toFile();
            }
            file.getParentFile().mkdirs();
            file.createNewFile();
            String ffp = file.toURI().toASCIIString();
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                String ppath = String.valueOf(p.getLocationURI().toASCIIString()) + "/";
                if (ffp.startsWith(ppath)) {
                    p.refreshLocal(2, monitor);
                    f = p.getFile(ffp.substring(ppath.length()));
                }
                ++n2;
            }
        } else {
            f = (IFile)r;
        }
        fileurimap.put(fkeyname, f);
        return this.downloadFile(res, rd, f, monitor);
    }

    private IFile downloadFile(AMResource res, ResourceDescriptor rd, IFile f, IProgressMonitor monitor) {
        try {
            IPath p = f.getRawLocation();
            if (p == null) {
                p = f.getFullPath();
            }
            WSClientHelper.getResource(monitor, (ANode)res, rd, p.toFile());
            f.refreshLocal(1, monitor);
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
            return null;
        }
        return f;
    }

    public static String getNewFileName(ResourceDescriptor rd, String dextention) {
        String fname;
        String path = rd.getName();
        if (rd.getWsType().equals("img") && ((fname = path.toLowerCase()).endsWith(".jpg") || fname.endsWith(".jpeg") || fname.endsWith(".gif") || fname.endsWith(".tiff"))) {
            return path;
        }
        if (!path.contains(".") && dextention != null) {
            path = String.valueOf(path) + dextention;
        }
        return path;
    }
}

