/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.export;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.export.AExporter;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MJar;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;

public class JrxmlExporter
extends AExporter {
    public static final String PROP_REPORT_ISMAIN = "ireport.jasperserver.report.ismain";
    public static final QualifiedName KEY_REPORT_ISMAIN = new QualifiedName("com.jaspersoft.studio.server", "ireport.jasperserver.report.ismain");

    public JrxmlExporter(IPath path) {
        super(path);
    }

    @Override
    public IFile exportToIFile(AMResource res, ResourceDescriptor rd, String fkeyname, IProgressMonitor monitor) throws Exception {
        IFile f;
        block13: {
            f = super.exportToIFile(res, rd, fkeyname, monitor);
            if (f != null) {
                boolean disposeContext = false;
                JasperReportsConfiguration jrConfig = res.getJasperConfiguration();
                if (jrConfig == null) {
                    jrConfig = JasperReportsConfiguration.getDefaultJRConfig((IFile)f);
                    res.setJasperConfiguration(jrConfig);
                    disposeContext = true;
                } else {
                    jrConfig.init(f);
                }
                try {
                    try {
                        JasperDesign jd = JRXmlLoader.load((JasperReportsContext)jrConfig, (InputStream)f.getContents());
                        this.setPropServerURL((AFileResource)res, jd);
                        this.setPropReportUnit(res, jd);
                        this.getResources(res, jd);
                        MServerProfile sp = (MServerProfile)res.getRoot();
                        if (sp != null) {
                            f.setContents((InputStream)new ByteArrayInputStream(JRXmlWriterHelper.writeReport(null, (JRReport)jd, (String)sp.getValue().getJrVersion()).getBytes("UTF-8")), 3, monitor);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (disposeContext) {
                            jrConfig.dispose();
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (disposeContext) {
                        jrConfig.dispose();
                    }
                    throw throwable;
                }
                if (disposeContext) {
                    jrConfig.dispose();
                }
            }
        }
        if (f != null && f.exists()) {
            f.setPersistentProperty(KEY_REPORT_ISMAIN, Boolean.toString(res.getValue().isMainReport()));
        }
        return f;
    }

    protected void setPropServerURL(AFileResource res, JasperDesign jd) {
        INode n = res.getRoot();
        if (n != null && n instanceof MServerProfile) {
            MServerProfile server = (MServerProfile)n;
            ServerProfile v = server.getValue();
            try {
                jd.setProperty("ireport.jasperserver.url", v.getUrl());
                jd.setProperty("ireport.jasperserver.user", AExporter.encodeUsr(v));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    protected void setPropReportUnit(AMResource res, JasperDesign jd) {
        MReportUnit repunit;
        if (!res.getValue().isMainReport()) {
            jd.setProperty("ireport.jasperserver.report.resource", res.getValue().getUriString());
        }
        if ((repunit = res.getReportUnit()) != null) {
            ResourceDescriptor runit = repunit.getValue();
            if (runit != null) {
                jd.setProperty("ireport.jasperserver.reportUnit", runit.getUriString());
            }
            if (!Misc.isNullOrEmpty((String)runit.getDescription())) {
                jd.setProperty("com.jaspersoft.studio.report.unit.description", runit.getDescription());
            }
        } else {
            jd.getPropertiesMap().removeProperty("ireport.jasperserver.reportUnit");
        }
        if (!Misc.isNullOrEmpty((String)res.getValue().getDescription())) {
            jd.setProperty("com.jaspersoft.studio.report.description", res.getValue().getDescription());
        }
    }

    private void getResources(AMResource res, JasperDesign jd) throws Exception {
        if (res.getParent() instanceof MReportUnit) {
            for (INode n : res.getParent().getChildren()) {
                boolean cfr_ignored_0 = n instanceof MJar;
            }
        }
    }

    protected void cacheResource(AMResource res, JRExpression imgexp) throws Exception {
    }
}

