/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.ic;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.studio.server.editor.input.lov.KeyValueDialog;
import com.jaspersoft.studio.server.wizard.resource.LovLabelProvider;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class LovComposite {
    private List<ListItem> value;
    private ObjectMapper mapper = new ObjectMapper();
    private TableViewer tableViewer;

    public LovComposite(String v) {
        try {
            this.value = (List)this.mapper.readValue(v, (TypeReference)new TypeReference<List<ListItem>>(){});
        }
        catch (IOException iOException) {}
        if (this.value == null) {
            this.value = new ArrayList<ListItem>();
        }
    }

    public void createComposite(Composite composite) {
        this.buildTable(composite);
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        bGroup.setBackground(composite.getBackground());
        NewButton bnew = new NewButton(){

            protected void afterElementAdded(Object selement) {
                LovComposite.this.handleValueChanged();
            }
        };
        bnew.createNewButtons(bGroup, this.tableViewer, new INewElement(){

            public Object newElement(List<?> input, int pos) {
                KeyValueDialog d = new KeyValueDialog(UIUtils.getShell(), new ListItem(this.getName(), ""), LovComposite.this.value);
                if (d.open() == 0) {
                    ListItem li = new ListItem();
                    li.setLabel(d.getListItem().getLabel());
                    li.setValue(d.getListItem().getValue());
                    return li;
                }
                return null;
            }

            private String getName() {
                String name = "name";
                if (LovComposite.this.exists(name)) {
                    int i = 0;
                    while (i < 1000) {
                        if (!LovComposite.this.exists(String.valueOf(name) + "_" + i)) {
                            return String.valueOf(name) + "_" + i;
                        }
                        ++i;
                    }
                }
                return name;
            }
        });
        EditButton<ListItem> bedit = new EditButton<ListItem>(){

            protected void afterElementModified(ListItem element, List<ListItem> inlist, int ind) {
                LovComposite.this.handleValueChanged();
            }
        };
        bedit.createEditButtons(bGroup, this.tableViewer, (input, pos) -> {
            ListItem li = (ListItem)input.get(pos);
            KeyValueDialog d = new KeyValueDialog(UIUtils.getShell(), li, this.value);
            if (d.open() == 0) {
                li.setLabel(d.getListItem().getLabel());
                li.setValue(d.getListItem().getValue());
            }
        });
        bedit.editOnDoubleClick();
        DeleteButton bdel = new DeleteButton(){

            protected void afterElementDeleted(Object element) {
                LovComposite.this.handleValueChanged();
            }
        };
        bdel.createDeleteButton(bGroup, this.tableViewer);
        ListOrderButtons border = new ListOrderButtons();
        border.createOrderButtons(bGroup, this.tableViewer);
        border.addChangeListener(event -> this.handleValueChanged());
        this.tableViewer.setInput(this.value);
    }

    public void buildTable(Composite composite) {
        Table table = new Table(composite, 67586);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 300;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LovLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        table.setLayout((Layout)tlayout);
        TableColumn[] column = new TableColumn[2];
        column[0] = new TableColumn(table, 0);
        column[0].setText("Name");
        column[1] = new TableColumn(table, 0);
        column[1].setText("Value");
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
    }

    protected void handleValueChanged() {
    }

    private boolean exists(String v) {
        for (ListItem li : this.value) {
            if (!li.getLabel().equals(v)) continue;
            return true;
        }
        return false;
    }

    public String getValue() {
        try {
            return this.mapper.writeValueAsString(this.value);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

