/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.ic;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.studio.data.designer.ICQuery;
import com.jaspersoft.studio.data.designer.IFilterQuery;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.server.wizard.resource.StringValueDialog;
import com.jaspersoft.studio.server.wizard.resource.page.QueryPageContent;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import java.io.IOException;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class QueryComposite {
    private ICQuery value;
    private IFilterQuery fq;
    private ObjectMapper mapper = new ObjectMapper();
    private Text tQuery;
    private Text tValue;
    private TableViewer tableViewer;
    private Combo cLang;

    public QueryComposite(String v, IFilterQuery fq) {
        this.fq = fq;
        try {
            this.value = (ICQuery)this.mapper.readValue(v, ICQuery.class);
        }
        catch (IOException iOException) {}
        if (this.value == null) {
            this.value = new ICQuery();
        }
        if (fq != null) {
            this.value.language = fq.getLanguage();
        }
    }

    public void createComposite(Composite composite) {
        if (this.fq == null) {
            this.cLang = new Combo(composite, 8);
            this.cLang.setItems(QueryPageContent.LANGUAGES);
            this.cLang.add("jasperQL");
            this.cLang.addModifyListener(e -> {
                String string = this.value.language = this.cLang.getText();
            });
        }
        CTabFolder tabFolder = new CTabFolder(composite, 0x800080);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 400;
        tabFolder.setLayoutData((Object)gd);
        this.createQuery(tabFolder);
        this.createFields(tabFolder);
        if (this.fq != null) {
            Button btn = new Button(composite, 8);
            btn.setText(Messages.QueryDialog_1);
            btn.setLayoutData((Object)new GridData(64));
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        QueryComposite.this.value = (ICQuery)QueryComposite.this.mapper.readValue(QueryComposite.this.fq.getFilterQuery(), ICQuery.class);
                        QueryComposite.this.refresh();
                    }
                    catch (IOException e1) {
                        UIUtils.showError((Throwable)e1);
                    }
                }
            });
        }
        this.refresh();
    }

    private void createFields(CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.QueryDialog_2);
        Composite cmp = new Composite((Composite)tabFolder, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        cmp.setBackgroundMode(2);
        Composite scmp = new Composite(cmp, 0);
        scmp.setLayout((Layout)new GridLayout(2, false));
        scmp.setBackgroundMode(2);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        scmp.setLayoutData((Object)gd);
        new Label(scmp, 0).setText(Messages.QueryDialog_3);
        this.tValue = new Text(scmp, 2048);
        this.tValue.setLayoutData((Object)new GridData(768));
        this.tValue.addModifyListener(e -> {
            String string = this.value.valueField = this.tValue.getText();
        });
        this.buildTable(cmp);
        Composite bGroup = new Composite(cmp, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        bGroup.setBackground(cmp.getBackground());
        NewButton bnew = new NewButton(){

            protected void afterElementAdded(Object selement) {
                QueryComposite.this.handleValueChanged();
            }
        };
        bnew.createNewButtons(bGroup, this.tableViewer, (input, pos) -> {
            StringValueDialog d = new StringValueDialog(cmp.getShell(), Messages.QueryDialog_4);
            if (d.open() == 0) {
                return d.getValue();
            }
            return null;
        });
        EditButton<String> bedit = new EditButton<String>(){

            protected void afterElementModified(String element, List<String> inlist, int ind) {
                QueryComposite.this.handleValueChanged();
            }
        };
        bedit.createEditButtons(bGroup, this.tableViewer, (input, pos) -> {
            String li = (String)input.get(pos);
            StringValueDialog d = new StringValueDialog(UIUtils.getShell(), li);
            if (d.open() == 0) {
                input.set(pos, d.getValue());
            }
        });
        bedit.editOnDoubleClick();
        DeleteButton bdel = new DeleteButton(){

            protected void afterElementDeleted(Object element) {
                QueryComposite.this.handleValueChanged();
            }
        };
        bdel.createDeleteButton(bGroup, this.tableViewer);
        ListOrderButtons border = new ListOrderButtons();
        border.createOrderButtons(bGroup, this.tableViewer);
        border.addChangeListener(event -> this.handleValueChanged());
        this.tableViewer.setInput((Object)this.value.columns);
        UIUtils.getDisplay().asyncExec(() -> tabFolder.setSelection(0));
        bptab.setControl((Control)cmp);
    }

    private void createQuery(CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText(Messages.DataQueryAdapters_querytab);
        Composite cmp = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        cmp.setLayout((Layout)layout);
        cmp.setBackgroundMode(2);
        this.tQuery = new Text(cmp, 2050);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 100;
        gd.widthHint = 250;
        this.tQuery.setLayoutData((Object)gd);
        this.tQuery.addModifyListener(e -> {
            this.value.query = this.tQuery.getText();
            this.handleValueChanged();
        });
        bptab.setControl((Control)cmp);
    }

    private void buildTable(Composite composite) {
        Table table = new Table(composite, 67586);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 250;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)tlayout);
        TableColumn tc = new TableColumn(table, 0);
        tc.setText(Messages.QueryDialog_5);
        tc.pack();
    }

    private void refresh() {
        if (this.value == null) {
            this.value = new ICQuery();
        }
        this.tQuery.setText(Misc.nvl((String)this.value.query));
        this.tValue.setText(Misc.nvl((String)this.value.valueField));
        this.tableViewer.setInput((Object)this.value.columns);
        if (this.cLang != null) {
            this.cLang.setText(Misc.nvl((String)this.value.language));
        }
    }

    protected void handleValueChanged() {
    }

    public String getValue() {
        try {
            if (this.value.language == null) {
                this.value.language = this.fq.getLanguage();
            }
            return this.mapper.writeValueAsString((Object)this.value);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

