/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.ic;

import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.property.descriptor.properties.dialog.PropertyDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.export.AExporter;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.properties.dialog.RepositoryDialog;
import com.jaspersoft.studio.server.selector.SelectServerWizard;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.manager.DoubleControlComposite;
import com.jaspersoft.studio.widgets.framework.manager.WidgetFactory;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.FilePropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRDataset;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ResourcePropertyDescription
extends FilePropertyDescription {
    private JRDataset ds;
    private Object element;

    public ResourcePropertyDescription() {
    }

    public ResourcePropertyDescription(String name, String label, String description, boolean mandatory, String defaultValue) {
        super(name, label, description, mandatory, defaultValue);
    }

    public ResourcePropertyDescription(String name, String label, String description, boolean mandatory, String defaultValue, Object element) {
        super(name, label, description, mandatory, defaultValue);
        PropertyExpressionsDTO dto;
        List dts;
        this.element = element;
        if (element instanceof PropertyDTO) {
            PropertyDTO dto2 = (PropertyDTO)element;
            List dts2 = dto2.geteContext().getDatasets();
            if (dts2 != null && !dts2.isEmpty()) {
                this.ds = (JRDataset)dts2.get(0);
            }
        } else if (element instanceof PropertyExpressionsDTO && (dts = (dto = (PropertyExpressionsDTO)element).geteContext().getDatasets()) != null && !dts.isEmpty()) {
            this.ds = (JRDataset)dts.get(0);
        }
    }

    protected void createToolbarButton(Composite parent, final IWItemProperty wiProp) {
        ToolBar toolBar = new ToolBar(parent, 0);
        ToolItem b = new ToolItem(toolBar, 0x800000);
        b.setImage(this.getButtonImage());
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (wiProp.isRefresh()) {
                    return;
                }
                wiProp.setRefresh(true);
                try {
                    RepositoryDialog rd;
                    MServerProfile profile = ResourcePropertyDescription.this.getServerProfile(wiProp);
                    if (profile != null && (rd = new RepositoryDialog(UIUtils.getShell(), (INode)profile){

                        @Override
                        public boolean isResourceCompatible(AMResource r) {
                            return this.isResourceCompatible(r);
                        }
                    }).open() == 0) {
                        AMResource rs = rd.getResource();
                        if (rs != null) {
                            wiProp.setValue(rs.getValue().getUriString(), null);
                        } else {
                            wiProp.setValue(null, null);
                        }
                    }
                }
                finally {
                    wiProp.setRefresh(false);
                }
            }
        });
        GridData data = new GridData();
        data.verticalAlignment = 128;
        toolBar.setLayoutData((Object)data);
        if (this.isReadOnly()) {
            toolBar.setEnabled(false);
        }
    }

    protected boolean isResourceCompatible(AMResource r) {
        return true;
    }

    private MServerProfile getServerProfile(IWItemProperty wiProp) {
        MServerProfile msp;
        String servURL = null;
        String servUser = null;
        if (this.ds != null) {
            servURL = this.ds.getPropertiesMap().getProperty("ireport.jasperserver.url");
            servUser = this.ds.getPropertiesMap().getProperty("ireport.jasperserver.user");
        }
        if ((msp = ServerManager.getServerByUrl(servURL, servUser)) == null) {
            SelectServerWizard wizard = new SelectServerWizard();
            WizardDialog w = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
            if (w.open() == 0) {
                msp = wizard.getValue();
                try {
                    if (this.element instanceof PropertyExpressionsDTO) {
                        PropertyExpressionsDTO dto = (PropertyExpressionsDTO)this.element;
                        dto.addProperty("ireport.jasperserver.url", msp.getValue().getUrl(), false, false);
                        dto.addProperty("ireport.jasperserver.user", String.valueOf(msp.getValue().getUser()) + (msp.getValue().getOrganisation() != null ? "|" + msp.getValue().getOrganisation() : ""), false, false);
                    } else if (this.ds != null) {
                        this.ds.getPropertiesMap().setProperty("ireport.jasperserver.url", msp.getValue().getUrl());
                        this.ds.getPropertiesMap().setProperty("ireport.jasperserver.user", AExporter.encodeUsr(msp.getValue()));
                    }
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
                catch (URISyntaxException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return msp;
    }

    protected void lazyCreateExpressionControl(IWItemProperty wiProp, DoubleControlComposite cmp) {
        if (wiProp.isExpressionMode() && cmp.getFirstContainer().getChildren().length == 0) {
            cmp.getFirstContainer().setLayout((Layout)WidgetFactory.getNoPadLayout((int)1));
            Control expressionControl = this.createExpressionControl(wiProp, cmp.getFirstContainer());
            cmp.getFirstContainer().setData((Object)expressionControl);
            cmp.setExpressionControlToHighlight(expressionControl);
        }
    }

    public ItemPropertyDescription<String> clone() {
        ResourcePropertyDescription result = new ResourcePropertyDescription();
        result.defaultValue = (String)this.defaultValue;
        result.description = this.description;
        result.jConfig = this.jConfig;
        result.label = this.label;
        result.mandatory = this.mandatory;
        result.name = this.name;
        result.readOnly = this.readOnly;
        result.fallbackValue = (String)this.fallbackValue;
        return result;
    }

    public ItemPropertyDescription<?> getInstance(WidgetsDescriptor cd, WidgetPropertyDescriptor cpd, JasperReportsConfiguration jConfig) {
        ResourcePropertyDescription fileDesc = new ResourcePropertyDescription(cpd.getName(), cd.getLocalizedString(cpd.getLabel()), cd.getLocalizedString(cpd.getDescription()), cpd.isMandatory(), cpd.getDefaultValue());
        fileDesc.setjConfig(jConfig);
        fileDesc.setReadOnly(cpd.isReadOnly());
        fileDesc.setFallbackValue(cpd.getFallbackValue());
        return fileDesc;
    }
}

