/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.properties;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.properties.ASection;
import java.io.File;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class AResourceSection
extends ASection {
    private Text trefuri;
    private Button bimport;
    private Button bexport;

    @Override
    protected void createSectionControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(3, false));
        cmp.setLayoutData((Object)new GridData(768));
        cmp.setBackground(parent.getBackground());
        this.bexport = new Button(cmp, 8);
        this.bexport.setText("Download File");
        this.bexport.setImage(Activator.getDefault().getImage("icons/drive-download.png"));
        this.bexport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(Display.getDefault().getActiveShell(), 8192);
                fd.setFilterExtensions(AResourceSection.this.getFilter());
                fd.setText("Save Resource To File ...");
                String filename = fd.open();
                if (filename != null) {
                    try {
                        WSClientHelper.getResource((IProgressMonitor)new NullProgressMonitor(), (ANode)AResourceSection.this.res, AResourceSection.this.res.getValue(), filename);
                        File file = new File(filename);
                        int dotPos = filename.lastIndexOf(".");
                        String strFilename = filename.substring(0, dotPos);
                        ImageTypeEnum itype = JRTypeSniffer.getImageTypeValue((byte[])FileUtils.getBytes((File)file));
                        if (itype == ImageTypeEnum.GIF) {
                            this.fileRenamed(file, strFilename, ".gif");
                        } else if (itype == ImageTypeEnum.JPEG) {
                            this.fileRenamed(file, strFilename, ".jpeg");
                        } else if (itype == ImageTypeEnum.PNG) {
                            this.fileRenamed(file, strFilename, ".png");
                        } else if (itype == ImageTypeEnum.TIFF) {
                            this.fileRenamed(file, strFilename, ".tiff");
                        }
                    }
                    catch (Exception e1) {
                        UIUtils.showError((Throwable)e1);
                    }
                }
            }

            private void fileRenamed(File file, String strFilename, String ext) {
                String fname = String.valueOf(strFilename) + ext;
                file.renameTo(new File(fname));
                UIUtils.showWarning((String)("Attention! file type is different, so it was renamed to:\n " + fname));
            }
        });
        this.bimport = new Button(cmp, 8);
        this.bimport.setText("Upload File");
        this.bimport.setImage(Activator.getDefault().getImage("icons/drive-upload.png"));
        this.bimport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(Display.getDefault().getActiveShell(), 4096);
                fd.setFilterExtensions(AResourceSection.this.getFilter());
                fd.setText("Select Resource File ...");
                String filename = fd.open();
                if (filename != null) {
                    ((AFileResource)AResourceSection.this.res).setFile(new File(filename));
                    AResourceSection.this.bindingContext.updateTargets();
                }
            }
        });
        this.trefuri = this.getWidgetFactory().createText(cmp, "", 2056);
        this.trefuri.setLayoutData((Object)new GridData(768));
    }

    @Override
    public void enableFields(boolean enable) {
        this.trefuri.setEditable(enable);
        this.bimport.setEnabled(enable);
    }

    @Override
    protected void bind() {
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)0).observe((Widget)this.trefuri), PojoProperties.value((String)"fileName").observe((Object)this.res));
    }

    protected abstract String[] getFilter();
}

