/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol.restv2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.jasperserver.dto.resources.ClientReportUnit;
import com.jaspersoft.studio.server.protocol.restv2.ARestV2Connection;
import com.jaspersoft.studio.server.protocol.restv2.ClassSelector;
import com.jaspersoft.studio.server.protocol.restv2.JSSApacheConnectorFactory;
import com.jaspersoft.studio.server.protocol.restv2.WsTypes;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ARestV2ConnectionJersey
extends ARestV2Connection {
    protected WebTarget target;
    protected JSSApacheConnectorFactory connector;
    protected Client client;

    public JSSApacheConnectorFactory getConnector() {
        return this.connector;
    }

    public <T> T toObj(Response res, Class<T> clazz, IProgressMonitor monitor) throws IOException {
        Object r = null;
        try {
            try {
                switch (res.getStatus()) {
                    case 200: 
                    case 201: {
                        r = res.readEntity(this.checkClazz(res, clazz));
                    }
                    case 204: {
                        break;
                    }
                    default: {
                        this.eh.handleException(res, monitor);
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
                throw e;
            }
        }
        finally {
            res.close();
        }
        return (T)r;
    }

    public <T> T toObj(Response res, ClassSelector selector, IProgressMonitor monitor) throws IOException {
        Object r = null;
        try {
            try {
                switch (res.getStatus()) {
                    case 200: 
                    case 201: {
                        r = res.readEntity(selector.checkClazz(res));
                    }
                    case 204: {
                        break;
                    }
                    default: {
                        this.eh.handleException(res, monitor);
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
                throw e;
            }
        }
        finally {
            res.close();
        }
        return (T)r;
    }

    public <T> T toObjFromMapper(Response res, ClassSelector selector, IProgressMonitor monitor, ObjectMapper mapper) throws IOException {
        Object r = null;
        try {
            try {
                switch (res.getStatus()) {
                    case 200: 
                    case 201: {
                        String str = (String)res.readEntity(String.class);
                        r = mapper.readValue(str, selector.checkClazz(res));
                    }
                    case 204: {
                        break;
                    }
                    default: {
                        this.eh.handleException(res, monitor);
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
                throw e;
            }
        }
        finally {
            res.close();
        }
        return (T)r;
    }

    protected <T> Class<T> checkClazz(Response res, Class<T> clazz) {
        if (clazz == null) {
            String type = res.getHeaderString("Content-Type");
            if (type.equals("application/xml")) {
                return String.class;
            }
            if (type.equals("text/plain")) {
                return String.class;
            }
            if (type.equals("application/repository.reportunit+json")) {
                return ClientReportUnit.class;
            }
            if (type.equals("application/repository.file+json")) {
                return ClientFile.class;
            }
            int sind = type.indexOf(46);
            int eind = type.indexOf(43);
            if (sind >= 0 && eind >= 0) {
                type = type.substring(sind + 1, eind);
                clazz = WsTypes.INST().getType(type);
            }
        }
        return clazz;
    }

    protected <T> T toObj(Response res, GenericType<T> type, IProgressMonitor monitor) throws IOException {
        Object r = null;
        try {
            try {
                switch (res.getStatus()) {
                    case 200: 
                    case 201: {
                        r = res.readEntity(type);
                    }
                    case 204: {
                        break;
                    }
                    default: {
                        this.eh.handleException(res, monitor);
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
                throw e;
            }
        }
        finally {
            res.close();
        }
        return (T)r;
    }

    public <T> T toObj(Response res, Class<T> type, IProgressMonitor monitor, ObjectMapper mapper) throws IOException {
        Object r = null;
        try {
            try {
                switch (res.getStatus()) {
                    case 200: 
                    case 201: {
                        InputStream in = (InputStream)res.readEntity(InputStream.class);
                        if (in != null) {
                            try {
                                r = mapper.readValue(in, type);
                            }
                            finally {
                                FileUtils.closeStream((Closeable)in);
                            }
                        }
                        break;
                    }
                    case 204: {
                        break;
                    }
                    default: {
                        this.eh.handleException(res, monitor);
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
                throw e;
            }
        }
        finally {
            res.close();
        }
        return (T)r;
    }

    protected void readFile(Response res, File f, IProgressMonitor monitor) throws IOException {
        try {
            try {
                switch (res.getStatus()) {
                    case 200: 
                    case 201: {
                        InputStream in = (InputStream)res.readEntity(InputStream.class);
                        if (in != null) {
                            FileOutputStream out = new FileOutputStream(f);
                            try {
                                IOUtils.copy((InputStream)in, (OutputStream)out);
                            }
                            finally {
                                FileUtils.closeStream((Closeable)out);
                                FileUtils.closeStream((Closeable)in);
                            }
                        }
                        break;
                    }
                    case 204: {
                        break;
                    }
                    default: {
                        this.eh.handleException(res, monitor);
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
                throw e;
            }
        }
        finally {
            res.close();
        }
    }

    protected byte[] readFile(Response res, IProgressMonitor monitor) throws IOException {
        byte[] b = null;
        try {
            try {
                switch (res.getStatus()) {
                    case 200: 
                    case 201: {
                        InputStream in = (InputStream)res.readEntity(InputStream.class);
                        if (in != null) {
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            try {
                                int bytesRead;
                                byte[] data = new byte[1000];
                                while ((bytesRead = in.read(data)) != -1) {
                                    out.write(data, 0, bytesRead);
                                }
                                b = out.toByteArray();
                            }
                            finally {
                                FileUtils.closeStream((Closeable)out);
                                FileUtils.closeStream((Closeable)in);
                            }
                        }
                        break;
                    }
                    case 204: {
                        break;
                    }
                    default: {
                        this.eh.handleException(res, monitor);
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
                throw e;
            }
        }
        finally {
            res.close();
        }
        return b;
    }

    protected void writeFile(Response res, InputStream in, IProgressMonitor monitor) throws IOException {
        try {
            switch (res.getStatus()) {
                case 200: 
                case 201: {
                    res.readEntity(String.class);
                }
                case 204: {
                    break;
                }
                default: {
                    this.eh.handleException(res, monitor);
                    break;
                }
            }
        }
        finally {
            FileUtils.closeStream((Closeable)in);
            res.close();
        }
    }

    public ARestV2ConnectionJersey() {
        this.setParent(this);
    }

    public WebTarget getTarget() {
        return this.target;
    }
}

