/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol.restv2;

import com.jaspersoft.studio.server.messages.Messages;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jersey.repackaged.com.google.common.collect.Lists;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.WordUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class CertificateDialog
extends ATitledDialog {
    private X509Certificate client;
    private String message;
    private X509Certificate[] chain;
    protected TableViewer viewer;
    private static Map<String, String> certExtensions = new HashMap<String, String>();

    static {
        certExtensions.put("2.5.29.1", Messages.CertificateDialog_52);
        certExtensions.put("2.5.29.2", Messages.CertificateDialog_54);
        certExtensions.put("2.5.29.3", Messages.CertificateDialog_56);
        certExtensions.put("2.5.29.4", Messages.CertificateDialog_58);
        certExtensions.put("2.5.29.9", Messages.CertificateDialog_60);
        certExtensions.put("2.5.29.14", Messages.CertificateDialog_62);
        certExtensions.put("2.5.29.15", Messages.CertificateDialog_64);
        certExtensions.put("2.5.29.16", Messages.CertificateDialog_66);
        certExtensions.put("2.5.29.17", Messages.CertificateDialog_68);
        certExtensions.put("2.5.29.18", Messages.CertificateDialog_70);
        certExtensions.put("2.5.29.19", Messages.CertificateDialog_72);
        certExtensions.put("2.5.29.20", Messages.CertificateDialog_74);
        certExtensions.put("2.5.29.21", Messages.CertificateDialog_76);
        certExtensions.put("2.5.29.23", Messages.CertificateDialog_78);
        certExtensions.put("2.5.29.24", Messages.CertificateDialog_80);
        certExtensions.put("2.5.29.27", Messages.CertificateDialog_82);
        certExtensions.put("2.5.29.28", Messages.CertificateDialog_84);
        certExtensions.put("2.5.29.29", Messages.CertificateDialog_86);
        certExtensions.put("2.5.29.30", Messages.CertificateDialog_88);
        certExtensions.put("2.5.29.31", Messages.CertificateDialog_90);
        certExtensions.put("2.5.29.32", Messages.CertificateDialog_92);
        certExtensions.put("2.5.29.33", Messages.CertificateDialog_94);
        certExtensions.put("2.5.29.35", Messages.CertificateDialog_96);
        certExtensions.put("2.5.29.36", Messages.CertificateDialog_98);
        certExtensions.put("2.5.29.37", Messages.CertificateDialog_100);
        certExtensions.put("2.5.29.46", Messages.CertificateDialog_102);
        certExtensions.put("2.5.29.54", Messages.CertificateDialog_104);
    }

    public CertificateDialog(Shell parentShell, String message, X509Certificate client, X509Certificate[] chain) {
        super(parentShell, 67680, false);
        this.setTitle(Messages.CertificateDialog_0);
        this.client = client;
        this.message = message;
        this.chain = chain;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.CertificateDialog_1, true);
        this.createButton(parent, 1, Messages.CertificatesDialog_2, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        this.createLabel1(cmp);
        this.viewer = new TableViewer(cmp, 68354);
        TableViewerColumn col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setWidth(600);
        col.setLabelProvider((CellLabelProvider)new CertificateLabelProvider());
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        List input = Lists.reverse(Arrays.asList(this.chain));
        this.viewer.setInput((Object)input);
        Table table = this.viewer.getTable();
        GridData gd = new GridData(768);
        gd.heightHint = 70;
        gd.widthHint = 500;
        table.setLayoutData((Object)gd);
        StyledText cTxt = new StyledText(cmp, 778);
        cTxt.setLeftMargin(3);
        cTxt.setTopMargin(3);
        cTxt.setLineSpacing(1);
        gd = new GridData(1808);
        gd.widthHint = 500;
        gd.heightHint = 400;
        cTxt.setLayoutData((Object)gd);
        this.viewer.addSelectionChangedListener(event -> {
            StructuredSelection sel = (StructuredSelection)this.viewer.getSelection();
            StyledString ss = CertificateDialog.getStyledToolTip((X509Certificate)sel.getFirstElement());
            cTxt.setText(ss.getString());
            cTxt.setStyleRanges(ss.getStyleRanges());
        });
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.client), true);
        return cmp;
    }

    protected void createLabel1(Composite cmp) {
        StyledText lbl1 = new StyledText(cmp, 72);
        lbl1.setLineSpacing(2);
        lbl1.setBackground(cmp.getBackground());
        String msg1 = Messages.CertificateDialog_2;
        lbl1.setText(String.valueOf(msg1) + this.message);
        lbl1.setStyleRanges(new StyleRange[]{new StyleRange(0, msg1.length(), null, null, 1), new StyleRange(msg1.length(), this.message.length(), null, null, 2)});
        lbl1.setLayoutData((Object)new GridData(768));
    }

    public static CertificateLabelProvider getLabelProvider() {
        return new CertificateLabelProvider();
    }

    public static StyledString getStyledToolTip(X509Certificate cert) {
        StyledString ss = new StyledString();
        if (cert == null) {
            return ss;
        }
        ss.append(Messages.CertificateDialog_4, StyledString.QUALIFIER_STYLER);
        ss.append(" " + cert.getVersion() + "\n");
        ss.append(Messages.CertificateDialog_7, StyledString.QUALIFIER_STYLER);
        ss.append(" " + cert.getSerialNumber() + "\n");
        ss.append(Messages.CertificateDialog_10, StyledString.QUALIFIER_STYLER);
        ss.append(" " + cert.getSigAlgName() + " (" + cert.getSigAlgOID() + ")\n");
        ss.append(Messages.CertificateDialog_14, StyledString.QUALIFIER_STYLER);
        ss.append(" " + Misc.nvl((Object)cert.getSigAlgParams(), (String)Messages.CertificateDialog_16) + "\n");
        ss.append(Messages.CertificateDialog_18, StyledString.QUALIFIER_STYLER);
        ss.append(" " + cert.getIssuerDN() + "\n");
        ss.append(Messages.CertificateDialog_21, StyledString.QUALIFIER_STYLER);
        ss.append(" " + cert.getNotBefore() + "\n");
        ss.append(Messages.CertificateDialog_24, StyledString.QUALIFIER_STYLER);
        ss.append(" " + cert.getNotAfter() + "\n\n");
        ss.append(Messages.CertificateDialog_27, StyledString.QUALIFIER_STYLER);
        ss.append(" " + cert.getSubjectDN() + "\n\n");
        ss.append(Messages.CertificateDialog_30, StyledString.QUALIFIER_STYLER);
        ss.append(" " + WordUtils.wrap((String)cert.getPublicKey().toString(), (int)50, null, (boolean)true) + "\n");
        ss.append(Messages.CertificateDialog_33, StyledString.QUALIFIER_STYLER);
        ss.append(" " + cert.getSigAlgName() + "\n");
        ss.append(Messages.CertificateDialog_36, StyledString.QUALIFIER_STYLER);
        ss.append(" " + WordUtils.wrap((String)Hex.encodeHexString((byte[])cert.getSignature()), (int)50, null, (boolean)true) + "\n");
        ss.append(Messages.CertificateDialog_39, StyledString.QUALIFIER_STYLER);
        for (String ext : cert.getCriticalExtensionOIDs()) {
            ss.append(Messages.CertificateDialog_40, StyledString.QUALIFIER_STYLER);
            ss.append(String.valueOf(Messages.CertificateDialog_41) + Misc.nvl((String)certExtensions.get(ext)) + " (" + ext + ")\n");
            try {
                ss.append(String.valueOf(CertificateDialog.getExtensionValue(cert, ext)) + "\n");
            }
            catch (IOException iOException) {}
        }
        for (String ext : cert.getNonCriticalExtensionOIDs()) {
            ss.append(Messages.CertificateDialog_45, StyledString.QUALIFIER_STYLER);
            ss.append(String.valueOf(Messages.CertificateDialog_46) + Misc.nvl((String)certExtensions.get(ext)) + " (" + ext + ")\n");
            try {
                ss.append(String.valueOf(CertificateDialog.getExtensionValue(cert, ext)) + "\n");
            }
            catch (IOException iOException) {}
        }
        return ss;
    }

    private static String getExtensionValue(X509Certificate X509Certificate2, String oid) throws IOException {
        byte[] extensionValue = X509Certificate2.getExtensionValue(oid);
        return CertificateDialog.fromByteArray(extensionValue);
    }

    private static String fromByteArray(byte[] extensionValue) throws IOException {
        ASN1Primitive derObject;
        if (extensionValue != null && (derObject = CertificateDialog.toDERObject(extensionValue)) instanceof DEROctetString) {
            if ((derObject = CertificateDialog.toDERObject(((DEROctetString)derObject).getOctets())) instanceof DERUTF8String) {
                return DERUTF8String.getInstance((Object)derObject).getString();
            }
            if (derObject instanceof DERBitString) {
                return DERBitString.getInstance((Object)derObject).getString();
            }
            if (derObject instanceof DERSequence) {
                return DERSequence.getInstance((Object)derObject).toString();
            }
            if (derObject instanceof DEROctetString) {
                return DEROctetString.getInstance((Object)derObject).toString();
            }
            return derObject.getClass().getCanonicalName();
        }
        return "";
    }

    private static ASN1Primitive toDERObject(byte[] data) throws IOException {
        ASN1Primitive der = null;
        ByteArrayInputStream inStream = new ByteArrayInputStream(data);
        ASN1InputStream asnInputStream = new ASN1InputStream((InputStream)inStream);
        try {
            der = asnInputStream.readObject();
        }
        finally {
            FileUtils.closeStream((Closeable)inStream);
            FileUtils.closeStream((Closeable)asnInputStream);
        }
        return der;
    }

    public static class CertificateLabelProvider
    extends ColumnLabelProvider {
        public String getText(Object element) {
            if (element instanceof X509Certificate) {
                return ((X509Certificate)element).getSubjectDN().getName();
            }
            if (element instanceof Key) {
                return "Key";
            }
            if (element != null) {
                return element.toString();
            }
            return "NULL";
        }
    }
}

