/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol.restv2;

import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import net.sf.jasperreports.eclipse.util.HttpUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.spi.Connector;

public class JSSApacheConnectorFactory
extends ApacheConnectorProvider {
    private Connector conn;

    public Connector getConnector(Client client, Configuration runtimeConfig) {
        this.conn = super.getConnector(client, runtimeConfig);
        return this.conn;
    }

    private Response doWait(Future<Response> rf, IProgressMonitor monitor) throws Exception {
        try {
            if (monitor != null) {
                while (!rf.isDone() && !rf.isCancelled()) {
                    if (monitor.isCanceled()) {
                        rf.cancel(true);
                    }
                    Thread.sleep(5L);
                }
            }
            return rf.get();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (ExecutionException e) {
            throw e;
        }
    }

    public synchronized Response get(Invocation.Builder builder, IProgressMonitor monitor) throws Exception {
        builder.header("Accept-Timezone", (Object)TimeZone.getDefault().getID());
        builder.header("User-Agent", (Object)HttpUtils.USER_AGENT_JASPERSOFT_STUDIO);
        builder.header("Cache-Control", (Object)"no-cache");
        return this.doWait(builder.async().get(), monitor);
    }

    public Response delete(Invocation.Builder builder, IProgressMonitor monitor) throws Exception {
        builder.header("Accept-Timezone", (Object)TimeZone.getDefault().getID());
        return this.doWait(builder.async().delete(), monitor);
    }

    public Response post(Invocation.Builder builder, Entity<?> entity, IProgressMonitor monitor) throws Exception {
        return this.post(builder, entity, monitor, TimeZone.getDefault());
    }

    public Response post(Invocation.Builder builder, Entity<?> entity, IProgressMonitor monitor, TimeZone tz) throws Exception {
        return this.post(builder, entity, monitor, tz != null ? tz.getID() : null);
    }

    public Response post(Invocation.Builder builder, Entity<?> entity, IProgressMonitor monitor, String tz) throws Exception {
        if (tz != null) {
            builder.header("Accept-Timezone", (Object)tz);
        }
        return this.doWait(builder.async().post(entity), monitor);
    }

    public Response put(Invocation.Builder builder, Entity<?> entity, IProgressMonitor monitor) throws Exception {
        builder.header("Accept-Timezone", (Object)TimeZone.getDefault().getID());
        builder.header("X-HTTP-Method-Override", (Object)"PUT");
        return this.doWait(builder.async().post(entity), monitor);
    }
}

